/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.internal;

import org.eclipse.core.internal.resources.OS;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardPreferences;
import org.eclipse.soda.sat.plugin.activator.bundle.Activator;

public class ActivatorWizardPreferences
implements IActivatorWizardPreferences {
    private static final String DEFAULT_ACTIVATOR_CLASS_NAME = "Activator";
    private static final boolean DEFAULT_CREATE_EXPORTED_PROXY_SERVICES = false;
    private static final boolean DEFAULT_DO_NOT_SHOW_PREVIEW_PAGE = false;
    private static final boolean DEFAULT_EXPORT_SERVICES_WITH_PROPERTIES = false;
    private static final boolean DEFAULT_GENERATE_REQUIRED_IMPORTED_SERVICES_GETTER_METHODS = true;
    private static final boolean DEFAULT_LIMIT_SERVICES_TO_INTERFACE_TYPES = true;
    private static final boolean DEFAULT_LIMIT_SERVICES_TO_TYPES_VISIBLE_TO_THE_PROJECT = true;
    private static final boolean DEFAULT_OPTIONALLY_IMPORT_SERVICES = false;
    private static final boolean DEFAULT_OVERWRITE_BUNDLE_ACTIVATOR_MANIFEST_HEADER = false;
    private static final boolean DEFAULT_OVERWRITE_LAZY_BUNDLE_ACTIVATOR_MANIFEST_HEADER = false;
    private static final String DEFAULT_PACKAGE_SUFFIX = "bundle";
    private static final boolean DEFAULT_STORE_EXPORTED_SERVICES_IN_FIELDS = false;
    private static final String CLASS_NAME = "className";
    private static final String CREATE_EXPORTED_PROXY_SERVICES = "createExportedProxyServices";
    private static final String DO_NOT_SHOW_PREVIEW_PAGE = "doNotShowPreviewPage";
    private static final String EXPORT_SERVICES_WITH_PROPERTIES = "exportServicesWithProperties";
    private static final String GENERATE_REQUIRED_IMPORTED_SERVICES_GETTER_METHODS = "generateRequiredImportedServiceGetterMethods";
    private static final String LIMIT_SERVICES_TO_INTERFACE_TYPES = "limitServicesToInterfaceTypes";
    private static final String LIMIT_SERVICES_TO_TYPES_VISIBLE_TO_THE_PROJECT = "limitServicesToTypesVisibleToTheProject";
    private static final String OPTIONALLY_IMPORT_SERVICES = "optionallyImportServices";
    private static final String OVERWRITE_BUNDLE_ACTIVATOR_MANIFEST_HEADER = "overwriteBundleActivatorManifestHeader";
    private static final String OVERWRITE_LAZY_BUNDLE_ACTIVATOR_MANIFEST_HEADER = "overwriteLazyBundleActivatorManifestHeader";
    private static final String PACKAGE_NAME_SUFFIX = "packageNameSuffix";
    private static final String STORE_EXPORTED_SERVICES_IN_FIELDS = "storeExportedServicesInFields";
    private Preferences model;

    public ActivatorWizardPreferences(Preferences preferences) {
        this.setModel(preferences);
    }

    private boolean getBooleanPreference(String key) {
        Preferences model = this.getModel();
        boolean value = model.getBoolean(key);
        return value;
    }

    public String getClassName() {
        String host = this.getStringPreference(CLASS_NAME);
        return host;
    }

    public boolean getCreateExportedProxyServices() {
        boolean state = this.getBooleanPreference(CREATE_EXPORTED_PROXY_SERVICES);
        return state;
    }

    private boolean getDefaultBooleanPreference(String key) {
        Preferences model = this.getModel();
        boolean value = model.getDefaultBoolean(key);
        return value;
    }

    public String getDefaultClassName() {
        String value = this.getDefaultStringPreference(CLASS_NAME);
        return value;
    }

    public boolean getDefaultCreateExportedProxyServices() {
        boolean state = this.getDefaultBooleanPreference(CREATE_EXPORTED_PROXY_SERVICES);
        return state;
    }

    public boolean getDefaultDoNotShowPreviewPage() {
        boolean state = this.getDefaultBooleanPreference(DO_NOT_SHOW_PREVIEW_PAGE);
        return state;
    }

    public boolean getDefaultExportServicesWithProperties() {
        boolean state = this.getDefaultBooleanPreference(EXPORT_SERVICES_WITH_PROPERTIES);
        return state;
    }

    public boolean getDefaultGenerateRequiredImportedServiceGetterMethods() {
        boolean state = this.getDefaultBooleanPreference(GENERATE_REQUIRED_IMPORTED_SERVICES_GETTER_METHODS);
        return state;
    }

    public boolean getDefaultLimitServicesToInterfaceTypes() {
        boolean state = this.getDefaultBooleanPreference(LIMIT_SERVICES_TO_INTERFACE_TYPES);
        return state;
    }

    public boolean getDefaultLimitServicesToTypesVisibleToTheProject() {
        boolean state = this.getDefaultBooleanPreference(LIMIT_SERVICES_TO_TYPES_VISIBLE_TO_THE_PROJECT);
        return state;
    }

    public boolean getDefaultOptionallyImportServices() {
        boolean state = this.getDefaultBooleanPreference(OPTIONALLY_IMPORT_SERVICES);
        return state;
    }

    public boolean getDefaultOverwriteManifest() {
        boolean state = this.getDefaultBooleanPreference(OVERWRITE_BUNDLE_ACTIVATOR_MANIFEST_HEADER);
        return state;
    }

    public String getDefaultPackageNameSuffix() {
        String value = this.getDefaultStringPreference(PACKAGE_NAME_SUFFIX);
        return value;
    }

    public boolean getDefaultStoreExportedServicesInFields() {
        boolean state = this.getDefaultBooleanPreference(STORE_EXPORTED_SERVICES_IN_FIELDS);
        return state;
    }

    private String getDefaultStringPreference(String key) {
        Preferences model = this.getModel();
        String value = model.getDefaultString(key);
        return value;
    }

    public boolean getDoNotShowPreviewPage() {
        boolean state = this.getBooleanPreference(DO_NOT_SHOW_PREVIEW_PAGE);
        return state;
    }

    public boolean getExportServicesWithProperties() {
        boolean state = this.getBooleanPreference(EXPORT_SERVICES_WITH_PROPERTIES);
        return state;
    }

    public boolean getGenerateRequiredImportedServiceGetterMethods() {
        boolean state = this.getBooleanPreference(GENERATE_REQUIRED_IMPORTED_SERVICES_GETTER_METHODS);
        return state;
    }

    public boolean getLimitServicesToInterfaceTypes() {
        boolean state = this.getBooleanPreference(LIMIT_SERVICES_TO_INTERFACE_TYPES);
        return state;
    }

    public boolean getLimitServicesToTypesVisibleToTheProject() {
        boolean state = this.getBooleanPreference(LIMIT_SERVICES_TO_TYPES_VISIBLE_TO_THE_PROJECT);
        return state;
    }

    private Preferences getModel() {
        return this.model;
    }

    public boolean getOptionallyImportServices() {
        boolean state = this.getBooleanPreference(OPTIONALLY_IMPORT_SERVICES);
        return state;
    }

    public boolean getOverwriteManifest() {
        boolean state = this.getBooleanPreference(OVERWRITE_BUNDLE_ACTIVATOR_MANIFEST_HEADER);
        return state;
    }

    public String getPackageNameSuffix() {
        String host = this.getStringPreference(PACKAGE_NAME_SUFFIX);
        return host;
    }

    public boolean getStoreExportedServicesInFields() {
        boolean state = this.getBooleanPreference(STORE_EXPORTED_SERVICES_IN_FIELDS);
        return state;
    }

    private String getStringPreference(String key) {
        Preferences model = this.getModel();
        String value = model.getString(key);
        return value;
    }

    private void initializeDefaults() {
        Preferences model = this.getModel();
        model.setDefault(CLASS_NAME, DEFAULT_ACTIVATOR_CLASS_NAME);
        model.setDefault(CREATE_EXPORTED_PROXY_SERVICES, false);
        model.setDefault(DO_NOT_SHOW_PREVIEW_PAGE, false);
        model.setDefault(STORE_EXPORTED_SERVICES_IN_FIELDS, false);
        model.setDefault(EXPORT_SERVICES_WITH_PROPERTIES, false);
        model.setDefault(GENERATE_REQUIRED_IMPORTED_SERVICES_GETTER_METHODS, true);
        model.setDefault(LIMIT_SERVICES_TO_INTERFACE_TYPES, true);
        model.setDefault(LIMIT_SERVICES_TO_TYPES_VISIBLE_TO_THE_PROJECT, true);
        model.setDefault(OPTIONALLY_IMPORT_SERVICES, false);
        model.setDefault(OVERWRITE_BUNDLE_ACTIVATOR_MANIFEST_HEADER, false);
        model.setDefault(OVERWRITE_LAZY_BUNDLE_ACTIVATOR_MANIFEST_HEADER, false);
        model.setDefault(PACKAGE_NAME_SUFFIX, DEFAULT_PACKAGE_SUFFIX);
    }

    public boolean isValidClassName(String className) {
        String value = className.trim();
        int length = value.length();
        if (length == 0) {
            return false;
        }
        boolean valid = OS.isNameValid((String)value);
        if (!valid) {
            return false;
        }
        char ch = value.charAt(0);
        valid = Character.isJavaIdentifierStart(ch);
        return valid;
    }

    public boolean isValidPackageNameSuffix(String packageNameSuffix) {
        String value = packageNameSuffix.trim();
        int length = value.length();
        if (length == 0) {
            return true;
        }
        boolean valid = true;
        char firstCharacter = value.charAt(0);
        valid = valid && Character.isJavaIdentifierPart(firstCharacter);
        valid = valid && firstCharacter != '.';
        char lastCharacter = value.charAt(length - 1);
        boolean bl = valid = valid && lastCharacter != '.';
        if (valid) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateName(value, 2);
            valid = status.isOK();
        }
        return valid;
    }

    public void save() {
        Activator plugin = Activator.getDefault();
        plugin.savePluginPreferences();
    }

    private void setBooleanPreference(String key, boolean value) {
        Preferences model = this.getModel();
        model.setValue(key, value);
    }

    public void setClassName(String activatorClassName) {
        String value = activatorClassName.trim();
        boolean valid = this.isValidClassName(value);
        if (!valid) {
            return;
        }
        this.setStringPreference(CLASS_NAME, value);
    }

    public void setCreateExportedProxyServices(boolean state) {
        this.setBooleanPreference(CREATE_EXPORTED_PROXY_SERVICES, state);
    }

    public void setDoNotShowPreviewPage(boolean state) {
        this.setBooleanPreference(DO_NOT_SHOW_PREVIEW_PAGE, state);
    }

    public void setExportServicesWithProperties(boolean state) {
        this.setBooleanPreference(EXPORT_SERVICES_WITH_PROPERTIES, state);
    }

    public void setGenerateRequiredImportedServiceGetterMethods(boolean state) {
        this.setBooleanPreference(GENERATE_REQUIRED_IMPORTED_SERVICES_GETTER_METHODS, state);
    }

    public void setLimitServicesToInterfaceTypes(boolean state) {
        this.setBooleanPreference(LIMIT_SERVICES_TO_INTERFACE_TYPES, state);
    }

    public void setLimitServicesToTypesVisibleToTheProject(boolean state) {
        this.setBooleanPreference(LIMIT_SERVICES_TO_TYPES_VISIBLE_TO_THE_PROJECT, state);
    }

    private void setModel(Preferences model) {
        this.model = model;
        this.initializeDefaults();
    }

    public void setOptionallyImportServices(boolean state) {
        this.setBooleanPreference(OPTIONALLY_IMPORT_SERVICES, state);
    }

    public void setOverwriteManifest(boolean state) {
        this.setBooleanPreference(OVERWRITE_BUNDLE_ACTIVATOR_MANIFEST_HEADER, state);
    }

    public void setPackageNameSuffix(String packageNameSuffix) {
        String value = packageNameSuffix.trim();
        boolean valid = this.isValidPackageNameSuffix(value);
        if (!valid) {
            return;
        }
        this.setStringPreference(PACKAGE_NAME_SUFFIX, value);
    }

    public void setStoreExportedServicesInFields(boolean state) {
        this.setBooleanPreference(STORE_EXPORTED_SERVICES_IN_FIELDS, state);
    }

    private void setStringPreference(String key, String value) {
        Preferences model = this.getModel();
        model.setValue(key, value);
    }
}

