/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.bundle;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardPreferences;
import org.eclipse.soda.sat.plugin.activator.internal.ActivatorWizardPreferences;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class Activator
extends Plugin {
    private static Activator INSTANCE;
    private BundleContext bundleContext;

    public static Activator getDefault() {
        return INSTANCE;
    }

    public Activator() {
        INSTANCE = this;
    }

    private BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public IActivatorWizardPreferences getPreferences() {
        Preferences prefs = this.getPluginPreferences();
        ActivatorWizardPreferences preferences = new ActivatorWizardPreferences(prefs);
        return preferences;
    }

    public String getSymbolicName() {
        Bundle bundle = this.getBundle();
        String name = bundle.getSymbolicName();
        return name;
    }

    public boolean isValidFilter(String filterString) {
        if (filterString == null) {
            return true;
        }
        int length = filterString.length();
        if (length == 0) {
            return true;
        }
        boolean valid = true;
        BundleContext bundleContext = this.getBundleContext();
        try {
            bundleContext.createFilter(filterString);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            valid = false;
        }
        return valid;
    }

    public void log(int severity, String message, Throwable throwable) {
        String id = this.getSymbolicName();
        Status status = new Status(severity, id, 0, message, throwable);
        ILog log = this.getLog();
        log.log((IStatus)status);
    }

    public void log(int severity, Throwable throwable) {
        String message = throwable.getMessage();
        this.log(severity, message, throwable);
    }

    private void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.setBundleContext(context);
    }

    public void stop(BundleContext context) throws Exception {
        this.setBundleContext(null);
        super.stop(context);
    }
}

