/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.pages;

import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardPreferences;
import org.eclipse.soda.sat.plugin.activator.IExportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.IImportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.ui.internal.api.IActivatorWizard;
import org.eclipse.soda.sat.plugin.activator.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.AbstractActivatorWizardPage;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.ExportedServicesCompositeBuilder;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.ImportedServicesCompositeBuilder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicesActivatorWizardPage
extends AbstractActivatorWizardPage {
    private static final String DESCRIPTION_KEY = "ServicesActivatorWizardPage.Description";
    private static final String TITLE_KEY = "ServicesActivatorWizardPage.Title";
    private static final String HELP_CONTEXT_ID = "org.eclipse.soda.sat.plugin.activator.ui.servicesActivatorWizardPage";
    private static final String PAGE_NAME = ServicesActivatorWizardPage.class.getName();
    private boolean storeExportedServicesInFields;
    private boolean exportServicesWithProperties;
    private boolean createExportedProxyServices;
    private boolean optionallyImportServices;
    private ImportedServicesCompositeBuilder importedServicesCompositeBuilder;
    private ExportedServicesCompositeBuilder exportedServicesCompositeBuilder;
    private boolean limitServicesToInterfaceTypes;
    private boolean limitServicesToTypesVisibleToProject;

    public ServicesActivatorWizardPage(IActivatorWizard parent) {
        super(PAGE_NAME, parent);
        this.initializeFromPreferences();
    }

    private void buildExportedServicesRow(SashForm form) {
        ExportedServicesCompositeBuilder builder = new ExportedServicesCompositeBuilder(this);
        this.setExportedServicesCompositeBuilder(builder);
        builder.build(form);
    }

    private void buildImportedServicesRow(SashForm form) {
        ImportedServicesCompositeBuilder builder = new ImportedServicesCompositeBuilder(this);
        this.setImportedServicesCompositeBuilder(builder);
        builder.build(form);
    }

    private void buildLimitServicesToInterfaceTypesRow(Composite parent) {
        Composite composite = this.createComposite(parent, 1, false, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                boolean selection = button.getSelection();
                ServicesActivatorWizardPage.this.setLimitServicesToInterfaceTypes(selection);
            }
        };
        Button button = this.createButton(composite, 32, "TypeScopePreferencesCompositeBuilder.LimitServicesToInterfaceTypes", (SelectionListener)listener);
        boolean selection = this.getLimitServicesToInterfaceTypes();
        button.setSelection(selection);
    }

    private void buildLimitServicesToTypesVisibleToProjectRow(Composite parent) {
        Composite composite = this.createComposite(parent, 1, false, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                boolean selection = button.getSelection();
                ServicesActivatorWizardPage.this.setLimitServicesToTypesVisibleToProject(selection);
            }
        };
        Button button = this.createButton(composite, 32, "TypeScopePreferencesCompositeBuilder.LimitServicesToTypesVisibleToTheProject", (SelectionListener)listener);
        boolean selection = this.getLimitServicesToTypesVisibleToProject();
        button.setSelection(selection);
    }

    @Override
    protected void buildPage(Composite parent) {
        SashForm form = this.createSashForm(parent);
        this.buildImportedServicesRow(form);
        this.buildExportedServicesRow(form);
        this.buildSeparator(parent);
        this.buildLimitServicesToInterfaceTypesRow(parent);
        this.buildLimitServicesToTypesVisibleToProjectRow(parent);
    }

    private SashForm createSashForm(Composite parent) {
        SashForm form = new SashForm(parent, 512);
        GridData data = new GridData(4, 4, true, true);
        form.setLayoutData((Object)data);
        return form;
    }

    @Override
    public void finish() {
        this.updatePreferences();
        super.finish();
    }

    boolean getCreateExportedProxyServices() {
        return this.createExportedProxyServices;
    }

    private ExportedServicesCompositeBuilder getExportedServicesCompositeBuilder() {
        return this.exportedServicesCompositeBuilder;
    }

    boolean getExportServicesWithProperties() {
        return this.exportServicesWithProperties;
    }

    @Override
    protected String getHelpContextId() {
        return HELP_CONTEXT_ID;
    }

    private ImportedServicesCompositeBuilder getImportedServicesCompositeBuilder() {
        return this.importedServicesCompositeBuilder;
    }

    protected boolean getLimitServicesToInterfaceTypes() {
        return this.limitServicesToInterfaceTypes;
    }

    protected boolean getLimitServicesToTypesVisibleToProject() {
        return this.limitServicesToTypesVisibleToProject;
    }

    @Override
    protected String getMessageString() {
        return Messages.getString(DESCRIPTION_KEY);
    }

    boolean getOptionallyImportServices() {
        return this.optionallyImportServices;
    }

    boolean getStoreExportedServicesInFields() {
        return this.storeExportedServicesInFields;
    }

    @Override
    protected String getTitleString() {
        return Messages.getString(TITLE_KEY);
    }

    @Override
    protected void handleExportedServiceDetailsChanged(List<IExportedServiceDetails> details) {
        ExportedServicesCompositeBuilder builder = this.getExportedServicesCompositeBuilder();
        builder.handleServiceDetailsChanged(details);
    }

    @Override
    protected void handleImportedServiceDetailsChanged(List<IImportedServiceDetails> details) {
        ImportedServicesCompositeBuilder builder = this.getImportedServicesCompositeBuilder();
        builder.handleServiceDetailsChanged(details);
    }

    private void initializeFromPreferences() {
        IActivatorWizardPreferences preferences = this.getPreferences();
        boolean state = preferences.getStoreExportedServicesInFields();
        this.setStoreExportedServicesInFields(state);
        state = preferences.getExportServicesWithProperties();
        this.setExportServicesWithProperties(state);
        state = preferences.getCreateExportedProxyServices();
        this.setCreateExportedProxyServices(state);
        state = preferences.getOptionallyImportServices();
        this.setOptionallyImportServices(state);
        state = preferences.getLimitServicesToInterfaceTypes();
        this.setLimitServicesToInterfaceTypes(state);
        state = preferences.getLimitServicesToTypesVisibleToTheProject();
        this.setLimitServicesToTypesVisibleToProject(state);
    }

    @Override
    protected IType[] openSelectTypeDialog(String titleKey, String messageKey) {
        String filter = new String();
        boolean multipleSelection = true;
        boolean state = this.getLimitServicesToInterfaceTypes();
        int style = state ? 4 : 512;
        boolean projectScope = this.getLimitServicesToTypesVisibleToProject();
        IType[] types = this.openSelectTypeDialog(titleKey, messageKey, filter, multipleSelection, style, projectScope);
        return types;
    }

    private void setCreateExportedProxyServices(boolean exportedProxyService) {
        this.createExportedProxyServices = exportedProxyService;
    }

    private void setExportedServicesCompositeBuilder(ExportedServicesCompositeBuilder exportedServicesCompositeBuilder) {
        this.exportedServicesCompositeBuilder = exportedServicesCompositeBuilder;
    }

    private void setExportServicesWithProperties(boolean exportedServiceHasProperties) {
        this.exportServicesWithProperties = exportedServiceHasProperties;
    }

    private void setImportedServicesCompositeBuilder(ImportedServicesCompositeBuilder importedServicesCompositeBuilder) {
        this.importedServicesCompositeBuilder = importedServicesCompositeBuilder;
    }

    protected void setLimitServicesToInterfaceTypes(boolean limitServicesToInterfaceTypes) {
        this.limitServicesToInterfaceTypes = limitServicesToInterfaceTypes;
    }

    protected void setLimitServicesToTypesVisibleToProject(boolean limitServicesToTypesVisibleToProject) {
        this.limitServicesToTypesVisibleToProject = limitServicesToTypesVisibleToProject;
    }

    private void setOptionallyImportServices(boolean importedServiceIsOptional) {
        this.optionallyImportServices = importedServiceIsOptional;
    }

    private void setStoreExportedServicesInFields(boolean exportedServiceIsStoredInField) {
        this.storeExportedServicesInFields = exportedServiceIsStoredInField;
    }

    private void updatePreferences() {
        IActivatorWizardPreferences preferences = this.getPreferences();
        boolean state = this.getLimitServicesToInterfaceTypes();
        preferences.setLimitServicesToInterfaceTypes(state);
        state = this.getLimitServicesToTypesVisibleToProject();
        preferences.setLimitServicesToTypesVisibleToTheProject(state);
    }
}

