/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.pages;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardModel;
import org.eclipse.soda.sat.plugin.activator.IImportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.IServiceDetails;
import org.eclipse.soda.sat.plugin.activator.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.ImportedServicesTableLabelProvider;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.ServicesActivatorWizardPage;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.ServicesCompositeBuilder;
import org.eclipse.soda.sat.plugin.activator.util.FactoryUtility;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

class ImportedServicesCompositeBuilder
extends ServicesCompositeBuilder {
    private static final String ADD_BUTTON_TOOL_TIP_KEY = "ImportedServicesCompositeBuilder.AddButtonToolTip";
    private static final String EDIT_BUTTON_TOOL_TIP_KEY = "ImportedServicesCompositeBuilder.EditButtonToolTip";
    private static final String FILTER_KEY = "ImportedServicesCompositeBuilder.Filter";
    private static final String TITLE_KEY = "ImportedServicesCompositeBuilder.Title";
    private static final String OPTIONAL_KEY = "ImportedServicesCompositeBuilder.Optional";
    private static final String OPTIONAL_SHORTCUT_KEY = "ImportedServicesCompositeBuilder.OptionalShortcut";
    private static final String REMOVE_BUTTON_TOOL_TIP_KEY = "ImportedServicesCompositeBuilder.RemoveButtonToolTip";
    private static final String FILTER_COLUMN_ID = "filter";
    private static final String OPTIONAL_COLUMN_ID = "optional";
    private static final int FILTER_COLUMN_INDEX = 1;
    private static final int FILTER_COLUMN_WIDTH = 340;
    private static final char OPTIONAL_SHORTCUT = Messages.getString("ImportedServicesCompositeBuilder.OptionalShortcut").charAt(0);
    private static final String DEFAULT_IMPORTED_SERVICE_FILTER = new String();

    ImportedServicesCompositeBuilder(ServicesActivatorWizardPage page) {
        super(page);
    }

    void addService(IType type) {
        FactoryUtility utility = FactoryUtility.getInstance();
        boolean optional = this.getOptionallyImportServices();
        IJavaProject javaProject = this.getJavaProject();
        IImportedServiceDetails details = utility.createImportedServiceDetails(type, javaProject, optional);
        IActivatorWizardModel model = this.getModel();
        model.addImportedServiceDetails(details);
        super.addService(type);
    }

    CellEditor[] createCellEditors(Table table) {
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = this.createTextCellEditor(table);
        cellEditorArray[2] = this.createCheckboxCellEditor(table);
        return cellEditorArray;
    }

    String[] createColumnProperties() {
        return new String[]{"serviceName", FILTER_COLUMN_ID, OPTIONAL_COLUMN_ID};
    }

    void createTableColumns(Table table) {
        super.createTableColumns(table);
        this.createTableColumn(table, FILTER_KEY, 340);
        this.createTableColumn(table, OPTIONAL_KEY, 70);
    }

    ITableLabelProvider createTableLabelProvider() {
        return new ImportedServicesTableLabelProvider();
    }

    Object createTableViewerInput() {
        IActivatorWizardModel model = this.getModel();
        List list = model.getImportedServicesDetails();
        return list;
    }

    boolean editService(IServiceDetails details, IType selectedType) {
        String fullyQualifiedName;
        IActivatorWizardModel model = this.getModel();
        boolean exists = model.containsImportedService(fullyQualifiedName = selectedType.getFullyQualifiedName());
        if (exists) {
            return false;
        }
        IImportedServiceDetails importedServiceDetails = (IImportedServiceDetails)details;
        model.removeImportedServiceDetails(importedServiceDetails);
        importedServiceDetails.setType(selectedType);
        model.addImportedServiceDetails(importedServiceDetails);
        return true;
    }

    String getAddButtonToolTipKey() {
        return ADD_BUTTON_TOOL_TIP_KEY;
    }

    String getEditButtonToolTipKey() {
        return EDIT_BUTTON_TOOL_TIP_KEY;
    }

    private TextCellEditor getFilterComboBoxCellEditor() {
        TextCellEditor editor = (TextCellEditor)this.getCellEditor(1);
        return editor;
    }

    String getImageKey() {
        return "bundle-importer";
    }

    private boolean getOptionallyImportServices() {
        ServicesActivatorWizardPage page = this.getPage();
        boolean state = page.getOptionallyImportServices();
        return state;
    }

    String getRemoveButtonToolTipKey() {
        return REMOVE_BUTTON_TOOL_TIP_KEY;
    }

    String getTitleKey() {
        return TITLE_KEY;
    }

    boolean handleCanModifyCellEditor(String property) {
        if (property.equals(FILTER_COLUMN_ID)) {
            return true;
        }
        return property.equals(OPTIONAL_COLUMN_ID);
    }

    Object handleGetValueOfCellEditor(IServiceDetails details, String property) {
        Object value = null;
        IImportedServiceDetails importedServiceDetails = (IImportedServiceDetails)details;
        if (property.equals(FILTER_COLUMN_ID)) {
            value = this.handleGetValueOfFilterCellEditor(importedServiceDetails);
        } else if (property.equals(OPTIONAL_COLUMN_ID)) {
            value = this.handleGetValueOfOptionalCellEditor(importedServiceDetails);
        }
        return value;
    }

    private Object handleGetValueOfFilterCellEditor(IImportedServiceDetails details) {
        String value = details.getFilter();
        if (value == null) {
            value = DEFAULT_IMPORTED_SERVICE_FILTER;
        }
        return value;
    }

    private Object handleGetValueOfOptionalCellEditor(IImportedServiceDetails details) {
        boolean state = details.isOptional();
        Boolean value = state;
        return value;
    }

    void handleModifyCellEditor(IServiceDetails details, String property, Object value) {
        IImportedServiceDetails importedServiceDetails = (IImportedServiceDetails)details;
        if (property.equals(FILTER_COLUMN_ID)) {
            String filter = (String)value;
            this.handleModifyFilterCellEditor(importedServiceDetails, filter);
        } else if (property.equals(OPTIONAL_COLUMN_ID)) {
            this.handleModifyOptionalCellEditor(importedServiceDetails);
        }
    }

    private void handleModifyFilterCellEditor(IImportedServiceDetails details, String value) {
        String filter = value;
        if (filter != null) {
            int length = filter.length();
            if (length == 0) {
                filter = null;
            } else {
                char first = filter.charAt(0);
                char last = filter.charAt(length - 1);
                if (first != '(' && last != ')') {
                    filter = String.valueOf('(') + filter + ')';
                }
            }
        }
        details.setFilter(filter);
        TextCellEditor editor = this.getFilterComboBoxCellEditor();
        editor.setValue((Object)DEFAULT_IMPORTED_SERVICE_FILTER);
        this.validateFilters();
    }

    private void handleModifyOptionalCellEditor(IImportedServiceDetails details) {
        boolean optional = details.isOptional();
        details.setOptional(!optional);
    }

    private void handleOptionalShortCutKeyPressed() {
        List<?> list = this.getTableViewerSelectionList();
        for (Object object : list) {
            IImportedServiceDetails details = (IImportedServiceDetails)object;
            this.handleModifyOptionalCellEditor(details);
            this.refreshTableViewer(details);
        }
    }

    void handleTableKeyPressed(KeyEvent event, boolean altKeyDown) {
        super.handleTableKeyPressed(event, altKeyDown);
        if (this.isOptionalShortcutKeyPressed(event, altKeyDown)) {
            this.handleOptionalShortCutKeyPressed();
        }
    }

    void handleTableResized() {
        TableViewer viewer = this.getTableViewer();
        Table table = viewer.getTable();
        int value = this.calculateRemainingHorizontalSpace(table, 2);
        if (value == 0) {
            return;
        }
        TableColumn[] columns = table.getColumns();
        TableColumn column = columns[0];
        int width = value - column.getWidth();
        column = columns[1];
        column.setWidth(width);
    }

    private boolean isOptionalShortcutKeyPressed(KeyEvent event, boolean altKeyDown) {
        return altKeyDown && event.character == OPTIONAL_SHORTCUT;
    }

    void removeService(IServiceDetails details) {
        IActivatorWizardModel model = this.getModel();
        IImportedServiceDetails importedServiceDetails = (IImportedServiceDetails)details;
        model.removeImportedServiceDetails(importedServiceDetails);
        super.removeService((IServiceDetails)importedServiceDetails);
    }

    private void validateFilters() {
        IActivatorWizardModel model = this.getModel();
        IStatus status = model.validateImportedServiceFilters();
        boolean valid = status.isOK();
        String message = valid ? null : status.getMessage();
        ServicesActivatorWizardPage page = this.getPage();
        page.setErrorMessage(message);
        page.setPageComplete(valid);
    }
}

