/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.util;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class TypeFinder {
    private static final String JAVA_FILE_EXTENSION = ".java";

    private static IType findInnerType(IJavaProject jproject, String fullyQualifiedTypeName) throws JavaModelException {
        String qualifier = Signature.getQualifier((String)fullyQualifiedTypeName);
        int qualifierLength = qualifier.length();
        if (qualifierLength == 0) {
            return null;
        }
        IType type = TypeFinder.findType(jproject, qualifier);
        if (type == null) {
            return null;
        }
        String simpleName = Signature.getSimpleName((String)fullyQualifiedTypeName);
        IType result = type.getType(simpleName);
        boolean exists = result.exists();
        if (!exists) {
            return null;
        }
        return result;
    }

    public static IJavaProject findJavaProject(String name) {
        IJavaModel javaModel = TypeFinder.getJavaModel();
        IJavaProject project = javaModel.getJavaProject(name);
        return project;
    }

    private static IType findType(ICompilationUnit compilationUnit, String fullyQualifiedTypeName) {
        String simpleName = Signature.getSimpleName((String)fullyQualifiedTypeName);
        IType result = compilationUnit.getType(simpleName);
        return result;
    }

    private static IType findType(IJavaElement javaElement, String fullyQualifiedTypeName) throws JavaModelException {
        IType result = null;
        int elementType = javaElement.getElementType();
        if (elementType == 5) {
            ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
            result = TypeFinder.findType(compilationUnit, fullyQualifiedTypeName);
        } else if (elementType == 6) {
            IClassFile classFile = (IClassFile)javaElement;
            return classFile.getType();
        }
        return result;
    }

    public static IType findType(IJavaProject jproject, String fullyQualifiedTypeName) throws JavaModelException {
        IType result = null;
        String value = fullyQualifiedTypeName.replace('.', '/');
        Path path = new Path(String.valueOf(value) + JAVA_FILE_EXTENSION);
        IJavaElement javaElement = jproject.findElement((IPath)path);
        result = javaElement != null ? TypeFinder.findType(javaElement, fullyQualifiedTypeName) : TypeFinder.findInnerType(jproject, fullyQualifiedTypeName);
        return result;
    }

    public static IType findType(String fullyQualifiedTypeName) throws JavaModelException {
        IJavaProject[] projects = TypeFinder.getJavaProjects();
        int length = projects.length;
        int index = 0;
        boolean found = false;
        IType type = null;
        IJavaProject project = null;
        while (!found && index < length) {
            project = projects[index];
            type = TypeFinder.findType(project, fullyQualifiedTypeName);
            found = type != null;
            ++index;
        }
        type = found ? type : null;
        return type;
    }

    private static IJavaModel getJavaModel() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)root);
        return javaModel;
    }

    private static IJavaProject[] getJavaProjects() throws JavaModelException {
        IJavaModel javaModel = TypeFinder.getJavaModel();
        IJavaProject[] projects = javaModel.getJavaProjects();
        return projects;
    }

    private TypeFinder() {
    }
}

