/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.framework.interfaces.ILineReader;
import org.eclipse.soda.sat.core.junit.internal.AbstractSatTestCase;

public class LineReaderTestCase
extends AbstractSatTestCase {
    private static final String NO_LINES_AVAILABLE = "No lines available";
    private static final String INVALID_LINE_READ = "Invalid line read";
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.util.test.LineReaderTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public LineReaderTestCase(String name) {
        super(name);
    }

    private byte[] createDataBytes() {
        char newline = '\r';
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("one");
        buffer.append(newline);
        buffer.append("two");
        buffer.append('\n');
        buffer.append("three");
        buffer.append('\r');
        buffer.append("four");
        buffer.append(newline);
        buffer.append(newline);
        buffer.append("five");
        buffer.append(newline);
        String text = buffer.toString();
        byte[] bytes = text.getBytes();
        return bytes;
    }

    private InputStream createInputStream() {
        byte[] bytes = this.createDataBytes();
        InputStream stream = this.createInputStream(bytes);
        return stream;
    }

    private InputStream createInputStream(byte[] bytes) {
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        return stream;
    }

    private ILineReader createLineReader() {
        InputStream stream = this.createInputStream();
        ILineReader reader = this.createLineReader(stream);
        return reader;
    }

    private ILineReader createLineReader(ILineReader.IAdvisor advisor) {
        InputStream stream = this.createInputStream();
        ILineReader reader = AbstractSatTestCase.FACTORY.createLineReader(stream, advisor);
        return reader;
    }

    private ILineReader createLineReader(InputStream stream) {
        ILineReader reader = AbstractSatTestCase.FACTORY.createLineReader(stream);
        return reader;
    }

    private ILineReader createLineReader(InputStream stream, String characterEncoding) {
        ILineReader reader = AbstractSatTestCase.FACTORY.createLineReader(stream, characterEncoding);
        return reader;
    }

    public void test_AdvisorTransformation() throws IOException {
        ILineReader.IAdvisor advisor = new ILineReader.IAdvisor(){

            public boolean isValid(String line) {
                return true;
            }

            public String transform(String line) {
                if (line.equals("one")) {
                    return "1";
                }
                if (line.equals("two")) {
                    return "2";
                }
                if (line.equals("three")) {
                    return "3";
                }
                if (line.equals("four")) {
                    return "4";
                }
                if (line.equals("five")) {
                    return "5";
                }
                return line;
            }
        };
        ILineReader reader = this.createLineReader(advisor);
        String line = reader.readLine();
        Assert.assertEquals((String)INVALID_LINE_READ, (Object)"1", (Object)line);
        line = reader.readLine();
        Assert.assertEquals((String)INVALID_LINE_READ, (Object)"2", (Object)line);
        line = reader.readLine();
        Assert.assertEquals((String)INVALID_LINE_READ, (Object)"3", (Object)line);
        line = reader.readLine();
        Assert.assertEquals((String)INVALID_LINE_READ, (Object)"4", (Object)line);
        line = reader.readLine();
        Assert.assertEquals((String)INVALID_LINE_READ, (Object)new String(), (Object)line);
        line = reader.readLine();
        Assert.assertEquals((String)INVALID_LINE_READ, (Object)"5", (Object)line);
    }

    public void test_AdvisorValidation() throws IOException {
        ILineReader.IAdvisor advisor = new ILineReader.IAdvisor(){

            public boolean isValid(String line) {
                return line.charAt(0) != '#';
            }

            public String transform(String line) {
                return line;
            }
        };
        char newline = '\r';
        StringBuffer buffer = new StringBuffer(25);
        buffer.append("#one");
        buffer.append(newline);
        buffer.append("two");
        buffer.append(newline);
        buffer.append("three");
        buffer.append(newline);
        buffer.append("#four");
        buffer.append(newline);
        buffer.append("five");
        String text = buffer.toString();
        byte[] bytes = text.getBytes();
        InputStream stream = this.createInputStream(bytes);
        ILineReader reader = AbstractSatTestCase.FACTORY.createLineReader(stream, advisor);
        String line = reader.readLine();
        Assert.assertEquals((String)INVALID_LINE_READ, (Object)"two", (Object)line);
        line = reader.readLine();
        Assert.assertEquals((String)INVALID_LINE_READ, (Object)"three", (Object)line);
        line = reader.readLine();
        Assert.assertEquals((String)INVALID_LINE_READ, (Object)"five", (Object)line);
    }

    public void test_lines() {
        ILineReader reader = this.createLineReader();
        Enumeration enumeration = reader.lines();
        Assert.assertTrue((String)NO_LINES_AVAILABLE, (boolean)enumeration.hasMoreElements());
        Object line = enumeration.nextElement();
        Assert.assertEquals((String)INVALID_LINE_READ, (Object)"one", line);
        Assert.assertTrue((String)NO_LINES_AVAILABLE, (boolean)enumeration.hasMoreElements());
        line = enumeration.nextElement();
        Assert.assertEquals((String)INVALID_LINE_READ, (Object)"two", line);
        Assert.assertTrue((String)NO_LINES_AVAILABLE, (boolean)enumeration.hasMoreElements());
        line = enumeration.nextElement();
        Assert.assertEquals((String)INVALID_LINE_READ, (Object)"three", line);
        Assert.assertTrue((String)NO_LINES_AVAILABLE, (boolean)enumeration.hasMoreElements());
        line = enumeration.nextElement();
        Assert.assertEquals((String)INVALID_LINE_READ, (Object)"four", line);
        Assert.assertTrue((String)NO_LINES_AVAILABLE, (boolean)enumeration.hasMoreElements());
        line = enumeration.nextElement();
        Assert.assertEquals((String)INVALID_LINE_READ, (Object)new String(), line);
        Assert.assertTrue((String)NO_LINES_AVAILABLE, (boolean)enumeration.hasMoreElements());
        line = enumeration.nextElement();
        Assert.assertEquals((String)INVALID_LINE_READ, (Object)"five", line);
        Assert.assertTrue((String)"Lines available", (!enumeration.hasMoreElements() ? 1 : 0) != 0);
        line = enumeration.nextElement();
        Assert.assertNull((String)INVALID_LINE_READ, line);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_readLine() throws IOException {
        ILineReader reader = this.createLineReader();
        try {
            String line = reader.readLine();
            Assert.assertEquals((String)INVALID_LINE_READ, (Object)"one", (Object)line);
            line = reader.readLine();
            Assert.assertEquals((String)INVALID_LINE_READ, (Object)"two", (Object)line);
            line = reader.readLine();
            Assert.assertEquals((String)INVALID_LINE_READ, (Object)"three", (Object)line);
            line = reader.readLine();
            Assert.assertEquals((String)INVALID_LINE_READ, (Object)"four", (Object)line);
            line = reader.readLine();
            Assert.assertEquals((String)INVALID_LINE_READ, (Object)new String(), (Object)line);
            line = reader.readLine();
            Assert.assertEquals((String)INVALID_LINE_READ, (Object)"five", (Object)line);
            line = reader.readLine();
            Assert.assertNull((String)INVALID_LINE_READ, (Object)line);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            reader.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        reader.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_readLine_japanese() throws IOException {
        String yamadaTaro = "\u00e5\u00b1\u00b1\u00e7\u201d\u00b0\u00e5\u00a4\u00aa\u00e9\u0192\u017d";
        byte[] bytes = yamadaTaro.getBytes();
        InputStream stream = this.createInputStream(bytes);
        ILineReader reader = this.createLineReader(stream, "UTF-8");
        try {
            String line = reader.readLine();
            Assert.assertEquals((String)INVALID_LINE_READ, (Object)yamadaTaro, (Object)line);
            line = reader.readLine();
            Assert.assertNull((String)INVALID_LINE_READ, (Object)line);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            reader.close();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        reader.close();
    }
}

