/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.junit.internal.cm;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.sat.core.junit.internal.cm.IManagedServiceFactoryActivationDelegate;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ConfigurationAdminConfigurator {
    private ConfigurationAdmin configurationAdmin;

    public ConfigurationAdminConfigurator(ConfigurationAdmin configurationAdmin) {
        this.setConfigurationAdmin(configurationAdmin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration create(IManagedServiceFactoryActivationDelegate factory, Object id, Dictionary properties) throws IOException, InterruptedException {
        Configuration configuration = this.createConfiguration(factory);
        IManagedServiceFactoryActivationDelegate iManagedServiceFactoryActivationDelegate = factory;
        synchronized (iManagedServiceFactoryActivationDelegate) {
            this.updateConfiguration(factory, properties, configuration);
            this.waitForConfigurationUpdate(factory, id);
        }
        return configuration;
    }

    private Configuration createConfiguration(IManagedServiceFactoryActivationDelegate factory) throws IOException {
        ConfigurationAdmin admin = this.getConfigurationAdmin();
        String pid = factory.getPid();
        String location = factory.getLocation();
        Configuration configuration = admin.createFactoryConfiguration(pid, location);
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(IManagedServiceFactoryActivationDelegate factory, Object id, Configuration configuration) throws IOException, InterruptedException {
        if (configuration == null) {
            return;
        }
        IManagedServiceFactoryActivationDelegate iManagedServiceFactoryActivationDelegate = factory;
        synchronized (iManagedServiceFactoryActivationDelegate) {
            configuration.delete();
            this.waitForConfigurationDeletion(factory, id);
        }
    }

    private ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public Configuration[] getConfigurations(String filter) throws IOException, InvalidSyntaxException {
        ConfigurationAdmin admin = this.getConfigurationAdmin();
        Configuration[] configurations = admin.listConfigurations(filter);
        return configurations;
    }

    private void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(IManagedServiceFactoryActivationDelegate factory, Dictionary properties, Configuration configuration) throws IOException, InterruptedException {
        IManagedServiceFactoryActivationDelegate iManagedServiceFactoryActivationDelegate = factory;
        synchronized (iManagedServiceFactoryActivationDelegate) {
            this.updateConfiguration(factory, properties, configuration);
            this.waitForConfigurationUpdate(factory);
        }
    }

    private void updateConfiguration(IManagedServiceFactoryActivationDelegate factory, Dictionary properties, Configuration configuration) throws IOException {
        Dictionary configurationProperties = properties == null ? new Hashtable(17) : properties;
        String pid = factory.getPid();
        configurationProperties.put("service.factoryPid", pid);
        configuration.update(configurationProperties);
    }

    private void waitForConfigurationDeletion(IManagedServiceFactoryActivationDelegate factory, Object id) throws InterruptedException {
        while (factory.getObjectWithId(id) != null) {
            factory.wait();
        }
    }

    private void waitForConfigurationUpdate(IManagedServiceFactoryActivationDelegate factory) throws InterruptedException {
        factory.wait();
    }

    private void waitForConfigurationUpdate(IManagedServiceFactoryActivationDelegate factory, Object id) throws InterruptedException {
        while (factory.getObjectWithId(id) == null) {
            factory.wait();
        }
    }
}

