/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.junit.internal.AbstractSatTestCase;
import org.eclipse.soda.sat.core.util.CollectionUtility;
import org.eclipse.soda.sat.junit.util.ValueHolder;

public class CollectionUtilityTestCase
extends AbstractSatTestCase {
    private static final CollectionUtility UTILITY = CollectionUtility.getInstance();
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.util.test.CollectionUtilityTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public CollectionUtilityTestCase(String name) {
        super(name);
    }

    private CollectionUtility.InjectionAccessor createAccumulateStringLengthInjectionAccessor() {
        return new CollectionUtility.InjectionAccessor(){

            public Object get(Object value, Object item) {
                ValueHolder holder = (ValueHolder)value;
                Integer wrapper = (Integer)holder.getValue();
                int total = wrapper;
                String color = (String)item;
                int length = color.length();
                wrapper = new Integer(total += length);
                holder.setValue((Object)wrapper);
                return holder;
            }
        };
    }

    private CollectionUtility.Accessor createNullAccessor() {
        return new CollectionUtility.Accessor(){

            public Object get(Object item) {
                return null;
            }
        };
    }

    private CollectionUtility.InjectionAccessor createNullInjectionAccessor() {
        return new CollectionUtility.InjectionAccessor(){

            public Object get(Object value, Object item) {
                return null;
            }
        };
    }

    private CollectionUtility.Accessor createRejectAllAccessor() {
        return new CollectionUtility.Accessor(){

            public Object get(Object item) {
                return item;
            }
        };
    }

    private CollectionUtility.Accessor createStringLengthAccessor() {
        return new CollectionUtility.Accessor(){

            public Object get(Object item) {
                String value = (String)item;
                int length = value.length();
                Integer wrapper = new Integer(length);
                return wrapper;
            }
        };
    }

    private CollectionUtility.Accessor createStringOfLengthAtLeastAccessor(final int length) {
        return new CollectionUtility.Accessor(){

            public Object get(Object item) {
                String color = (String)item;
                int colorLength = color.length();
                String value = colorLength >= length ? color : null;
                return value;
            }
        };
    }

    private List getColors() {
        ArrayList<String> colors = new ArrayList<String>(5);
        colors.add("red");
        colors.add("yellow");
        colors.add("blue");
        colors.add("green");
        colors.add("orange");
        return colors;
    }

    public void test_collect() {
        List colors = this.getColors();
        CollectionUtility.Accessor accessor = this.createStringLengthAccessor();
        List lengths = UTILITY.collect((Collection)colors, accessor);
        int expectedSize = colors.size();
        int actualSize = lengths.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        int i = 0;
        while (i < actualSize) {
            String color = (String)colors.get(i);
            int expectedLength = color.length();
            Integer wrapper = (Integer)lengths.get(i);
            int actualLength = wrapper;
            Assert.assertEquals((int)expectedLength, (int)actualLength);
            ++i;
        }
        accessor = this.createNullAccessor();
        List list = UTILITY.collect((Collection)colors, accessor);
        expectedSize = colors.size();
        actualSize = list.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Assert.assertNull(object);
        }
        try {
            UTILITY.collect(null, accessor);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
        try {
            UTILITY.collect((Collection)colors, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
    }

    public void test_detect() {
        List colors = this.getColors();
        CollectionUtility.Accessor accessor = this.createStringOfLengthAtLeastAccessor(5);
        String expected = "yellow";
        Object actual = UTILITY.detect((Collection)colors, accessor);
        Assert.assertEquals((Object)expected, (Object)actual);
        accessor = this.createStringOfLengthAtLeastAccessor(25);
        actual = UTILITY.detect((Collection)colors, accessor);
        Assert.assertNull((Object)actual);
        accessor = this.createNullAccessor();
        actual = UTILITY.detect((Collection)colors, accessor);
        Assert.assertNull((Object)actual);
        try {
            UTILITY.detect(null, accessor);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
        try {
            UTILITY.detect((Collection)colors, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
    }

    public void test_estimateHashedCollectionSize() {
        int capacity = 25;
        int expectedCapacity = capacity * 4 / 3 + 1;
        int actualCapacity = UTILITY.estimateHashedCollectionSize(capacity);
        Assert.assertEquals((int)expectedCapacity, (int)actualCapacity);
        expectedCapacity = 0;
        actualCapacity = UTILITY.estimateHashedCollectionSize(-1);
        Assert.assertEquals((int)expectedCapacity, (int)actualCapacity);
    }

    public void test_getInstance() {
        Assert.assertNotNull((Object)UTILITY);
    }

    public void test_inject() {
        List colors = this.getColors();
        ValueHolder holder = ValueHolder.zeroValue();
        Iterator iterator = colors.iterator();
        int expectedTotal = 0;
        while (iterator.hasNext()) {
            String color = (String)iterator.next();
            int length = color.length();
            expectedTotal += length;
        }
        CollectionUtility.InjectionAccessor accessor = this.createAccumulateStringLengthInjectionAccessor();
        UTILITY.inject((Collection)colors, (Object)holder, accessor);
        Integer wrapper = (Integer)holder.getValue();
        int actualTotal = wrapper;
        Assert.assertEquals((int)expectedTotal, (int)actualTotal);
        holder.setZero();
        accessor = this.createNullInjectionAccessor();
        UTILITY.inject((Collection)colors, (Object)holder, accessor);
        Assert.assertTrue((boolean)holder.isZero());
        try {
            UTILITY.inject(null, (Object)holder, accessor);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
        try {
            UTILITY.inject((Collection)colors, null, accessor);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
        try {
            UTILITY.inject((Collection)colors, (Object)holder, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
    }

    public void test_reject() {
        List colors = this.getColors();
        CollectionUtility.Accessor accessor = this.createStringOfLengthAtLeastAccessor(5);
        List result = UTILITY.reject((Collection)colors, accessor);
        int expectedSize = 2;
        int actualSize = result.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        accessor = this.createRejectAllAccessor();
        result = UTILITY.reject((Collection)colors, accessor);
        Assert.assertNotNull((Object)result);
        expectedSize = 0;
        actualSize = result.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        try {
            UTILITY.reject(null, accessor);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
        try {
            UTILITY.reject((Collection)colors, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
    }

    public void test_select() {
        List colors = this.getColors();
        CollectionUtility.Accessor accessor = this.createStringOfLengthAtLeastAccessor(5);
        List result = UTILITY.select((Collection)colors, accessor);
        int expectedSize = 3;
        int actualSize = result.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        accessor = this.createNullAccessor();
        result = UTILITY.select((Collection)colors, accessor);
        Assert.assertNotNull((Object)result);
        expectedSize = 0;
        actualSize = result.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        try {
            UTILITY.select(null, accessor);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
        try {
            UTILITY.select((Collection)colors, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
    }

    public void test_toEnumeration() {
        List colors = this.getColors();
        Vector vector = new Vector(colors);
        Enumeration elements = vector.elements();
        List actualList = UTILITY.toList(elements);
        Assert.assertEquals((Object)colors, (Object)actualList);
        try {
            UTILITY.toList(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
        elements = vector.elements();
        try {
            UTILITY.toList(elements, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
        elements = vector.elements();
        int size = vector.size();
        ArrayList list = new ArrayList(size);
        actualList = UTILITY.toList(elements, list);
        Assert.assertEquals((Object)colors, (Object)actualList);
        elements = vector.elements();
        list = new ArrayList(10);
        actualList = UTILITY.toList(elements, list);
        Assert.assertEquals((Object)colors, (Object)actualList);
        Assert.assertSame(list, (Object)actualList);
        vector = new Vector();
        elements = vector.elements();
        actualList = UTILITY.toList(elements);
        int expectedSize = 0;
        int actualSize = actualList.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
    }
}

