/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.framework.interfaces.ICharBuffer;
import org.eclipse.soda.sat.core.internal.util.test.CharBufferTestCase;
import org.eclipse.soda.sat.core.junit.internal.AbstractSatTestCase;

public class CharBufferTestCase
extends AbstractSatTestCase {
    private static final String VALUE1 = "ABCDEFGHIJ";
    private static final String VALUE2 = "KLMNOPQRST";
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.util.test.CharBufferTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public CharBufferTestCase(String name) {
        super(name);
    }

    private void assertAppendBoolean(boolean expectedValue) {
        ICharBuffer buffer = this.createBuffer(5);
        buffer.append(expectedValue);
        String value = buffer.getValue();
        Boolean wrapper = Boolean.valueOf(value);
        boolean actualValue = wrapper;
        Assert.assertEquals((boolean)expectedValue, (boolean)actualValue);
    }

    private void assertAppendDouble(double expectedValue) {
        ICharBuffer buffer = this.createBuffer(5);
        buffer.append(expectedValue);
        String value = buffer.getValue();
        double actualValue = Double.parseDouble(value);
        Assert.assertEquals((double)expectedValue, (double)actualValue, (double)0.0);
    }

    private void assertAppendFloat(float expectedValue) {
        ICharBuffer buffer = this.createBuffer(5);
        buffer.append(expectedValue);
        String value = buffer.getValue();
        float actualValue = Float.parseFloat(value);
        Assert.assertEquals((double)expectedValue, (double)actualValue, (double)0.0);
    }

    private void assertAppendInt(int expectedValue) {
        ICharBuffer buffer = this.createBuffer(5);
        buffer.append(expectedValue);
        String value = buffer.getValue();
        int actualValue = Integer.parseInt(value);
        Assert.assertEquals((int)expectedValue, (int)actualValue);
    }

    private void assertAppendLong(long expectedValue) {
        ICharBuffer buffer = this.createBuffer(5);
        buffer.append(expectedValue);
        String value = buffer.getValue();
        long actualValue = Long.parseLong(value);
        Assert.assertEquals((long)expectedValue, (long)actualValue);
    }

    private void assertGrow100Percent(ICharBuffer buffer) {
        int expectedGrowPercentage = 100;
        int actualGrowPercentage = buffer.getGrowPercentage();
        Assert.assertEquals((int)expectedGrowPercentage, (int)actualGrowPercentage);
    }

    private void assertGrowExponentially(ICharBuffer buffer) {
        this.assertGrowStyle(buffer, (short)1);
    }

    private void assertGrowLinearly(ICharBuffer buffer) {
        this.assertGrowStyle(buffer, (short)0);
    }

    private void assertGrowStyle(ICharBuffer buffer, short expectedGrowStyle) {
        short actualGrowStyle = buffer.getGrowStyle();
        Assert.assertEquals((short)expectedGrowStyle, (short)actualGrowStyle);
    }

    private ICharBuffer createBuffer() {
        return this.createBuffer(10);
    }

    private ICharBuffer createBuffer(int capacity) {
        return AbstractSatTestCase.FACTORY.createCharBuffer(capacity);
    }

    private Runnable createCharAppenderRunnable(final int n, final ICharBuffer buffer, final int count) {
        return new Runnable(){

            public void run() {
                int i = 0;
                while (i < count) {
                    char ch = (char)(65 + n);
                    buffer.append(ch);
                    Thread.yield();
                    ++i;
                }
            }
        };
    }

    private Runnable createCharAppenderWithSynchronizationRunnable(final int n, final ICharBuffer buffer, final int count) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Runnable runnable = CharBufferTestCase.this.createCharAppenderRunnable(n, buffer, count);
                ICharBuffer iCharBuffer = buffer;
                synchronized (iCharBuffer) {
                    runnable.run();
                }
            }
        };
    }

    private Runnable createCharAtRunnable(final ICharBuffer buffer, final int count) {
        return new Runnable(){

            public void run() {
                int length = buffer.length();
                int i = 0;
                while (i < count) {
                    int index = (int)(Math.random() * (double)length);
                    buffer.charAt(index);
                    Thread.yield();
                    ++i;
                }
            }
        };
    }

    private Runnable createStringAppenderRunnable(final String value, final ICharBuffer buffer, final int count) {
        return new Runnable(){

            public void run() {
                int i = 0;
                while (i < count) {
                    buffer.append(value);
                    Thread.yield();
                    ++i;
                }
            }
        };
    }

    private String getShortTestCaseName() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.util.test.CharBufferTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String className = clazz.getName();
        int index = className.lastIndexOf(46);
        String name = className.substring(index + 1);
        return name;
    }

    private void join(List threads) {
        Iterator iterator = threads.iterator();
        try {
            while (iterator.hasNext()) {
                Thread thread = (Thread)iterator.next();
                thread.join();
            }
        }
        catch (InterruptedException exception) {
            exception.printStackTrace();
        }
    }

    public void test_append_boolean() {
        this.assertAppendBoolean(true);
        this.assertAppendBoolean(false);
    }

    public void test_append_char() {
        ICharBuffer buffer = this.createBuffer(10);
        int expectedLength = 0;
        int actualLength = buffer.length();
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        int expectedCapacity = 10;
        int actualCapacity = buffer.capacity();
        Assert.assertEquals((int)expectedCapacity, (int)actualCapacity);
        char ch = VALUE1.charAt(0);
        buffer.append(ch);
        expectedLength = 1;
        actualLength = buffer.length();
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        int i = 1;
        while (i < 10) {
            ch = VALUE1.charAt(i);
            buffer.append(ch);
            ++i;
        }
        expectedLength = 10;
        actualLength = buffer.length();
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        ch = VALUE2.charAt(0);
        buffer.append(ch);
        expectedLength = 11;
        actualLength = buffer.length();
        this.assertGrow100Percent(buffer);
        this.assertGrowLinearly(buffer);
        expectedCapacity = 21;
        actualCapacity = buffer.capacity();
        Assert.assertEquals((int)expectedCapacity, (int)actualCapacity);
        char expectedCh = VALUE2.charAt(0);
        Assert.assertEquals((char)ch, (char)expectedCh);
        String expectedValue = VALUE1 + ch;
        String actualValue = buffer.getValue();
        Assert.assertEquals((String)expectedValue, (String)actualValue);
        buffer = this.createBuffer();
        Object objectParameter = null;
        buffer.append(objectParameter);
        expectedValue = String.valueOf(objectParameter);
        actualValue = buffer.getValue();
        Assert.assertEquals((String)expectedValue, (String)actualValue);
        buffer = this.createBuffer();
        String stringParameter = null;
        buffer.append(stringParameter);
        expectedValue = String.valueOf(stringParameter);
        actualValue = buffer.getValue();
    }

    public void test_append_char_array() {
        ICharBuffer buffer = this.createBuffer();
        char[] array = VALUE1.toCharArray();
        buffer.append(array);
        int expectedLength = array.length;
        int actualLength = buffer.length();
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        buffer = this.createBuffer();
        array = VALUE1.toCharArray();
        buffer.append(array, 0, 5);
        expectedLength = 5;
        actualLength = buffer.length();
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        String expectedValue = new String(array, 0, 5);
        String actualValue = buffer.getValue();
        Assert.assertEquals((String)expectedValue, (String)actualValue);
        buffer.append(array, 5, 5);
        expectedLength = 10;
        actualLength = buffer.length();
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        expectedValue = VALUE1;
        actualValue = buffer.getValue();
        Assert.assertEquals((String)expectedValue, (String)actualValue);
        buffer = this.createBuffer();
        array = VALUE1.toCharArray();
        buffer.append(array, 5, 5);
        expectedLength = 5;
        actualLength = buffer.length();
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        expectedValue = new String(array, 5, 5);
        actualValue = buffer.getValue();
        Assert.assertEquals((String)expectedValue, (String)actualValue);
        buffer = this.createBuffer();
        try {
            buffer.append(null, 0, 1);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            Assert.assertTrue((boolean)true);
        }
        array = VALUE1.toCharArray();
        try {
            buffer.append(array, -1, 1);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Assert.assertTrue((boolean)true);
        }
        try {
            buffer.append(array, 0, array.length + 1);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Assert.assertTrue((boolean)true);
        }
    }

    public void test_append_double() {
        this.assertAppendDouble(Double.MIN_VALUE);
        this.assertAppendDouble(Double.MAX_VALUE);
    }

    public void test_append_float() {
        this.assertAppendFloat(Float.MIN_VALUE);
        this.assertAppendFloat(Float.MAX_VALUE);
    }

    public void test_append_int() {
        this.assertAppendInt(Integer.MIN_VALUE);
        this.assertAppendInt(Integer.MAX_VALUE);
    }

    public void test_append_long() {
        this.assertAppendLong(Long.MIN_VALUE);
        this.assertAppendLong(Long.MAX_VALUE);
    }

    public void test_append_Object() {
        ICharBuffer buffer = this.createBuffer();
        Object objectParameter = null;
        buffer.append(objectParameter);
        String expectedValue = String.valueOf(objectParameter);
        String actualValue = buffer.getValue();
        Assert.assertEquals((String)expectedValue, (String)actualValue);
        buffer = this.createBuffer();
        String stringObject = null;
        buffer.append(stringObject);
        expectedValue = String.valueOf(stringObject);
        actualValue = buffer.getValue();
        Assert.assertEquals((String)expectedValue, (String)actualValue);
        expectedValue = "John Smith";
        class Person {
            private String name;
            final /* synthetic */ CharBufferTestCase this$0;

            Person(CharBufferTestCase charBufferTestCase, String name) {
                this.this$0 = charBufferTestCase;
                this.name = name;
            }

            public String toString() {
                return this.name;
            }
        }
        Person person = new Person(this, expectedValue);
        buffer = this.createBuffer();
        buffer.append((Object)person);
        actualValue = buffer.getValue();
        Assert.assertEquals((String)expectedValue, (String)actualValue);
    }

    public void test_append_String() {
        ICharBuffer buffer = this.createBuffer(5);
        buffer.append(VALUE1);
        buffer.append(VALUE2);
        String expectedValue = "ABCDEFGHIJKLMNOPQRST";
        String actualValue = buffer.getValue();
        Assert.assertEquals((String)expectedValue, (String)actualValue);
        buffer = this.createBuffer();
        buffer = this.createBuffer();
        String stringParameter = null;
        buffer.append(stringParameter);
        expectedValue = String.valueOf(stringParameter);
        actualValue = buffer.getValue();
        Assert.assertEquals((String)expectedValue, (String)actualValue);
    }

    public void test_asynchronousCharAppend() {
        ICharBuffer buffer = this.createBuffer(100);
        buffer = this.toFastGrowingSynchronizedBuffer(buffer);
        int threadCount = 26;
        int appendCount = 100;
        String prefix = this.getShortTestCaseName();
        ArrayList<Thread> threads = new ArrayList<Thread>(threadCount);
        int i = 0;
        while (i < threadCount) {
            String name = String.valueOf(prefix) + "-CharAppender-" + i;
            Runnable runnable = this.createCharAppenderRunnable(i, buffer, appendCount);
            Thread thread = new Thread(runnable, name);
            threads.add(thread);
            thread.start();
            ++i;
        }
        this.join(threads);
        int expectedLength = threadCount * appendCount;
        int actualLength = buffer.length();
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        String value = buffer.getValue();
        actualLength = value.length();
        Assert.assertEquals((int)expectedLength, (int)actualLength);
    }

    public void test_asynchronousCharAt() {
        ICharBuffer buffer = this.createBuffer(10);
        buffer = buffer.toSynchronizedCharBuffer();
        buffer.append(VALUE1);
        int threadCount = 25;
        int readCount = 100;
        String prefix = this.getShortTestCaseName();
        ArrayList<Thread> threads = new ArrayList<Thread>(threadCount);
        int i = 0;
        while (i < threadCount) {
            String name = String.valueOf(prefix) + "-Reader-" + i;
            Runnable runnable = this.createCharAtRunnable(buffer, readCount);
            Thread thread = new Thread(runnable, name);
            threads.add(thread);
            thread.start();
            ++i;
        }
        this.join(threads);
        Assert.assertTrue((boolean)true);
    }

    public void test_asynchronousStringAppend() {
        ICharBuffer buffer = this.createBuffer(100);
        buffer = this.toFastGrowingSynchronizedBuffer(buffer);
        int threadCount = 10;
        int appendCount = 100;
        String prefix = this.getShortTestCaseName();
        ArrayList<Thread> threads = new ArrayList<Thread>(threadCount);
        int i = 0;
        while (i < threadCount) {
            String name = String.valueOf(prefix) + "-StringAppender-" + i;
            Runnable runnable = this.createStringAppenderRunnable(VALUE1, buffer, appendCount);
            Thread thread = new Thread(runnable, name);
            threads.add(thread);
            thread.start();
            ++i;
        }
        this.join(threads);
        int expectedLength = threadCount * appendCount * VALUE1.length();
        int actualLength = buffer.length();
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        String value = buffer.getValue();
        actualLength = value.length();
        Assert.assertEquals((int)expectedLength, (int)actualLength);
    }

    public void test_capacity() {
        ICharBuffer buffer = this.createBuffer(10);
        int expectedCapacity = 10;
        int actualCapacity = buffer.capacity();
        Assert.assertEquals((int)expectedCapacity, (int)actualCapacity);
        buffer.append(VALUE1);
        actualCapacity = buffer.capacity();
        Assert.assertEquals((int)expectedCapacity, (int)actualCapacity);
        this.assertGrow100Percent(buffer);
        this.assertGrowLinearly(buffer);
        buffer.append(VALUE2);
        expectedCapacity = 30;
        actualCapacity = buffer.capacity();
        Assert.assertEquals((int)expectedCapacity, (int)actualCapacity);
    }

    public void test_charAt() {
        ICharBuffer buffer = this.createBuffer();
        buffer.append(VALUE1);
        int expectedLength = VALUE1.length();
        int actualLength = buffer.length();
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        int i = 0;
        while (i < actualLength) {
            char expectedCh = VALUE1.charAt(i);
            char actualCh = buffer.charAt(i);
            Assert.assertEquals((char)expectedCh, (char)actualCh);
            ++i;
        }
        try {
            buffer.charAt(-1);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Assert.assertTrue((boolean)true);
        }
    }

    public void test_constructor() {
        int expectedCapacity = 10;
        ICharBuffer buffer = this.createBuffer(expectedCapacity);
        int actualCapacity = buffer.capacity();
        Assert.assertEquals((int)expectedCapacity, (int)actualCapacity);
        buffer = this.createBuffer(0);
        int capacity = buffer.capacity();
        Assert.assertTrue((capacity != 0 ? 1 : 0) != 0);
    }

    public void test_getGrowPercentage() {
        ICharBuffer buffer = this.createBuffer();
        this.assertGrow100Percent(buffer);
        int expectedGrowPercentage = 50;
        buffer.setGrowPercentage(expectedGrowPercentage);
        int actualGrowPercentage = buffer.getGrowPercentage();
        Assert.assertEquals((int)expectedGrowPercentage, (int)actualGrowPercentage);
        expectedGrowPercentage = 200;
        buffer.setGrowPercentage(expectedGrowPercentage);
        actualGrowPercentage = buffer.getGrowPercentage();
        Assert.assertEquals((int)expectedGrowPercentage, (int)actualGrowPercentage);
        try {
            buffer.setGrowPercentage(0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
    }

    public void test_getGrowStyle() {
        ICharBuffer buffer = this.createBuffer();
        this.assertGrowLinearly(buffer);
        buffer.setGrowStyle((short)1);
        this.assertGrowExponentially(buffer);
        buffer.setGrowStyle((short)0);
        this.assertGrowLinearly(buffer);
    }

    public void test_getValue() {
        ICharBuffer buffer = this.createBuffer();
        String expectedValue = new String();
        String actualValue = buffer.getValue();
        Assert.assertEquals((String)expectedValue, (String)actualValue);
        int start = 65;
        int stop = 74;
        int i = start;
        while (i <= stop) {
            char ch = (char)i;
            buffer.append(ch);
            ++i;
        }
        buffer.append(VALUE2);
        expectedValue = "ABCDEFGHIJKLMNOPQRST";
        actualValue = buffer.getValue();
        Assert.assertEquals((String)expectedValue, (String)actualValue);
    }

    public void test_length() {
        ICharBuffer buffer = this.createBuffer(10);
        int expectedLength = 0;
        int actualLength = buffer.length();
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        buffer.append(VALUE1);
        expectedLength = VALUE1.length();
        actualLength = buffer.length();
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        buffer.append(VALUE2);
        actualLength = buffer.length();
        Assert.assertEquals((int)(expectedLength += VALUE2.length()), (int)actualLength);
    }

    public void test_setChar() {
        int capacity = 10;
        ICharBuffer buffer = this.createBuffer(capacity);
        try {
            buffer.setChar(-1, 'X');
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Assert.assertTrue((boolean)true);
        }
        buffer.append(VALUE1);
        int i = 0;
        while (i < capacity) {
            String value = String.valueOf(i);
            char ch = value.charAt(0);
            buffer.setChar(i, ch);
            ++i;
        }
        String expectedValue = "0123456789";
        String actualValue = buffer.getValue();
        Assert.assertEquals((String)expectedValue, (String)actualValue);
    }

    public void test_setGrowPercentage() {
        ICharBuffer buffer = this.createBuffer();
        this.assertGrow100Percent(buffer);
        try {
            buffer.setGrowPercentage(0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
    }

    public void test_setGrowStyle() {
        ICharBuffer buffer = this.createBuffer(1);
        buffer.append('A');
        this.assertGrowLinearly(buffer);
        short style = 100;
        buffer.setGrowStyle(style);
        try {
            buffer.append('Z');
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            Assert.assertTrue((boolean)true);
        }
    }

    public void test_setLength() {
        ICharBuffer buffer = this.createBuffer();
        buffer.append(VALUE1);
        buffer.setLength(3);
        int expectedLength = 3;
        int actualLength = buffer.length();
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        String expectedValue = VALUE1.substring(0, 3);
        String actualValue = buffer.getValue();
        Assert.assertEquals((String)expectedValue, (String)actualValue);
        buffer.setLength(4);
        expectedLength = 4;
        actualLength = buffer.length();
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        expectedValue = String.valueOf(expectedValue) + '\u0000';
        actualValue = buffer.getValue();
        Assert.assertEquals((String)expectedValue, (String)actualValue);
        String value = VALUE1.substring(3, 6);
        buffer.append(value);
        expectedValue = String.valueOf(expectedValue) + value;
        actualValue = buffer.getValue();
        Assert.assertEquals((String)expectedValue, (String)actualValue);
        expectedLength = 7;
        actualLength = buffer.length();
        Assert.assertEquals((int)expectedLength, (int)actualLength);
    }

    public void test_synchronization() {
        ICharBuffer buffer = this.createBuffer();
        ICharBuffer synchronizedBuffer = buffer.toSynchronizedCharBuffer();
        int threadCount = 26;
        int appendCount = 100;
        String prefix = this.getShortTestCaseName();
        ArrayList<Thread> threads = new ArrayList<Thread>(threadCount * 2);
        int i = 0;
        while (i < threadCount) {
            String name = String.valueOf(prefix) + "-CharAppender-" + i;
            Runnable runnable = this.createCharAppenderRunnable(i, synchronizedBuffer, appendCount);
            Thread thread = new Thread(runnable, name);
            threads.add(thread);
            thread.start();
            name = String.valueOf(prefix) + "-createCharAppenderWithSynchronization-" + i;
            runnable = this.createCharAppenderWithSynchronizationRunnable(i, buffer, appendCount);
            thread = new Thread(runnable, name);
            threads.add(thread);
            thread.start();
            ++i;
        }
        this.join(threads);
        Assert.assertTrue((boolean)true);
    }

    public void test_toArray() {
        ICharBuffer buffer = this.createBuffer();
        buffer.append(VALUE1);
        char[] expectedCharArray = VALUE1.toCharArray();
        char[] actualCharArray = buffer.toArray();
        boolean equal = Arrays.equals(expectedCharArray, actualCharArray);
        Assert.assertTrue((boolean)equal);
        int length = buffer.length();
        char[] array = new char[length];
        actualCharArray = buffer.toArray(array);
        Assert.assertSame((Object)array, (Object)actualCharArray);
        array = new char[1];
        actualCharArray = buffer.toArray(array);
        Assert.assertNotSame((Object)array, (Object)actualCharArray);
        equal = Arrays.equals(expectedCharArray, actualCharArray);
        Assert.assertTrue((boolean)equal);
        actualCharArray = buffer.toArray(null);
        equal = Arrays.equals(expectedCharArray, actualCharArray);
        Assert.assertTrue((boolean)equal);
    }

    public void test_toSynchronizedBuffer() {
        ICharBuffer buffer = this.createBuffer();
        ICharBuffer synchronizedBuffer = buffer.toSynchronizedCharBuffer();
        Assert.assertNotSame((Object)buffer, (Object)synchronizedBuffer);
        ICharBuffer alias = synchronizedBuffer.toSynchronizedCharBuffer();
        Assert.assertSame((Object)synchronizedBuffer, (Object)alias);
        ICharBuffer synchronizedBuffer2 = buffer.toSynchronizedCharBuffer();
        Assert.assertNotSame((Object)synchronizedBuffer, (Object)synchronizedBuffer2);
        String expectedName = "SynchronizedCharBuffer";
        Class<?> clazz = synchronizedBuffer.getClass();
        String actualName = clazz.getName();
        boolean state = actualName.endsWith(expectedName);
        Assert.assertTrue((boolean)state);
    }

    private ICharBuffer toFastGrowingSynchronizedBuffer(ICharBuffer buffer) {
        buffer.setGrowPercentage(500);
        buffer.setGrowStyle((short)1);
        buffer = buffer.toSynchronizedCharBuffer();
        return buffer;
    }
}

