/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record.test;

import java.util.Dictionary;
import java.util.Hashtable;
import junit.framework.Assert;
import org.eclipse.soda.sat.core.junit.internal.AbstractServiceTestCase;
import org.eclipse.soda.sat.core.record.interfaces.IExportServiceRecord;
import org.eclipse.soda.sat.junit.util.ValueHolder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public abstract class AbstractExportServiceRecordTestCase
extends AbstractServiceTestCase {
    private static final String COMPANY_KEY = "company";
    private static final String ECLIPSE_ORG = "Eclipse.org";
    private static final String IBM_ORG = "IBM";
    private Object service;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected AbstractExportServiceRecordTestCase(String name) {
        super(name);
    }

    protected abstract IExportServiceRecord createExportServiceRecord(BundleContext var1, Class[] var2, Dictionary var3);

    private boolean exists(Object[] values, Object value) {
        int length = values.length;
        boolean found = false;
        int i = 0;
        while (!found && i < length) {
            Object object = values[i];
            found = object.equals(value);
            ++i;
        }
        return found;
    }

    protected final Object getService() {
        return this.service;
    }

    private void setService(Object service) {
        this.service = service;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setService(new TestServiceImplementation());
    }

    protected void tearDown() throws Exception {
        this.setService(null);
        super.tearDown();
    }

    public void test_getNames() {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase$TestService1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase$TestService2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] types = classArray;
        BundleContext context = this.getBundleContext();
        IExportServiceRecord record = this.createExportServiceRecord(context, types, null);
        String[] expectedNames = this.toStringArray(types);
        String[] actualNames = record.getNames();
        int expectedLength = expectedNames.length;
        int actualLength = actualNames.length;
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        int i = 0;
        while (i < expectedLength) {
            String expectedName = expectedNames[i];
            String actualName = actualNames[i];
            Assert.assertEquals((Object)expectedName, (Object)actualName);
            ++i;
        }
    }

    public void test_getProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>(11);
        ((Dictionary)properties).put(COMPANY_KEY, ECLIPSE_ORG);
        BundleContext context = this.getBundleContext();
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase$TestService1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] types = classArray;
        IExportServiceRecord record = this.createExportServiceRecord(context, types, properties);
        Hashtable<String, String> expected = properties;
        Dictionary actual = record.getProperties();
        Assert.assertSame(expected, (Object)actual);
    }

    public void test_getProperty() {
        BundleContext context = this.getBundleContext();
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase$TestService1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] types = classArray;
        Hashtable<String, String> properties = new Hashtable<String, String>(11);
        ((Dictionary)properties).put(COMPANY_KEY, ECLIPSE_ORG);
        IExportServiceRecord record = this.createExportServiceRecord(context, types, properties);
        String expected = ECLIPSE_ORG;
        Object actual = record.getProperty(COMPANY_KEY);
        Assert.assertSame((Object)expected, (Object)actual);
    }

    public void test_getPropertyKeys() {
        BundleContext context = this.getBundleContext();
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase$TestService1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] types = classArray;
        Hashtable<String, String> properties = new Hashtable<String, String>(11);
        ((Dictionary)properties).put(COMPANY_KEY, ECLIPSE_ORG);
        IExportServiceRecord record = this.createExportServiceRecord(context, types, properties);
        Object[] keys = record.getPropertyKeys();
        boolean found = this.exists(keys, COMPANY_KEY);
        Assert.assertTrue((boolean)found);
        record.register();
        keys = record.getPropertyKeys();
        found = this.exists(keys, COMPANY_KEY);
        Assert.assertTrue((boolean)found);
        record.unregister();
        keys = record.getPropertyKeys();
        found = this.exists(keys, COMPANY_KEY);
        Assert.assertTrue((boolean)found);
    }

    public abstract void test_getService();

    public void test_getServiceReference() {
        BundleContext context = this.getBundleContext();
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase$TestService1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] types = classArray;
        IExportServiceRecord record = this.createExportServiceRecord(context, types, null);
        ServiceReference reference = record.getServiceReference();
        Assert.assertNull((Object)reference);
        record.register();
        reference = record.getServiceReference();
        Assert.assertNotNull((Object)reference);
        Object[] objectClasses = (Object[])reference.getProperty("objectClass");
        int expectedLength = 1;
        int actualLength = objectClasses.length;
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        String expectedObjectClass = TestService1.SERVICE_NAME;
        Object actualObjectClass = objectClasses[0];
        Assert.assertEquals((Object)expectedObjectClass, (Object)actualObjectClass);
        record.unregister();
        reference = record.getServiceReference();
        Assert.assertNull((Object)reference);
    }

    public abstract void test_isProxy();

    public void test_isRegistered() {
        BundleContext context = this.getBundleContext();
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase$TestService1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] types = classArray;
        IExportServiceRecord record = this.createExportServiceRecord(context, types, null);
        boolean isRegistered = record.isRegistered();
        Assert.assertFalse((boolean)isRegistered);
        record.register();
        isRegistered = record.isRegistered();
        Assert.assertTrue((boolean)isRegistered);
        record.unregister();
        isRegistered = record.isRegistered();
        Assert.assertFalse((boolean)isRegistered);
    }

    public void test_register() throws InvalidSyntaxException {
        BundleContext context = this.getBundleContext();
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase$TestService1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] types = classArray;
        final ValueHolder serviceEventTypeHolder = ValueHolder.nullValue();
        ServiceListener listener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                int type = event.getType();
                serviceEventTypeHolder.setValue((Object)new Integer(type));
            }
        };
        String filter = "(objectClass=" + TestService1.SERVICE_NAME + ')';
        context.addServiceListener(listener, filter);
        IExportServiceRecord record = this.createExportServiceRecord(context, types, null);
        record.register();
        int expectedType = 1;
        Integer wrapper = (Integer)serviceEventTypeHolder.getValue();
        int actualType = wrapper;
        Assert.assertEquals((int)expectedType, (int)actualType);
        context.removeServiceListener(listener);
        record.unregister();
    }

    public void test_setProperties() throws InvalidSyntaxException, InterruptedException {
        BundleContext context = this.getBundleContext();
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase$TestService1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] types = classArray;
        Hashtable<String, String> properties = new Hashtable<String, String>(11);
        ((Dictionary)properties).put(COMPANY_KEY, ECLIPSE_ORG);
        IExportServiceRecord record = this.createExportServiceRecord(context, types, properties);
        record.register();
        Thread.sleep(100L);
        final ValueHolder serviceEventTypeHolder = ValueHolder.nullValue();
        final ValueHolder propertyValueHolder = ValueHolder.nullValue();
        ServiceListener listener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                int type = event.getType();
                serviceEventTypeHolder.setValue((Object)new Integer(type));
                ServiceReference reference = event.getServiceReference();
                Object value = reference.getProperty(AbstractExportServiceRecordTestCase.COMPANY_KEY);
                propertyValueHolder.setValue(value);
            }
        };
        String filter = "(objectClass=" + TestService1.SERVICE_NAME + ')';
        context.addServiceListener(listener, filter);
        Long preTimestampWrapper = (Long)((Dictionary)properties).get("service.registration.timestamp");
        long preTimestamp = preTimestampWrapper;
        ((Dictionary)properties).put(COMPANY_KEY, IBM_ORG);
        record.setProperties(properties);
        int expectedServiceEventType = 2;
        Integer wrapper = (Integer)serviceEventTypeHolder.getValue();
        int actualServiceEventType = wrapper;
        Assert.assertEquals((int)expectedServiceEventType, (int)actualServiceEventType);
        String expectedPropertyValue = IBM_ORG;
        Object actualPropertyValue = propertyValueHolder.getValue();
        Assert.assertEquals((Object)expectedPropertyValue, (Object)actualPropertyValue);
        Long postTimestampWrapper = (Long)((Dictionary)properties).get("service.registration.timestamp");
        long postTimestamp = postTimestampWrapper;
        long timestampDelta = postTimestamp - preTimestamp;
        boolean updatedTimestamp = timestampDelta != 0L;
        Assert.assertTrue((boolean)updatedTimestamp);
        context.removeServiceListener(listener);
        record.unregister();
    }

    public void test_unregister() throws InvalidSyntaxException {
        BundleContext context = this.getBundleContext();
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase$TestService1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] types = classArray;
        final ValueHolder serviceEventTypeHolder = ValueHolder.nullValue();
        ServiceListener listener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                int type = event.getType();
                serviceEventTypeHolder.setValue((Object)new Integer(type));
            }
        };
        String filter = "(objectClass=" + TestService1.SERVICE_NAME + ')';
        context.addServiceListener(listener, filter);
        IExportServiceRecord record = this.createExportServiceRecord(context, types, null);
        record.register();
        record.unregister();
        context.removeServiceListener(listener);
        int expectedServiceEventType = 4;
        Integer wrapper = (Integer)serviceEventTypeHolder.getValue();
        int actualServiceEventType = wrapper;
        Assert.assertEquals((int)expectedServiceEventType, (int)actualServiceEventType);
    }

    protected final String[] toStringArray(Class[] types) {
        String[] names = new String[types.length];
        int i = 0;
        while (i < types.length) {
            String name;
            Class type = types[i];
            names[i] = name = type.getName();
            ++i;
        }
        return names;
    }

    protected static interface TestService1 {
        public static final String SERVICE_NAME;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase$TestService1");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SERVICE_NAME = clazz.getName();
        }
    }

    protected static interface TestService2 {
        public static final String SERVICE_NAME;

        static {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase$TestService2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SERVICE_NAME = clazz.getName();
        }
    }

    protected static class TestServiceImplementation
    implements TestService1,
    TestService2 {
        protected TestServiceImplementation() {
        }
    }
}

