/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.nls.Nls;

public class HistoryQueue {
    protected static final char[] CRLFTAB_CHAR = "\r\n\t".toCharArray();
    protected Object[] elementsData;
    protected Object[] elementsKey;
    private int head = 0;
    int length;
    private int size = 0;
    private int tail = 0;

    public HistoryQueue() {
        this(8);
    }

    public HistoryQueue(int size) {
        this.elementsData = new Object[size];
        this.elementsKey = new Object[size];
        this.length = size;
    }

    public void enqueue(Object data) {
        this.enqueue(EscObject.getCurrentTimestamp(), data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object key, Object data) {
        try {
            HistoryQueue historyQueue = this;
            synchronized (historyQueue) {
                if (this.size == 0) {
                    this.head = 0;
                    this.tail = 1;
                    this.elementsKey[this.head] = key;
                    this.elementsData[this.head] = data;
                } else {
                    int high = this.tail - 1;
                    if (high < 0) {
                        high = this.length + high;
                    }
                    this.elementsKey[this.tail] = key;
                    this.elementsData[this.tail] = data;
                    ++this.tail;
                    if (this.tail >= this.length) {
                        this.tail -= this.length;
                    }
                }
                if (this.size < this.elementsData.length) {
                    ++this.size;
                }
                this.notify();
            }
        }
        catch (RuntimeException exception) {
            exception.printStackTrace();
        }
    }

    public int getMaxSize() {
        return this.length;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append('{');
        boolean first = true;
        int lineOffset = 0;
        int count = 1;
        while (count <= this.size) {
            int i = this.tail - count;
            if (i >= this.length) {
                i -= this.length;
            } else if (i < 0) {
                i += this.length;
            }
            Object timestampObject = this.elementsKey[i];
            Object data = this.elementsData[i];
            long timestamp = 0L;
            int offset = 0;
            if (!first) {
                buffer.append(',');
                offset = buffer.length();
                buffer.append(' ');
            }
            if (timestampObject instanceof Number) {
                timestamp = ((Number)timestampObject).longValue();
                if (timestampObject instanceof Long) {
                    if (timestamp < 0L) {
                        buffer.append(Nls.formatTimestamp((long)(-timestamp), (int)15));
                        buffer.append('>');
                    } else {
                        buffer.append(Nls.formatTimestamp((long)timestamp, (int)15));
                        buffer.append('<');
                    }
                    buffer.append(Nls.formatData((Object)data));
                } else if (data instanceof byte[]) {
                    byte[] bytes = (byte[])data;
                    int length = (int)timestamp;
                    if (length < 0) {
                        length = -length;
                        buffer.append('>');
                    } else {
                        buffer.append('<');
                    }
                    String dataString = Nls.formatHexBytes((byte[])bytes, (int)0, (int)length);
                    buffer.append(dataString);
                } else {
                    buffer.append(timestampObject);
                    buffer.append('=');
                    buffer.append(Nls.formatData((Object)data));
                }
            } else {
                buffer.append(timestampObject);
                buffer.append('=');
                buffer.append(Nls.formatData((Object)data));
            }
            first = false;
            int size = buffer.length();
            int lineLength = size - lineOffset;
            if (lineLength > 60 && offset > 0) {
                buffer.insert(offset, CRLFTAB_CHAR);
                lineOffset = size;
            }
            ++count;
        }
        buffer.append('}');
        return buffer.toString();
    }
}

