/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testcontroller.remote.rmi;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RemoteObject;
import org.eclipse.soda.dk.testcontroller.remote.rmi.RemoteTestController;

public class ControllerRegistry {
    public static final int REGISTRY_PORT = 2099;
    private int port;
    ServerSocket serverSocket;
    RemoteTestController testController;

    public ControllerRegistry(int port) {
        this.port = port <= 0 ? 2099 : port;
    }

    public synchronized void bind(RemoteTestController testController) throws IOException {
        if (this.testController != null) {
            this.unbind();
        }
        this.serverSocket = new ServerSocket(this.port);
        this.testController = testController;
        Runnable requestHandler = new Runnable(){

            public void run() {
                while (ControllerRegistry.this.serverSocket != null) {
                    try {
                        Socket socket = ControllerRegistry.this.serverSocket.accept();
                        ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());
                        out.writeObject(RemoteObject.toStub(ControllerRegistry.this.testController));
                        out.flush();
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        new Thread(requestHandler).start();
    }

    public RemoteTestController getTestController() {
        return this.testController;
    }

    public synchronized void unbind() throws IOException {
        if (this.testController != null) {
            this.serverSocket.close();
            this.serverSocket = null;
            this.testController = null;
        }
    }
}

