/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.tcpip.server.multiplex.connection;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.multiplex.connection.service.MultiplexConnectionListener;
import org.eclipse.soda.dk.tcpip.multiplex.connection.TcpipChannelBinding;
import org.eclipse.soda.dk.tcpip.multiplex.connection.TcpipMultiplexConnection;
import org.eclipse.soda.dk.tcpip.server.multiplex.connection.service.TcpipServerMultiplexConnectionService;

public class TcpipServerMultiplexConnection
extends TcpipMultiplexConnection
implements ConnectionService,
TcpipServerMultiplexConnectionService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.tcpip.server.multiplex.connection.TcpipServerMultiplexConnection";
    protected static final char[] TOSTRING_NAME = "TcpipServerMultiplexConnection[".toCharArray();
    private ServerSocketChannel serverChannel;
    private int maxChannels;

    public TcpipServerMultiplexConnection(ConfigurationService configuration) {
        super(configuration);
    }

    public TcpipServerMultiplexConnection(Dictionary properties) {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    public TcpipServerMultiplexConnection(String localhost, int localport, int maxchannels, int queuelength, int linger, int readsize, int writesize) throws IllegalArgumentException {
        Hashtable<String, Object> table = new Hashtable<String, Object>(23);
        if (localhost != null && !"0.0.0.0".equals(localhost)) {
            table.put("localhost", localhost);
        }
        if (localport != 8901) {
            table.put("localport", TcpipServerMultiplexConnection.createInteger((int)localport));
        }
        if (maxchannels != -1) {
            table.put("maxchannels", TcpipServerMultiplexConnection.createInteger((int)maxchannels));
        }
        if (queuelength != -1) {
            table.put("queuelength", TcpipServerMultiplexConnection.createInteger((int)queuelength));
        }
        if (linger != -1) {
            table.put("linger", TcpipServerMultiplexConnection.createInteger((int)linger));
        }
        if (readsize != -1) {
            table.put("readsize", TcpipServerMultiplexConnection.createInteger((int)readsize));
        }
        if (writesize != -1) {
            table.put("writesize", TcpipServerMultiplexConnection.createInteger((int)writesize));
        }
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    public TcpipServerMultiplexConnection(int port) {
        this(port, -1);
    }

    public TcpipServerMultiplexConnection(int port, int queueLength) {
        this(port, queueLength, -1);
    }

    public TcpipServerMultiplexConnection(int port, int queueLength, int linger) {
        this(null, port, queueLength, linger, -1);
    }

    public TcpipServerMultiplexConnection(String localHost, int port, int queueLength, int linger) {
        this(localHost, port, queueLength, linger, -1);
    }

    public TcpipServerMultiplexConnection(String localHost, int port, int queueLength, int linger, int maxChannels) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        if (localHost != null) {
            table.put("localhost", localHost);
        }
        table.put("localport", TcpipServerMultiplexConnection.createInteger((int)port));
        table.put("queuelength", TcpipServerMultiplexConnection.createInteger((int)queueLength));
        table.put("linger", TcpipServerMultiplexConnection.createInteger((int)linger));
        table.put("maxchannels", TcpipServerMultiplexConnection.createInteger((int)maxChannels));
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    public synchronized void close() throws IOException {
        if (this.serverChannel != null) {
            Throwable exception = null;
            try {
                this.serverChannel.close();
                this.serverChannel = null;
            }
            catch (Exception exception2) {
                this.report(exception, 1002, this.toString());
            }
        }
        super.close();
    }

    private void initServerSocket() throws IOException {
        int localPort = this.getInt("localport", this.getInt("port", 8901));
        String localHost = this.getString("localhost", "0.0.0.0");
        int queueLength = this.getInt("queuelength", -1);
        this.maxChannels = this.getInt("maxchannels", -1);
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        ServerSocket serverSocket = this.serverChannel.socket();
        InetSocketAddress endpoint = new InetSocketAddress(localHost, localPort);
        if (queueLength != -1) {
            serverSocket.bind(endpoint, queueLength);
        } else {
            serverSocket.bind(endpoint);
        }
        this.serverChannel.register(this.selector, 16);
    }

    public synchronized void open() throws IOException {
        super.open();
        if (this.serverChannel == null) {
            this.initServerSocket();
        }
    }

    protected void processAccept(MultiplexConnectionListener listener, SelectionKey key) throws IOException {
        block6: {
            ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
            SocketChannel socketChannel = serverSocketChannel.accept();
            TcpipChannelBinding channel = null;
            try {
                socketChannel.configureBlocking(false);
                Socket socket = socketChannel.socket();
                socket.setTcpNoDelay(true);
                int linger = this.getInt("linger", -1);
                if (linger >= 0) {
                    if (linger == 0) {
                        socket.setSoLinger(false, 0);
                    } else {
                        socket.setSoLinger(true, linger);
                    }
                }
                channel = this.createChannel(this.createChannelId());
                channel.setSocketChannel(socketChannel);
                channel.open();
                socketChannel.register(this.selector, 1);
                channel.start();
                if (this.maxChannels > 0 && this.getChannels().size() >= this.maxChannels) {
                    key.interestOps(0);
                }
            }
            catch (IOException e) {
                this.handleError(e, 1015, channel);
                if (channel == null) break block6;
                channel.exit();
            }
        }
    }

    public void processEvents() throws Exception {
        super.processEvents();
        if (this.maxChannels > 0 && this.getChannels().size() < this.maxChannels) {
            SelectionKey key = this.serverChannel.keyFor(this.selector);
            key.interestOps(16);
        }
    }

    public void toStringInfo(StringBuffer buffer) {
        super.toStringInfo(buffer);
        buffer.append(',');
        if (this.serverChannel != null) {
            buffer.append(this.serverChannel);
        } else {
            int port = this.getInt("localport", this.getInt("port", 8901));
            buffer.append(port);
        }
    }
}

