/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.rfid.inventory.benchmark.profile;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.MethodMeasurement;
import org.eclipse.soda.dk.profile.Profile;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.rfid.inventory.benchmark.profile.service.RfidInventoryBenchmarkProfileService;
import org.eclipse.soda.dk.signal.Signal;

public class RfidInventoryBenchmarkProfile
extends Profile
implements ProfileService,
RfidInventoryBenchmarkProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.rfid.inventory.benchmark.profile.RfidInventoryBenchmarkProfile";
    public static final String RFID_INVENTORY_PROFILE_PREFIX = "RfidInventoryProfilePrefix";
    protected String rfidInventoryProfileServiceTagReadingExternalKey = null;
    protected String rfidInventoryProfileServiceTagReadingGetExternalKey = null;
    protected String rfidInventoryProfileServiceTagReportExternalKey = null;
    private final MethodMeasurement benchmarking = new MethodMeasurement("RfidInventoryBenchmark/Benchmarking", (Object)Boolean.FALSE);
    private final Signal benchmarkReport = new Signal("RfidInventoryBenchmark/BenchmarkReport");
    private String startingTimestampKey = "";
    private static final String NA = "n/a";
    private long currentSerialNum;
    private long currentTagReadStartTimestamp;
    private double currentTotalProcessTime;
    private long currentTagReads;
    private long currentLongest;
    private long currentShortest;
    private long currentStartDelay;
    private boolean tagReadState;
    private Set currentTagReportCounts = new HashSet();
    private List currentTagList;
    private double currentTotalDeviceProcessTime;
    private long currentLongestDeviceProcessTime;
    private long currentShortestDeviceProcessTime;
    private double currentTotalNotificationTime;
    private long currentLongestNotificationTime;
    private long currentShortestNotificationTime;
    private double currentTotalReaderTransmitTime;
    private long currentLongestReaderTransmitTime;
    private long currentShortestReaderTransmitTime;

    public RfidInventoryBenchmarkProfile() {
        super("RfidInventoryBenchmarkProfile/Capabilities", "RfidInventoryBenchmarkProfile/Status", "RfidInventoryBenchmarkProfile/Configuration", "RfidInventoryBenchmarkProfile/Metrics");
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public String getRfidInventoryProfilePrefix() {
        return this.getString(RFID_INVENTORY_PROFILE_PREFIX, this.getPrefix());
    }

    public void notificationReceived(String externalKey, Dictionary data) {
        if (externalKey.equals(this.rfidInventoryProfileServiceTagReadingExternalKey)) {
            this.handleRfidInventoryProfileServiceTagReading(externalKey, data);
            return;
        }
        if (externalKey.equals(this.rfidInventoryProfileServiceTagReportExternalKey)) {
            this.handleRfidInventoryProfileServiceTagReport(externalKey, data);
            return;
        }
        super.notificationReceived(externalKey, data);
    }

    public void setupNotification() {
        String rfidInventoryProfilePrefix = this.getRfidInventoryProfilePrefix();
        this.rfidInventoryProfileServiceTagReadingExternalKey = this.prependPrefix(rfidInventoryProfilePrefix, "RfidInventory/TagReading");
        this.rfidInventoryProfileServiceTagReadingGetExternalKey = this.prependPrefix(rfidInventoryProfilePrefix, "RfidInventory/TagReading/get");
        this.rfidInventoryProfileServiceTagReportExternalKey = this.prependPrefix(rfidInventoryProfilePrefix, "RfidInventory/TagReport");
        this.register(new String[]{this.rfidInventoryProfileServiceTagReadingExternalKey, this.rfidInventoryProfileServiceTagReportExternalKey});
        super.setupNotification();
        this.broadcast(this.rfidInventoryProfileServiceTagReadingGetExternalKey, new Hashtable());
    }

    public String getDefaultKey() {
        return "RfidInventoryBenchmarkProfile";
    }

    public DeviceService getDefaultDevice() {
        return null;
    }

    public boolean isDeviceNeeded() {
        return false;
    }

    public int getControlCapacity() {
        return 5;
    }

    public int getMessageCapacity() {
        return 2;
    }

    private void initialize() {
        MethodMeasurement benchmarking = this.benchmarking;
        this.put((ControlService)benchmarking);
        Signal benchmarkReport = this.benchmarkReport;
        this.put((ControlService)benchmarkReport);
    }

    public void setStartingTimestampKey(String StartingTimestampKey) {
        this.startingTimestampKey = StartingTimestampKey;
    }

    public String getStartingTimestampKey() {
        return this.startingTimestampKey;
    }

    public void setup() {
        super.setup();
        this.setNotificationPriority(this.getInt("rfidinventorybenchmarkprofile.notificationpriority", this.getNotificationPriority()));
        this.setStartingTimestampKey(this.getString("rfidinventorybenchmarkprofile.startingtimestampkey", this.getStartingTimestampKey()));
    }

    public boolean isAdapterNeeded() {
        return false;
    }

    private void addToCurrentTagList(Map tagReport) {
        if (this.currentTagList == null) {
            this.currentTagList = new ArrayList();
        }
        this.currentTagList.add(tagReport);
    }

    protected long getNewTagReadSerialNum() {
        ++this.currentSerialNum;
        return this.currentSerialNum;
    }

    private boolean getTagReadState() {
        return this.tagReadState;
    }

    public Object handleMethodBenchmarking(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetBenchmarking(measurement, data);
            }
        }
        return null;
    }

    private void handleRfidInventoryProfileServiceTagReading(String externalKey, Dictionary data) {
        long timeStamp;
        boolean tagReading = this.getBooleanValue(data.get("value"));
        if (tagReading == this.getTagReadState()) {
            return;
        }
        this.setTagReadState(tagReading);
        Number dataTimestamp = (Number)data.get("timestamp");
        long l = timeStamp = dataTimestamp != null ? dataTimestamp.longValue() : ((Number)RfidInventoryBenchmarkProfile.getCurrentTimestamp()).longValue();
        if (tagReading) {
            this.tagReadStarted(timeStamp);
        } else {
            this.tagReadStopped(timeStamp);
        }
    }

    private void handleRfidInventoryProfileServiceTagReport(String externalKey, Dictionary data) {
        if (this.isBenchmarking()) {
            HashMap<String, Object> tagReportMap = new HashMap<String, Object>();
            Object currentTimestampObj = RfidInventoryBenchmarkProfile.getCurrentTimestamp();
            long currentTimestamp = ((Number)RfidInventoryBenchmarkProfile.getCurrentTimestamp()).longValue();
            tagReportMap.put("receivingtimestamp", currentTimestampObj);
            Object devicekitStartingTimestampObj = data.get("timestamp");
            long devicekitStartingTimestamp = ((Number)data.get("timestamp")).longValue();
            tagReportMap.put("devicekitstartingtimestamp", devicekitStartingTimestampObj);
            Object notificationTimestampObj = data.get("notification.timestamp");
            if (notificationTimestampObj != null) {
                long notificationTimestamp = ((Number)notificationTimestampObj).longValue();
                long notificationTime = currentTimestamp - notificationTimestamp;
                long devicekitProcessTime = notificationTimestamp - devicekitStartingTimestamp;
                tagReportMap.put("notificationtimestamp", notificationTimestampObj);
                tagReportMap.put("notificationtime", RfidInventoryBenchmarkProfile.createLong((long)notificationTime));
                tagReportMap.put("devicekitprocesstime", RfidInventoryBenchmarkProfile.createLong((long)devicekitProcessTime));
                this.currentTotalNotificationTime += (double)notificationTime;
                this.currentLongestNotificationTime = notificationTime > this.currentLongestNotificationTime ? notificationTime : this.currentLongestNotificationTime;
                this.currentShortestNotificationTime = notificationTime < this.currentShortestNotificationTime ? notificationTime : this.currentShortestNotificationTime;
                this.currentTotalDeviceProcessTime += (double)devicekitProcessTime;
                this.currentLongestDeviceProcessTime = devicekitProcessTime > this.currentLongestDeviceProcessTime ? devicekitProcessTime : this.currentLongestDeviceProcessTime;
                this.currentShortestDeviceProcessTime = devicekitProcessTime < this.currentShortestDeviceProcessTime ? devicekitProcessTime : this.currentShortestDeviceProcessTime;
            } else {
                tagReportMap.put("notificationtimestamp", NA);
                tagReportMap.put("notificationtime", NA);
                tagReportMap.put("devicekitprocesstime", NA);
                this.currentTotalNotificationTime = -1.0;
                this.currentTotalDeviceProcessTime = -1.0;
            }
            long readerStartingTimestamp = 0L;
            Map tagReport = (Map)data.get("value");
            Map tags = (Map)tagReport.get("tags");
            Iterator tagEntries = tags.entrySet().iterator();
            if (tagEntries.hasNext()) {
                Map.Entry tag = tagEntries.next();
                String tagId = (String)tag.getKey();
                this.currentTagReportCounts.add(tagId);
                tagReportMap.put("tagid", tagId);
                Map tagMap = (Map)tag.getValue();
                Object readerStartingTimestampObj = tagMap.get(this.getStartingTimestampKey());
                if (readerStartingTimestampObj != null) {
                    readerStartingTimestamp = ((Number)readerStartingTimestampObj).longValue();
                    long readerTransmitTime = devicekitStartingTimestamp - readerStartingTimestamp;
                    tagReportMap.put("readerstartingtimestamp", readerStartingTimestampObj);
                    tagReportMap.put("readertransmittime", RfidInventoryBenchmarkProfile.createLong((long)readerTransmitTime));
                    this.currentTotalReaderTransmitTime += (double)readerTransmitTime;
                    this.currentLongestReaderTransmitTime = readerTransmitTime > this.currentLongestReaderTransmitTime ? readerTransmitTime : this.currentLongestReaderTransmitTime;
                    this.currentShortestReaderTransmitTime = readerTransmitTime < this.currentShortestReaderTransmitTime ? readerTransmitTime : this.currentShortestReaderTransmitTime;
                } else {
                    tagReportMap.put("readerstartingtimestamp", NA);
                    tagReportMap.put("readertransmittime", NA);
                    this.currentTotalReaderTransmitTime = -1.0;
                }
            }
            long tagProcessTime = currentTimestamp - (readerStartingTimestamp != 0L ? readerStartingTimestamp : devicekitStartingTimestamp);
            tagReportMap.put("totalprocesstime", RfidInventoryBenchmarkProfile.createLong((long)tagProcessTime));
            if (this.currentTagReads == 0L) {
                this.currentStartDelay = devicekitStartingTimestamp - this.currentTagReadStartTimestamp;
            }
            ++this.currentTagReads;
            this.currentTotalProcessTime += (double)tagProcessTime;
            this.currentLongest = tagProcessTime > this.currentLongest ? tagProcessTime : this.currentLongest;
            this.currentShortest = tagProcessTime < this.currentShortest ? tagProcessTime : this.currentShortest;
            this.addToCurrentTagList(tagReportMap);
        }
    }

    private void handleSetBenchmarking(Measurement measurement, Object data) {
        this.benchmarking.setValue((Object)this.getBooleanValue(data), RfidInventoryBenchmarkProfile.getCurrentTimestamp());
    }

    public boolean isBenchmarking() {
        if (this.benchmarking.getValue() == null) {
            return false;
        }
        return (Boolean)this.benchmarking.getValue();
    }

    protected void resetCurrentBenchmark(long timestamp) {
        this.currentTagReadStartTimestamp = timestamp;
        this.currentTotalProcessTime = 0.0;
        this.currentTagReads = 0L;
        this.currentLongest = 0L;
        this.currentShortest = 10000000L;
        this.currentTotalDeviceProcessTime = 0.0;
        this.currentLongestDeviceProcessTime = 0L;
        this.currentShortestDeviceProcessTime = 10000000L;
        this.currentTotalNotificationTime = 0.0;
        this.currentLongestNotificationTime = 0L;
        this.currentShortestNotificationTime = 10000000L;
        this.currentTotalReaderTransmitTime = 0.0;
        this.currentLongestReaderTransmitTime = 0L;
        this.currentShortestReaderTransmitTime = 10000000L;
        this.currentStartDelay = 0L;
        this.currentTagReportCounts.clear();
        this.currentTagList = new ArrayList();
    }

    private void setTagReadState(boolean state) {
        this.tagReadState = state;
    }

    protected void tagReadStarted(long timestamp) {
        if (this.isBenchmarking()) {
            this.resetCurrentBenchmark(timestamp);
        }
    }

    protected void tagReadStopped(long timestamp) {
        HashMap<String, Object> report = new HashMap<String, Object>();
        if (this.isBenchmarking()) {
            report.put("serialnum", RfidInventoryBenchmarkProfile.createLong((long)this.getNewTagReadSerialNum()));
            report.put("tagreports", RfidInventoryBenchmarkProfile.createLong((long)this.currentTagReads));
            report.put("average", this.currentTagReads > 0L ? RfidInventoryBenchmarkProfile.createLong((long)((long)this.currentTotalProcessTime / this.currentTagReads)) : RfidInventoryBenchmarkProfile.createLong((long)0L));
            long currentDuration = timestamp - this.currentTagReadStartTimestamp;
            report.put("tagreports", RfidInventoryBenchmarkProfile.createLong((long)this.currentTagReads));
            report.put("duration", RfidInventoryBenchmarkProfile.createLong((long)currentDuration));
            report.put("longest", RfidInventoryBenchmarkProfile.createLong((long)this.currentLongest));
            report.put("shortest", RfidInventoryBenchmarkProfile.createLong((long)this.currentShortest));
            report.put("startdelay", RfidInventoryBenchmarkProfile.createLong((long)this.currentStartDelay));
            report.put("uniquetags", RfidInventoryBenchmarkProfile.createLong((long)this.currentTagReportCounts.size()));
            report.put("tags", this.currentTagList);
            if (this.currentTotalDeviceProcessTime != -1.0) {
                report.put("averagedevicekitprocesstime", this.currentTagReads > 0L ? RfidInventoryBenchmarkProfile.createLong((long)((long)this.currentTotalDeviceProcessTime / this.currentTagReads)) : RfidInventoryBenchmarkProfile.createLong((long)0L));
                report.put("longestdevicekitprocesstime", RfidInventoryBenchmarkProfile.createLong((long)this.currentLongestDeviceProcessTime));
                report.put("shortestdevicekitprocesstime", RfidInventoryBenchmarkProfile.createLong((long)this.currentShortestDeviceProcessTime));
            } else {
                report.put("averagedevicekitprocesstime", NA);
                report.put("longestdevicekitprocesstime", NA);
                report.put("shortestdevicekitprocesstime", NA);
            }
            if (this.currentTotalNotificationTime != -1.0) {
                report.put("averagenotificationtime", this.currentTagReads > 0L ? RfidInventoryBenchmarkProfile.createLong((long)((long)this.currentTotalNotificationTime / this.currentTagReads)) : RfidInventoryBenchmarkProfile.createLong((long)0L));
                report.put("longestnotificationtime", RfidInventoryBenchmarkProfile.createLong((long)this.currentLongestNotificationTime));
                report.put("shortestnotificationtime", RfidInventoryBenchmarkProfile.createLong((long)this.currentShortestNotificationTime));
            } else {
                report.put("averagenotificationtime", NA);
                report.put("longestnotificationtime", NA);
                report.put("shortestnotificationtime", NA);
            }
            if (this.currentTotalReaderTransmitTime != -1.0) {
                report.put("averagereadertransmittime", this.currentTagReads > 0L ? RfidInventoryBenchmarkProfile.createLong((long)((long)this.currentTotalReaderTransmitTime / this.currentTagReads)) : RfidInventoryBenchmarkProfile.createLong((long)0L));
                report.put("longestreadertransmittime", RfidInventoryBenchmarkProfile.createLong((long)this.currentLongestReaderTransmitTime));
                report.put("shortestreadertransmittime", RfidInventoryBenchmarkProfile.createLong((long)this.currentShortestReaderTransmitTime));
            } else {
                report.put("averagereadertransmittime", NA);
                report.put("longestreadertransmittime", NA);
                report.put("shortestreadertransmittime", NA);
            }
            if (this.isLogging(4)) {
                this.log(4, "Benchmark report: " + report);
            }
            this.benchmarkReport.trigger(report, RfidInventoryBenchmarkProfile.getCurrentTimestamp());
        }
    }
}

