/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.platform.validation.test.checker;

import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.platform.validation.test.agent.PlatformValidationTestAgent;
import org.eclipse.soda.dk.platform.validation.test.checker.MemberInfo;

public class MethodInfo
extends MemberInfo {
    public static final String CONSTRUCTOR_NAME = "<init>";
    private static final long serialVersionUID = 90382379914802971L;
    private String[] parameterTypeDescriptors;
    private String[] exceptionNames;

    public MethodInfo(String name, int accessFlags, String returnTypeDescriptor, String[] parameterTypeDescriptors, String[] exceptionNames) {
        super(name, accessFlags, returnTypeDescriptor);
        this.parameterTypeDescriptors = parameterTypeDescriptors;
        this.exceptionNames = exceptionNames;
    }

    public String[] getExceptionNames() {
        return this.exceptionNames;
    }

    public String[] getParameterTypeDescriptors() {
        return this.parameterTypeDescriptors;
    }

    public Class[] getParameterTypes() throws ClassNotFoundException {
        Class[] parameterTypes = new Class[this.parameterTypeDescriptors.length];
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = MethodInfo.getType(this.parameterTypeDescriptors[i]);
            ++i;
        }
        return parameterTypes;
    }

    public boolean isConstructor() {
        return CONSTRUCTOR_NAME.equals(this.getName());
    }

    public String toString() {
        String[] parameterNames = this.getParameterTypeDescriptors();
        StringBuffer arguments = new StringBuffer();
        int i = 0;
        while (i < parameterNames.length) {
            arguments.append(parameterNames[i++]);
            if (i >= parameterNames.length) continue;
            arguments.append(',');
        }
        if (this.isConstructor()) {
            return Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7418)), (Object)arguments);
        }
        Object[] parms = new Object[]{this.getTypeDescriptor(), this.getName(), arguments};
        return Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7419)), (Object[])parms);
    }
}

