/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.platform.validation.test.checker;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.platform.validation.test.agent.PlatformValidationTestAgent;
import org.eclipse.soda.dk.platform.validation.test.checker.ClassInfo;
import org.eclipse.soda.dk.platform.validation.test.checker.FieldInfo;
import org.eclipse.soda.dk.platform.validation.test.checker.LogService;
import org.eclipse.soda.dk.platform.validation.test.checker.MemberInfo;
import org.eclipse.soda.dk.platform.validation.test.checker.MethodInfo;

public class ClassLibValidator {
    private LogService log;
    private Map classInfos = new HashMap();

    public ClassLibValidator(LogService log) {
        this.log = log;
    }

    private boolean checkClass(ClassInfo classInfo) {
        boolean pass = true;
        String className = classInfo.getName();
        try {
            Object[] parms;
            Class<?> cls = Class.forName(className);
            int modifiersMask = 1537;
            if (!classInfo.isInterface() && classInfo.getSuperClass() != cls.getSuperclass()) {
                parms = new Object[]{classInfo, classInfo.getSuperClassName(), cls.getSuperclass().getName()};
                this.log.log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7420)), (Object[])parms));
                pass = false;
            }
            if (!this.toSet(cls.getInterfaces()).containsAll(this.toSet(classInfo.getInterfaces()))) {
                parms = new Object[]{classInfo, this.toSet(classInfo.getInterfaces()), this.toSet(cls.getInterfaces())};
                this.log.log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7421)), (Object[])parms));
                pass = false;
            }
            if (!this.checkModifiers(classInfo.getModifiers(), cls.getModifiers(), modifiersMask)) {
                this.log.log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7422)), (Object)classInfo));
                pass = false;
            }
            if (!this.checkFields(cls, classInfo.getFields())) {
                pass = false;
            }
            if (!this.checkMethods(cls, classInfo.getMethods())) {
                pass = false;
            }
        }
        catch (NoClassDefFoundError e) {
            this.log.log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7404)), (Object)className), e);
            pass = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7404)), (Object)className));
            pass = false;
        }
        return pass;
    }

    public int checkClasses() {
        int count = 0;
        Iterator iter = this.classInfos.values().iterator();
        while (iter.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iter.next();
            if (!this.isResolvable(classInfo) || !this.checkClass(classInfo)) continue;
            ++count;
        }
        return count;
    }

    private boolean checkFields(Class cls, FieldInfo[] fields) {
        boolean pass = true;
        int i = 0;
        while (i < fields.length) {
            FieldInfo fieldInfo = fields[i];
            try {
                Field field;
                try {
                    field = cls.getDeclaredField(fieldInfo.getName());
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    field = cls.getField(fieldInfo.getName());
                }
                if (!fieldInfo.getType().equals(field.getType())) {
                    Object[] parms = new Object[]{field.getType(), fieldInfo, cls};
                    this.log.log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7423)), (Object[])parms));
                    pass = false;
                }
                int modifiersMask = 15;
                if (!this.checkModifiers(fieldInfo.getModifiers(), field.getModifiers(), modifiersMask)) {
                    Object[] parms = new Object[]{new Integer(field.getModifiers()), new Integer(fieldInfo.getModifiers()), fieldInfo, cls};
                    this.log.log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7422)), (Object[])parms));
                    pass = false;
                }
            }
            catch (SecurityException e) {
                Object[] parms = new Object[]{fieldInfo, cls};
                this.log.log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7425)), (Object[])parms), e);
                pass = false;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Object[] parms = new Object[]{fieldInfo, cls};
                this.log.log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7426)), (Object[])parms));
                pass = false;
            }
            catch (Throwable e) {
                Object[] parms = new Object[]{fieldInfo, cls};
                this.log.log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7405)), (Object[])parms), e);
            }
            ++i;
        }
        return pass;
    }

    private boolean checkMethods(Class cls, MethodInfo[] methods) {
        boolean pass = true;
        int i = 0;
        while (i < methods.length) {
            Object[] parms;
            MethodInfo methodInfo = methods[i];
            try {
                Object[] parms2;
                Executable member;
                Class[] parameterTypes = methodInfo.getParameterTypes();
                if (methodInfo.isConstructor()) {
                    Constructor constructor;
                    try {
                        constructor = cls.getDeclaredConstructor(parameterTypes);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        constructor = cls.getConstructor(parameterTypes);
                    }
                    member = constructor;
                } else {
                    Method method;
                    try {
                        method = cls.getDeclaredMethod(methodInfo.getName(), parameterTypes);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        method = cls.getMethod(methodInfo.getName(), parameterTypes);
                    }
                    if (!methodInfo.getType().equals(method.getReturnType())) {
                        parms2 = new Object[]{method.getReturnType(), methodInfo, cls};
                        this.log.log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7427)), (Object[])parms2));
                        pass = false;
                    }
                    member = method;
                }
                int modifiersMask = 1039;
                if (!this.checkModifiers(methodInfo.getModifiers(), member.getModifiers(), modifiersMask)) {
                    parms2 = new Object[]{new Integer(member.getModifiers()), new Integer(methodInfo.getModifiers()), methodInfo, cls};
                    this.log.log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7424)), (Object[])parms2));
                    pass = false;
                }
            }
            catch (SecurityException e) {
                parms = new Object[]{methodInfo, cls};
                this.log.log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7425)), (Object[])parms), e);
                pass = false;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Object[] parms3 = new Object[]{methodInfo, cls};
                this.log.log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7426)), (Object[])parms3));
                pass = false;
            }
            catch (Throwable e) {
                parms = new Object[]{methodInfo, cls};
                this.log.log(1, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7405)), (Object[])parms), e);
            }
            ++i;
        }
        return pass;
    }

    private boolean checkModifiers(int expectedModifiers, int actualModifiers, int mask) {
        boolean compatible;
        boolean bl = compatible = (expectedModifiers & mask) == (actualModifiers & mask);
        if (!compatible && (actualModifiers & 1) != 0) {
            int relaxedMask = mask & 0xFFFFFFF8;
            compatible = (expectedModifiers & relaxedMask) == (actualModifiers & relaxedMask);
        }
        return compatible;
    }

    public int getClassCount() {
        return this.classInfos.size();
    }

    private boolean isResolvable(ClassInfo classInfo) {
        Object referencedElement = classInfo.getSuperClassName();
        boolean resolvable = this.isResolvable(classInfo.getSuperClassName());
        String[] interfaceNames = classInfo.getInterfaceNames();
        if (interfaceNames != null) {
            int i = 0;
            while (resolvable && i < interfaceNames.length) {
                referencedElement = interfaceNames[i];
                resolvable = this.isResolvable(interfaceNames[i]);
                ++i;
            }
        }
        FieldInfo[] fields = classInfo.getFields();
        int i = 0;
        while (resolvable && i < fields.length) {
            FieldInfo fieldInfo = fields[i];
            referencedElement = fieldInfo;
            resolvable = this.isResolvable(fieldInfo);
            ++i;
        }
        MethodInfo[] methods = classInfo.getMethods();
        int i2 = 0;
        while (resolvable && i2 < methods.length) {
            MethodInfo methodInfo = methods[i2];
            referencedElement = methodInfo;
            resolvable = this.isResolvable(methodInfo);
            ++i2;
        }
        if (!resolvable) {
            Object[] parms = new Object[]{classInfo, referencedElement};
            this.log.log(2, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7428)), (Object[])parms));
        }
        return resolvable;
    }

    private boolean isResolvable(FieldInfo fieldInfo) {
        return this.isResolvable(fieldInfo.getTypeDescriptor());
    }

    private boolean isResolvable(MethodInfo methodInfo) {
        boolean resolvable = this.isResolvable(methodInfo.getTypeDescriptor());
        String[] parameterTypeDescriptors = methodInfo.getParameterTypeDescriptors();
        int i = 0;
        while (resolvable && i < parameterTypeDescriptors.length) {
            resolvable = this.isResolvable(parameterTypeDescriptors[i]);
            ++i;
        }
        return resolvable;
    }

    private boolean isResolvable(String typeDescriptor) {
        try {
            MemberInfo.getType(typeDescriptor);
            return true;
        }
        catch (Throwable throwable) {
            return this.classInfos.get(typeDescriptor) != null;
        }
    }

    public void loadClassLib(InputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream objIn = new ObjectInputStream(in);
        int objCount = objIn.readInt();
        try {
            int i = 0;
            while (i < objCount) {
                ClassInfo classInfo = (ClassInfo)objIn.readObject();
                this.classInfos.put(classInfo.getName(), classInfo);
                ++i;
            }
        }
        catch (EOFException eOFException) {
            in.close();
        }
    }

    private Set toSet(Class[] interfaces) {
        HashSet<Class> set = new HashSet<Class>(interfaces.length);
        int i = 0;
        while (i < interfaces.length) {
            set.add(interfaces[i]);
            ++i;
        }
        return set;
    }
}

