/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.notification;

import java.util.Dictionary;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.notification.NotificationBase;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationMonitorService;

public class NotificationMonitor
extends EscObject
implements NotificationMonitorService {
    protected NotificationBase notificationBase;
    private long notifyThresholdCount;
    private long broadcastThresholdCount;

    public NotificationMonitor(NotificationBase notificationBase) {
        this.setNotificationBase(notificationBase);
    }

    private long getBroadcastThreshold() {
        return this.getNotificationBase().getBroadcastThreshold();
    }

    public NotificationBase getNotificationBase() {
        return this.notificationBase;
    }

    public long getNotifyThreshold() {
        return this.getNotificationBase().getNotifyThreshold();
    }

    public int notified(NotificationListener notificationListener, String topic, Dictionary data, long time) {
        long notifyThreshold = this.getNotifyThreshold();
        if (notifyThreshold >= 0L && time >= notifyThreshold) {
            ++this.notifyThresholdCount;
            this.getNotificationBase().report(null, 103, topic, data, NotificationMonitor.createLong((long)time), notificationListener);
        }
        return 0;
    }

    public int sent(String topic, Dictionary data, long time) {
        long broadcastThreshold = this.getBroadcastThreshold();
        if (broadcastThreshold >= 0L && time >= broadcastThreshold) {
            ++this.broadcastThresholdCount;
            this.getNotificationBase().report(null, 102, topic, data, NotificationMonitor.createLong((long)time));
        }
        return 0;
    }

    public void setNotificationBase(NotificationBase notificationBase) {
        this.notificationBase = notificationBase;
    }
}

