/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.generic.io.simulator.device.window;

import org.eclipse.swt.widgets.Display;

public class SwtDisplay {
    private Display display;
    private boolean running;
    private Thread thread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        SwtDisplay swtDisplay = this;
        synchronized (swtDisplay) {
            if (this.running) {
                return;
            }
            this.running = true;
        }
        this.startDisplayThread();
        this.getDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        SwtDisplay swtDisplay = this;
        synchronized (swtDisplay) {
            if (!this.running) {
                return;
            }
            this.running = false;
        }
        this.shutDownSwtDisplayThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Display getDisplay() {
        try {
            SwtDisplay swtDisplay = this;
            synchronized (swtDisplay) {
                while (this.display == null) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCreateShell() {
        SwtDisplay swtDisplay = this;
        synchronized (swtDisplay) {
            this.display = Display.getDefault();
            this.notifyAll();
        }
        if (this.display.getThread() == Thread.currentThread()) {
            while (this.running) {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
            this.display.dispose();
        }
    }

    private void shutDownSwtDisplayThread() {
        this.display.wake();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {}
        this.thread = null;
        this.display = null;
    }

    private void startDisplayThread() {
        Runnable runnable = new Runnable(){

            public void run() {
                SwtDisplay.this.processCreateShell();
            }
        };
        this.thread = new Thread(runnable, "SWT Display");
        this.thread.start();
    }
}

