/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.generic.io.simulator.device;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.generic.io.device.GenericIoDevice;
import org.eclipse.soda.dk.generic.io.simulator.device.service.GenericIoSimulatorDeviceService;
import org.eclipse.soda.dk.generic.io.simulator.device.window.GenericIoSimulatorWindow;
import org.eclipse.soda.dk.generic.io.simulator.device.window.GenericIoSimulatorWindowListener;
import org.eclipse.soda.dk.generic.io.simulator.device.window.SwtDisplay;
import org.eclipse.soda.dk.transport.service.TransportService;

public class GenericIoSimulatorDevice
extends GenericIoDevice
implements DeviceService,
GenericIoSimulatorDeviceService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.generic.io.simulator.device.GenericIoSimulatorDevice";
    private SwtDisplay swtDisplay;
    private GenericIoSimulatorWindow simulatorWindow;
    private long digitalInputState;
    private Map analogInputValue;
    Map analogInputOffMap;

    public GenericIoSimulatorDevice() {
        super("Device/Capabilities", "Device/Status", "Device/Configuration", "Device/Metrics");
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public String getDefaultKey() {
        return "GenericIoSimulatorDevice";
    }

    public TransportService getDefaultTransport() {
        return null;
    }

    private void initialize() {
    }

    public void setup() {
        super.setup();
        this.setNotificationPriority(this.getInt("genericiosimulatordevice.notificationpriority", this.getNotificationPriority()));
    }

    public void activate() {
        super.activate();
        GenericIoSimulatorWindowListener listener = new GenericIoSimulatorWindowListener(){

            public String getDeviceName() {
                return GenericIoSimulatorDevice.this.getId();
            }

            public int getNumberOfDigitalInputPins() {
                return GenericIoSimulatorDevice.this.getNumberOfDigitalInputs();
            }

            public int getNumberOfDigitalOutputPins() {
                return GenericIoSimulatorDevice.this.getNumberOfDigitalOutputs();
            }

            public void notifyDigitalInputChanged(int pin, boolean state) {
                if (state) {
                    GenericIoSimulatorDevice.this.setDigitalInputState(GenericIoSimulatorDevice.this.getDigitalInputState() | (long)(1 << pin));
                } else {
                    GenericIoSimulatorDevice.this.setDigitalInputState(GenericIoSimulatorDevice.this.getDigitalInputState() & (long)(~(1 << pin)));
                }
            }

            public int getNumberOfAnalogInputChannels() {
                return GenericIoSimulatorDevice.this.getNumberOfAnalogInputs();
            }

            public int getNumberOfAnalogOutputChannels() {
                return GenericIoSimulatorDevice.this.getNumberOfAnalogOutputs();
            }

            public void notifyAnalogInputChanged(int pin, long value) {
                Hashtable<String, Long> map = new Hashtable<String, Long>(GenericIoSimulatorDevice.this.getAnalogInputValue().isEmpty() ? GenericIoSimulatorDevice.this.analogInputOffMap : GenericIoSimulatorDevice.this.getAnalogInputValue());
                map.put("ai" + (pin + 1), new Long(value));
                GenericIoSimulatorDevice.this.setAnalogInputValue(map);
            }
        };
        this.swtDisplay = new SwtDisplay();
        this.swtDisplay.activate();
        this.simulatorWindow = new GenericIoSimulatorWindow(listener);
        this.simulatorWindow.bind(this.swtDisplay.getDisplay());
        this.simulatorWindow.open();
    }

    public void deactivate() {
        this.simulatorWindow.close();
        this.swtDisplay.deactivate();
        super.deactivate();
    }

    protected Map getAnalogInputValue() {
        return this.analogInputValue;
    }

    protected long getDigitalInputState() {
        return this.digitalInputState;
    }

    protected void setAnalogInputValue(Map inputValue) {
        this.analogInputValue = inputValue;
    }

    protected void setAnalogOutputValue(Map outputValue) {
        int len = this.getNumberOfAnalogOutputs();
        int channel = 0;
        while (channel < len) {
            Long value = (Long)outputValue.get("ao" + (channel + 1));
            this.simulatorWindow.analogOutputUpdate(channel, value);
            ++channel;
        }
    }

    protected void setDigitalInputState(long inputState) {
        this.digitalInputState = inputState;
    }

    protected void setDigitalOutputState(long l) {
        int len = this.getNumberOfDigitalOutputs();
        int mask = 1;
        int pin = 0;
        while (pin < len) {
            this.simulatorWindow.digitalOutputUpdate(pin, (l & (long)mask) != 0L);
            mask <<= 1;
            ++pin;
        }
    }

    public void setupCustom() {
        super.setupCustom();
        int len = this.getNumberOfAnalogInputs();
        this.setAnalogInputValue(new Hashtable(len * 2 + 1));
        Hashtable<String, Long> map = new Hashtable<String, Long>(len * 2 + 1);
        Long offValue = new Long(0L);
        int pin = 0;
        while (pin < len) {
            map.put("ai" + (pin + 1), offValue);
            ++pin;
        }
        this.analogInputOffMap = map;
    }
}

