/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.write.profile.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.device.servlet.DeviceServlet;
import org.eclipse.soda.dk.device.servlet.bundle.DeviceServletBundle;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPUtils;
import org.eclipse.soda.dk.epcglobal.llrp.write.profile.servlet.WriteProfileServlet;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.rfid.write.profile.RfidWriteProfile;

public class WriteProfileConsole
extends DeviceServletBundle
implements NotificationListener {
    private final String writeOperationRequestTopic = "/RfidWrite/WriteOperationsExecuteRequest/execute";
    private final String writeOperationStopTopic = "/RfidWrite/WriteOperationsStopRequest/execute";
    private final String tagWriteMaskSettingTopic = "/RfidWrite/TagWriteMaskSetting/write";
    private final String writeOperationsTopic = "/RfidWrite/WriteOperations/write";
    private final String tagWriteReportTopic = "/RfidWrite/TagWriteReport";
    private final String tagWriteAggregationTopic = "/RfidWrite/TagWriteAggregationReport";
    private final String tagWriteMaskSetting = "/RfidWrite/TagWriteMaskSetting/write";
    private final String tagAggregationWriteMaskSetting = "/RfidWrite/TagAggregationWriteMaskSetting/write";
    private final String tagWriteAggregating = "/RfidWrite/TagWriteAggregating/write";
    private final List reports = new ArrayList();
    private long startingTimestamp = 0L;
    private long latestReportDuration = 0L;
    static /* synthetic */ Class class$0;

    public DeviceServlet createServlet() {
        WriteProfileServlet writeProfileServlet = new WriteProfileServlet();
        writeProfileServlet.bind(this);
        return writeProfileServlet;
    }

    protected String[] getImportedServiceNames() {
        return new String[]{"org.osgi.service.http.HttpService", "org.eclipse.soda.dk.notification.service.NotificationService"};
    }

    public long getLatestReportDuration() {
        return this.latestReportDuration;
    }

    private NotificationService getNotificationService() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.notification.service.NotificationService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (NotificationService)this.getImportedService(clazz.getName());
    }

    protected InputStream getPropertiesInputStream() throws IOException {
        return this.getResourcePropertiesInputStream();
    }

    public List getReports() {
        return this.reports;
    }

    public void notificationReceived(String externalKey, Dictionary data) {
        Map tags;
        Map tagWriteReport = (Map)data.get("value");
        if (tagWriteReport != null && (tags = (Map)tagWriteReport.get("tags")) != null) {
            this.latestReportDuration = System.currentTimeMillis() - this.startingTimestamp;
            this.reports.add(tags);
        }
    }

    protected void sendIncrementWriteRequest(String prefix, String writeOperationsParameter) {
        String[] op_params = RfidWriteProfile.parseDelimitedByToken((String)writeOperationsParameter, (String)String.valueOf(';'));
        String memoryBank = op_params[1];
        String wordPointer = op_params[2];
        String writeData = op_params[3];
        int increment = Integer.valueOf(op_params[4]);
        String password = op_params[5];
        int repeat = Integer.valueOf(op_params[6]);
        String timeout = op_params[7];
        int i = 0;
        while (i < repeat) {
            String newWriteData = LLRPUtils.hexStrIncrement((String)writeData, (int)(increment * i));
            StringBuffer opString = new StringBuffer("Filter;1;true;0;0;0:");
            opString.append("Write;");
            opString.append(String.valueOf(memoryBank) + ';');
            opString.append(String.valueOf(wordPointer) + ';');
            opString.append(String.valueOf(newWriteData) + ';');
            opString.append(String.valueOf(password) + ';');
            opString.append("1;");
            opString.append(String.valueOf(timeout) + ':');
            this.sendWriteOperationsRequest(prefix, opString.toString());
            ++i;
        }
    }

    protected void sendRequest(String topic, Object request) {
        Hashtable<String, Object> value = new Hashtable<String, Object>();
        value.put("value", request);
        this.getNotificationService().broadcast(topic, value);
    }

    public void sendTagAggregating(String prefix, Boolean request) {
        this.sendRequest(String.valueOf(prefix) + "/RfidWrite/TagWriteAggregating/write", request);
    }

    public void sendTagAggregationMaskSetting(String prefix, String mask) {
        this.sendRequest(String.valueOf(prefix) + "/RfidWrite/TagAggregationWriteMaskSetting/write", mask);
    }

    public void sendTagWriteMaskSetting(String prefix, String mask) {
        this.sendRequest(String.valueOf(prefix) + "/RfidWrite/TagWriteMaskSetting/write", mask);
    }

    public void sendTagWriteMaskSettingRequest(String prefix, Map tagWriteMaskSettingParameter) {
        this.sendRequest(String.valueOf(prefix) + "/RfidWrite/TagWriteMaskSetting/write", tagWriteMaskSettingParameter);
    }

    public void sendWriteOperationsExecuteRequest(String prefix, String request) {
        this.sendRequest(String.valueOf(prefix) + "/RfidWrite/WriteOperationsExecuteRequest/execute", request);
        this.reports.clear();
    }

    public void sendWriteOperationsRequest(String prefix, String writeOperationsParameter) {
        this.sendRequest(String.valueOf(prefix) + "/RfidWrite/WriteOperations/write", writeOperationsParameter);
    }

    public void sendWriteOperationsRequest(String prefix, String writeOperationsParameter, int repeat) {
        this.reports.clear();
        this.getNotificationService().register(String.valueOf(prefix) + "/RfidWrite/TagWriteReport", (NotificationListener)this);
        this.getNotificationService().register(String.valueOf(prefix) + "/RfidWrite/TagWriteAggregationReport", (NotificationListener)this);
        this.startingTimestamp = System.currentTimeMillis();
        this.latestReportDuration = 0L;
        int i = 0;
        while (i < repeat) {
            if (!writeOperationsParameter.startsWith("Increment Write")) {
                this.sendWriteOperationsRequest(prefix, writeOperationsParameter);
            } else {
                this.sendIncrementWriteRequest(prefix, writeOperationsParameter);
            }
            ++i;
        }
    }

    public void sendWriteOperationsStopRequest(String prefix, String request) {
        this.sendRequest(String.valueOf(prefix) + "/RfidWrite/WriteOperationsStopRequest/execute", request);
    }
}

