/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.AbstractTask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskListener;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskManager;
import org.eclipse.soda.dk.signal.service.SignalService;

public class TaskManager
extends AbstractTask
implements ITaskListener,
ITaskManager {
    private LinkedList taskList;
    private Byte taskListLock = new Byte(0);
    private String name;

    public TaskManager(String name) {
        this(name, 1);
    }

    public TaskManager(String name, int state) {
        this.taskList = new LinkedList();
        this.setState(state);
        this.name = name;
    }

    public void abort() {
    }

    public void addTask(ITask task) {
        this.addTaskToBottom(task, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTaskToBottom(ITask task, boolean checkDup) {
        if (this.isLogging(4)) {
            this.log(4, "Add task: " + task.getTaskName() + " in " + this.getTaskName() + ", current state: " + this.getStrState());
        }
        Byte by = this.taskListLock;
        synchronized (by) {
            ITask bottomTask;
            if (checkDup && !this.taskList.isEmpty() && (bottomTask = (ITask)this.taskList.getLast()).duplicateTask(task)) {
                if (this.isLogging(4)) {
                    this.log(4, " Detect duplicate task at bottom in " + this.getTaskName());
                }
                return;
            }
            this.taskList.addLast(task);
        }
        if (this.isLogging(4) && this.getState() == 2) {
            this.log(4, String.valueOf(this.getTaskName()) + ", current top task: " + this.getTopTask());
        }
        if (this.getState() == 1) {
            this.launchTopTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTaskToTop(ITask task, boolean checkDup) {
        Byte by = this.taskListLock;
        synchronized (by) {
            if (checkDup && !this.taskList.isEmpty()) {
                ITask topTask = (ITask)this.taskList.getFirst();
                if (topTask.duplicateTask(task)) {
                    if (this.isLogging(4)) {
                        this.log(4, "Detect duplicate task on top in " + this.getTaskName());
                    }
                    return;
                }
                this.taskList.addFirst(task);
            }
        }
        if (this.getState() == 1) {
            this.launchTopTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearTasksByOwner(Object taskOwner) {
        if (this.isLogging(4)) {
            this.log(4, String.valueOf(this.getTaskName()) + ", clear tasks by owner: " + taskOwner);
        }
        Byte by = this.taskListLock;
        synchronized (by) {
            ITask topTask;
            ArrayList<ITask> clearList = new ArrayList<ITask>();
            if (this.isLogging(4)) {
                this.log(4, String.valueOf(this.getTaskName()) + ",current tasks: " + this.taskList.size());
            }
            int i = 0;
            while (i < this.taskList.size()) {
                ITask task = (ITask)this.taskList.get(i);
                if (this.isLogging(4)) {
                    this.log(4, String.valueOf(this.getTaskName()) + ", Task " + i + ": " + task + ", owner: " + task.getTaskOwner());
                }
                if (taskOwner.equals(task.getTaskOwner())) {
                    clearList.add(task);
                }
                ++i;
            }
            if (this.isLogging(4)) {
                this.log(4, String.valueOf(this.getTaskName()) + ",Tasks to remove: " + clearList.size());
            }
            ITask iTask = topTask = !this.taskList.isEmpty() ? (ITask)this.taskList.getFirst() : null;
            if (topTask != null && clearList.contains(topTask)) {
                this.setState(1);
            }
            int i2 = 0;
            while (i2 < clearList.size()) {
                this.taskList.remove(clearList.get(i2));
                ++i2;
            }
            if (this.taskList.size() == 0) {
                this.setState(1);
            }
        }
        if (this.getState() == 1) {
            this.launchTopTask();
        }
    }

    public boolean duplicateTask(ITask task) {
        return task.getTaskName().equals(this.name);
    }

    public String getStrState() {
        String stateStr = null;
        switch (this.getState()) {
            case 0: {
                stateStr = "STOPPED";
                break;
            }
            case 1: {
                stateStr = "STANDBY";
                break;
            }
            case 2: {
                stateStr = "TOPTASKRUNNING";
            }
        }
        return stateStr;
    }

    public String getTaskName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITask getTopTask() {
        Byte by = this.taskListLock;
        synchronized (by) {
            if (!this.taskList.isEmpty()) {
                return (ITask)this.taskList.getFirst();
            }
            return null;
        }
    }

    public synchronized void handleResponse(SignalService source, Object timestamp, Object data) {
        ITask topTask;
        if (this.isLogging(4)) {
            this.log(4, String.valueOf(this.getTaskName()) + " received response: " + source + ", current state: " + this.getStrState());
        }
        if (this.getState() == 2 && (topTask = this.getTopTask()) != null) {
            topTask.handleResponse(source, timestamp, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isResponseExpected(SignalService source, Object timestamp, Object data) {
        if (this.getState() == 2) {
            Byte by = this.taskListLock;
            synchronized (by) {
                ITask task = this.getTopTask();
                if (task != null) {
                    return task.isResponseExpected(source, timestamp, data);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskListEmpty() {
        Byte by = this.taskListLock;
        synchronized (by) {
            return this.taskList.isEmpty();
        }
    }

    public boolean launchTask() {
        this.setState(1);
        return true;
    }

    protected boolean launchTopTask() {
        ITask task = this.getTopTask();
        if (task != null) {
            if (task.launchTask()) {
                task.addTaskListener(this);
                if (this.isLogging(4)) {
                    this.log(4, "Started task: " + task.getTaskName() + " in " + this.getTaskName());
                }
                this.setState(2);
                return true;
            }
            if (this.isLogging(4)) {
                this.log(4, "Fail to start task: " + task.getTaskName() + " in " + this.getTaskName());
            }
        }
        this.setState(1);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeTask(ITask task) {
        Byte by = this.taskListLock;
        synchronized (by) {
            if (!this.taskList.contains(task)) {
                return;
            }
            if (this.isLogging(4)) {
                this.log(4, "Remove task: " + task.getTaskName() + " in " + this.getTaskName());
            }
            ITask topTask = !this.taskList.isEmpty() ? (ITask)this.taskList.getFirst() : null;
            this.taskList.remove(task);
            if (task == topTask) {
                this.setState(1);
                this.launchTopTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ITask task;
        if (this.isLogging(4)) {
            this.log(4, "Reset " + this.getTaskName());
        }
        if (this.getState() == 2 && (task = this.getTopTask()) != null) {
            task.removeTaskListener(this);
        }
        Byte by = this.taskListLock;
        synchronized (by) {
            this.taskList.clear();
        }
        this.setState(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void taskNotice(String taskName, int status, Object result) {
        if (status == 3) {
            this.notifyListener(taskName, status, result);
            return;
        }
        ITask topTask = this.getTopTask();
        if (topTask != null && topTask.getTaskName().equals(taskName)) {
            switch (status) {
                case 1: {
                    if (this.isLogging(4)) {
                        this.log(4, "Finished task: " + topTask.getTaskName() + " in " + this.getTaskName());
                    }
                    this.notifyListener(taskName, status, result);
                    break;
                }
                case 2: {
                    if (this.isLogging(4)) {
                        this.log(4, "Task timeout: " + topTask.getTaskName() + " in " + this.getTaskName());
                    }
                    this.notifyListener(taskName, status, result);
                    break;
                }
                case 0: {
                    if (this.isLogging(4)) {
                        this.log(4, "Task error: " + topTask.getTaskName() + " in " + this.getTaskName());
                    }
                    this.notifyListener(taskName, status, result);
                    break;
                }
                case 4: {
                    if (this.isLogging(4)) {
                        this.log(4, "Task aborts: " + topTask.getTaskName() + " in " + this.getTaskName());
                    }
                    this.notifyListener(taskName, status, result);
                }
            }
            Byte by = this.taskListLock;
            synchronized (by) {
                this.taskList.remove(topTask);
            }
            this.launchTopTask();
        }
    }
}

