/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper.task;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPUtils;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_ADD_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_DELETE_EXIST_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_ENABLE_ACCESSSPEC;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.AbstractTask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public abstract class AbstractTask_ACCESS_TAG
extends AbstractTask
implements ITaskListener {
    public static final String TAGREPORTDATA_KEY = "TagReportData_Key";
    public static final String RESULTCODE_KEY = "ResultCode_Key";
    public static final String TIMESTAMP_KEY = "Timestamp_Key";
    public static final String OPERATIONID_KEY = "OperationId_Key";
    public static final String SUCCESSCOUNT_KEY = "SuccessCount_Key";
    private static final int STANDBY = 0;
    private static final int DELETE_EXIST_ACCESSSPEC_STARTED = 1;
    private static final int ADD_ACCESSSPEC_STARTED = 2;
    private static final int ENABLE_ACCESSSPEC_STARTED = 3;
    private static final int ENABLE_ACCESSSPEC_SUCCESS = 4;
    private static final int ACCESS_TAG_FINISHED = 5;
    private static final int ACCESS_TAG_TIMEOUT = 6;
    private static final int ACCESS_TAG_FAIL = 7;
    private Task_DELETE_EXIST_ACCESSSPEC task_delete_exist_accessspec;
    private Task_ADD_ACCESSSPEC task_add_accessspec;
    private Task_ENABLE_ACCESSSPEC task_enable_accessspec;
    private Set tags;
    private SignalService rOAccessReport;
    private int accessSpecId;
    private int accessOpId;
    private int operationCount = 1;
    private boolean unlimitedOperation = false;
    private int accessCount = 0;
    private int successCount = 0;
    private int failureCount = 0;
    private long timeoutValue;
    private String operationId;

    protected AbstractTask_ACCESS_TAG(int accessOpId, int operationCount, Task_DELETE_EXIST_ACCESSSPEC task_delete_exist_accessspec, Task_ADD_ACCESSSPEC task_add_accessspec, Task_ENABLE_ACCESSSPEC task_enable_accessspec, SignalService rOAccessReport) {
        this(accessOpId, operationCount, task_delete_exist_accessspec, task_add_accessspec, task_enable_accessspec, rOAccessReport, 0L, String.valueOf(accessOpId));
    }

    protected AbstractTask_ACCESS_TAG(int accessOpId, Task_DELETE_EXIST_ACCESSSPEC task_delete_exist_accessspec, Task_ADD_ACCESSSPEC task_add_accessspec, Task_ENABLE_ACCESSSPEC task_enable_accessspec, SignalService rOAccessReport, long timeoutValue, String operationId) {
        this(accessOpId, 0, task_delete_exist_accessspec, task_add_accessspec, task_enable_accessspec, rOAccessReport, timeoutValue, operationId);
    }

    protected AbstractTask_ACCESS_TAG(int accessOpId, int operationCount, Task_DELETE_EXIST_ACCESSSPEC task_delete_exist_accessspec, Task_ADD_ACCESSSPEC task_add_accessspec, Task_ENABLE_ACCESSSPEC task_enable_accessspec, SignalService rOAccessReport, long timeoutValue, String operationId) {
        this.accessOpId = accessOpId;
        this.task_delete_exist_accessspec = task_delete_exist_accessspec;
        this.task_add_accessspec = task_add_accessspec;
        this.task_enable_accessspec = task_enable_accessspec;
        this.rOAccessReport = rOAccessReport;
        this.operationCount = operationCount;
        this.timeoutValue = timeoutValue;
        if (this.task_add_accessspec != null) {
            Map accessSpecStopTriggerParameter;
            Map accessSpecParameters;
            this.accessSpecId = this.task_add_accessspec.getAccessSpecId();
            Map addAccessSpecParameters = this.task_add_accessspec.getParameters();
            if (addAccessSpecParameters != null && (accessSpecParameters = (Map)addAccessSpecParameters.get("AccessSpecParameter")) != null && (accessSpecStopTriggerParameter = (Map)accessSpecParameters.get("AccessSpecStopTriggerParameter")) != null) {
                int accessOpCount = ((Number)accessSpecStopTriggerParameter.get("OperationCountValue")).intValue();
                if (accessOpCount != 0) {
                    this.operationCount = accessOpCount;
                    this.unlimitedOperation = false;
                } else {
                    this.unlimitedOperation = true;
                }
            }
        }
        this.operationId = operationId;
        this.setState(0);
    }

    protected void addTagToCache(String tagId) {
        if (this.tags != null) {
            this.tags.add(tagId);
        }
    }

    protected int getAccessOpId() {
        return this.accessOpId;
    }

    protected int getAccessSpecId() {
        return this.accessSpecId;
    }

    private Map getFinishReport() {
        Hashtable<String, Integer> report = new Hashtable<String, Integer>();
        report.put(SUCCESSCOUNT_KEY, AbstractTask_ACCESS_TAG.createInteger((int)this.successCount));
        return report;
    }

    protected abstract String getOpSpecResultKey();

    protected abstract String getOpSpecResultParameterKey();

    protected abstract int getOpSpecSuccessResultCode();

    protected String getOperationId() {
        return this.operationId;
    }

    public synchronized void handleResponse(SignalService source, Object timestamp, Object data) {
        switch (this.getState()) {
            case 0: {
                return;
            }
            case 1: {
                this.task_delete_exist_accessspec.handleResponse(source, timestamp, data);
                return;
            }
            case 2: {
                this.task_add_accessspec.handleResponse(source, timestamp, data);
                return;
            }
            case 3: {
                this.task_enable_accessspec.handleResponse(source, timestamp, data);
                return;
            }
            case 4: {
                if (source == this.rOAccessReport) {
                    this.processTag((Map)data, timestamp);
                    if (this.isLogging(4)) {
                        this.log(4, String.valueOf(this.getTaskName()) + " access count: " + this.accessCount + ", operationCount: " + this.operationCount);
                    }
                    if (this.operationCount != 0 && this.accessCount >= this.operationCount) {
                        if (!this.unlimitedOperation) {
                            this.stopTimer();
                            this.taskFinished(1);
                        } else {
                            this.setState(5);
                            this.task_delete_exist_accessspec.addTaskListener(this);
                            this.task_delete_exist_accessspec.start();
                        }
                    }
                }
                return;
            }
            case 5: 
            case 6: {
                this.task_delete_exist_accessspec.handleResponse(source, timestamp, data);
                return;
            }
        }
    }

    protected void initialize() {
        this.accessCount = 0;
        this.successCount = 0;
        this.failureCount = 0;
        this.tags = new HashSet();
    }

    protected boolean isDuplicateTag(String tagId) {
        if (this.tags == null) {
            return false;
        }
        return this.tags.contains(tagId);
    }

    public boolean isResponseExpected(SignalService source, Object timestamp, Object data) {
        switch (this.getState()) {
            case 0: {
                return false;
            }
            case 1: {
                return this.isResponseExpectedByTask(this.task_delete_exist_accessspec, source, timestamp, data);
            }
            case 2: {
                return this.isResponseExpectedByTask(this.task_add_accessspec, source, timestamp, data);
            }
            case 3: {
                return this.isResponseExpectedByTask(this.task_enable_accessspec, source, timestamp, data);
            }
            case 4: {
                return source == this.rOAccessReport;
            }
            case 5: 
            case 6: {
                return this.isResponseExpectedByTask(this.task_delete_exist_accessspec, source, timestamp, data);
            }
        }
        return false;
    }

    private boolean isResponseExpectedByTask(ITask task, SignalService source, Object timestamp, Object data) {
        if (task.getTaskManager() != null && task.getTaskManager() != this.getTaskManager()) {
            return false;
        }
        return task.isResponseExpected(source, timestamp, data);
    }

    public synchronized boolean launchTask() {
        if (this.task_delete_exist_accessspec != null) {
            this.initialize();
            this.task_delete_exist_accessspec.addTaskListener(this);
            this.task_delete_exist_accessspec.start();
            if (this.isLogging(4)) {
                this.log(4, "Task started: " + this.task_delete_exist_accessspec.getTaskName() + " in " + this.getTaskName());
            }
            this.setState(1);
            return true;
        }
        return false;
    }

    protected void oneFailureOccurred() {
        ++this.accessCount;
        ++this.failureCount;
    }

    protected void oneSuccessOccurred() {
        ++this.accessCount;
        ++this.successCount;
    }

    protected void preNotifyListener(String taskName, int status, Object result) {
        if (result instanceof Map) {
            ((Map)result).put("AccessSpecID", AbstractTask_ACCESS_TAG.createInteger((int)this.getAccessSpecId()));
        }
    }

    protected void processTag(Map paramMap, Object timestamp) {
        List tagReportDataparameters = (List)paramMap.get("TagReportDataParameter");
        if (tagReportDataparameters != null) {
            if (this.isLogging(4)) {
                this.log(4, "Tags in the tag report: " + tagReportDataparameters.size());
            }
            int i = 0;
            while (i < tagReportDataparameters.size()) {
                Map tagReportData = (Map)tagReportDataparameters.get(i);
                String tag = LLRPUtils.extractTag((Map)tagReportData.get("EPCParameterChoice"));
                if (tag == null) {
                    return;
                }
                Map accessSpecIdParam = (Map)tagReportData.get("AccessSpecIDParameter");
                if (accessSpecIdParam == null) {
                    return;
                }
                Number accessSpecId_obj = (Number)accessSpecIdParam.get("AccessSpecID");
                if (this.isLogging(4)) {
                    this.log(4, "AccessSpec Id: " + accessSpecId_obj);
                }
                if (accessSpecId_obj != null && accessSpecId_obj.intValue() == this.getAccessSpecId()) {
                    List accessCommandOpSpecResultChoices = (List)tagReportData.get("AccessCommandOpSpecResultChoice");
                    if (accessCommandOpSpecResultChoices == null || accessCommandOpSpecResultChoices.size() == 0) {
                        return;
                    }
                    if (this.isDuplicateTag(tag)) {
                        return;
                    }
                    this.addTagToCache(tag);
                    int j = 0;
                    while (j < accessCommandOpSpecResultChoices.size()) {
                        Map resultParam = (Map)accessCommandOpSpecResultChoices.get(j);
                        String key = (String)resultParam.get("key");
                        if (this.getOpSpecResultParameterKey().equals(key)) {
                            Number opSpecId = (Number)resultParam.get("OpSpecID");
                            Number result = (Number)resultParam.get(this.getOpSpecResultKey());
                            if (this.isLogging(4)) {
                                this.log(4, String.valueOf(this.getTaskName()) + ", TagId: " + tag + ", opSpecId: " + opSpecId + ", result: " + result);
                            }
                            if (opSpecId != null && result != null && opSpecId.intValue() == this.getAccessOpId()) {
                                this.reportAccess(tagReportData, timestamp, result);
                                if (result.intValue() == this.getOpSpecSuccessResultCode()) {
                                    this.oneSuccessOccurred();
                                } else {
                                    this.oneFailureOccurred();
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    protected void reportAccess(Map tagReportData, Object timestamp, Number resultCode) {
        Hashtable<String, Object> resultMap = new Hashtable<String, Object>();
        resultMap.put(TAGREPORTDATA_KEY, tagReportData);
        resultMap.put(RESULTCODE_KEY, resultCode);
        resultMap.put(TIMESTAMP_KEY, timestamp);
        resultMap.put(OPERATIONID_KEY, this.getOperationId());
        this.notifyListener(this.getTaskName(), 3, resultMap);
    }

    public void reset() {
        this.task_add_accessspec.reset();
        this.task_delete_exist_accessspec.reset();
        this.task_enable_accessspec.reset();
    }

    protected void taskFinished(int status) {
        this.setState(0);
        this.notifyListener(this.getTaskName(), status, this.getFinishReport());
    }

    public synchronized void taskNotice(String taskName, int status, Object result) {
        if (status == 0 || status == 2) {
            this.reset();
            this.notifyListener(this.getTaskName(), status, result);
            return;
        }
        if (this.isLogging(4)) {
            this.log(4, "Finished task: " + taskName + " in " + this.getTaskName());
        }
        if (taskName.equals(this.task_delete_exist_accessspec.getTaskName()) && this.getState() == 1) {
            this.task_delete_exist_accessspec.removeTaskListener(this);
            if (this.task_add_accessspec != null) {
                this.task_add_accessspec.addTaskListener(this);
                this.task_add_accessspec.start();
                if (this.isLogging(4)) {
                    this.log(4, "Task started: ADD_ACCESSSPEC " + this.accessSpecId + " in " + this.getTaskName());
                }
            }
            this.setState(2);
            return;
        }
        if (taskName.equals(this.task_add_accessspec.getTaskName())) {
            this.task_add_accessspec.removeTaskListener(this);
            if (this.task_enable_accessspec != null) {
                this.task_enable_accessspec.addTaskListener(this);
                this.task_enable_accessspec.start();
                if (this.isLogging(4)) {
                    this.log(4, "Task started: ENABLE_ACCESSSPEC " + this.accessSpecId + " in " + this.getTaskName());
                }
            }
            this.setState(3);
            return;
        }
        if (taskName.equals(this.task_enable_accessspec.getTaskName())) {
            this.task_enable_accessspec.removeTaskListener(this);
            this.setState(4);
            this.startTimer(this.timeoutValue);
            return;
        }
        if (taskName.equals(this.task_delete_exist_accessspec.getTaskName()) && this.getState() == 5) {
            this.task_delete_exist_accessspec.removeTaskListener(this);
            this.stopTimer();
            this.taskFinished(1);
            return;
        }
        if (taskName.equals(this.task_delete_exist_accessspec.getTaskName()) && this.getState() == 6) {
            this.task_delete_exist_accessspec.removeTaskListener(this);
            this.taskFinished(2);
            return;
        }
    }

    protected synchronized void timeOutOccurred() {
        this.setState(6);
        this.task_delete_exist_accessspec.addTaskListener(this);
        this.task_delete_exist_accessspec.start();
    }
}

