/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.segment;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.filter.service.FilterService;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.parameter.service.ParameterService;
import org.eclipse.soda.dk.parameter.service.SegmentService;
import org.eclipse.soda.dk.segment.MultiSegment;
import org.eclipse.soda.dk.segment.SimpleSegment;

public class ChoiceSegment
extends MultiSegment {
    private SegmentService[] segments;

    public ChoiceSegment() {
    }

    public ChoiceSegment(byte[] bytes, FilterService filter, ParameterService parameter) {
        super(bytes, filter, parameter);
    }

    public ChoiceSegment(byte[] bytes, ParameterService parameter, int occursMinimum, int occursMaximum) {
        super(bytes, null, parameter, occursMinimum, occursMaximum);
    }

    public ChoiceSegment(SimpleSegment[] segments) {
        this.setSegments(segments);
        this.setOccursMinimum(1);
        this.setOccursMaximum(1);
    }

    public ChoiceSegment(String key) {
        super(key, null, null, null, 1, 1);
    }

    public ChoiceSegment(String key, ParameterService parameter) {
        super(key, null, null, parameter, 1, 1);
    }

    public ChoiceSegment(String key, ParameterService parameter, int occursMinimum, int occursMaximum) {
        super(key, null, null, parameter, occursMinimum, occursMaximum);
    }

    public ChoiceSegment(String key, ParameterService[] parameters, int occursMinimum, int occursMaximum) {
        super(null, null, null, occursMinimum, occursMaximum);
        this.setParameters(parameters);
    }

    public ChoiceSegment(String key, SegmentService segment, int occursMinimum, int occursMaximum) {
        super(key, null, null, null, occursMinimum, occursMaximum);
        this.setSegments(new SegmentService[]{segment});
    }

    public ChoiceSegment(String key, SegmentService[] segments) {
        super(key);
        this.setSegments(segments);
        this.setOccursMinimum(1);
        this.setOccursMaximum(1);
    }

    public ChoiceSegment(String key, SegmentService[] segments, int occursMinimum, int occursMaximum) {
        super(key, null, null, null, occursMinimum, occursMaximum);
        this.setSegments(segments);
    }

    public Object decodeValue(MessageService message, ParameterCursorService cursor) {
        SegmentService[] segments = this.getSegments();
        if (segments != null && segments.length > 0) {
            int count = 0;
            int segmentsLength = segments.length;
            if (this.getOccursMaximum() > 1) {
                int bestSize = this.getOccursMaximum();
                if (bestSize > 16) {
                    bestSize = 16;
                }
                if (bestSize < this.getOccursMinimum()) {
                    bestSize = this.getOccursMinimum();
                }
                ArrayList<Object> list = new ArrayList<Object>(bestSize);
                boolean ok = true;
                while (ok) {
                    ok = false;
                    int i = 0;
                    while (i < segmentsLength) {
                        SegmentService segment = segments[i];
                        boolean matches = segment.checkMatches(message, cursor);
                        if (matches) {
                            list.add(segment.decodeValue(message, cursor));
                            ++count;
                            ok = true;
                        }
                        ++i;
                    }
                }
                if (count < this.getOccursMinimum()) {
                    throw new IllegalArgumentException(String.valueOf(String.valueOf(this.getKey())) + ',' + String.valueOf(message));
                }
                if (count > this.getOccursMaximum()) {
                    throw new IllegalArgumentException(String.valueOf(message));
                }
                return list;
            }
            int i = 0;
            while (i < segmentsLength) {
                SegmentService segment = segments[i];
                boolean matches = segment.checkMatches(message, cursor);
                if (matches) {
                    return segment.decodeValue(message, cursor);
                }
                ++i;
            }
            if (count < this.getOccursMinimum()) {
                throw new IllegalArgumentException(String.valueOf(String.valueOf(this.getKey())) + ',' + String.valueOf(message));
            }
            if (count > this.getOccursMaximum()) {
                throw new IllegalArgumentException(String.valueOf(message));
            }
        }
        return null;
    }

    public MessageService encodeValue(MessageService message, Object value, ParameterCursorService cursor) {
        String key;
        SegmentService segment;
        int i;
        ParameterCursorService tcursor = this.createCursorChild(cursor);
        tcursor.setInsert(true);
        SegmentService[] segments = this.getSegments();
        MessageService results = message;
        int count = 0;
        if (value instanceof Map) {
            Map map = (Map)value;
            i = 0;
            while (i < segments.length) {
                segment = segments[i];
                key = segment.getKey();
                if (key != null) {
                    Object valueParameter = map.get(key);
                    if (valueParameter != null) {
                        results = segment.encodeValue(results, valueParameter, tcursor);
                        ++count;
                    } else if (key.equals(map.get("key"))) {
                        results = segment.encodeValue(results, (Object)map, tcursor);
                        ++count;
                    }
                } else {
                    throw new IllegalArgumentException(String.valueOf(segment));
                }
                ++i;
            }
        } else if (value instanceof List) {
            List list = (List)value;
            int j = 0;
            while (j < list.size()) {
                Object element = list.get(j);
                if (element instanceof Map) {
                    Map map = (Map)element;
                    int i2 = 0;
                    while (i2 < segments.length) {
                        SegmentService segment2 = segments[i2];
                        String key2 = segment2.getKey();
                        if (key2 != null) {
                            Object valueParameter = map.get(key2);
                            if (valueParameter != null) {
                                results = segment2.encodeValue(results, valueParameter, tcursor);
                                ++count;
                            } else if (key2.equals(map.get("key"))) {
                                results = segment2.encodeValue(results, (Object)map, tcursor);
                                ++count;
                            }
                        } else {
                            throw new IllegalArgumentException(String.valueOf(segment2));
                        }
                        ++i2;
                    }
                }
                ++j;
            }
        }
        cursor.setOffsetAbsolute(this.getOffsetAbsolute(tcursor));
        if (count < this.getOccursMinimum()) {
            StringBuffer buffer = new StringBuffer(1024);
            buffer.append(this.getKey());
            buffer.append('[');
            i = 0;
            while (i < segments.length) {
                if (i > 0) {
                    buffer.append(',');
                }
                segment = segments[i];
                key = segment.getKey();
                buffer.append(key);
                ++i;
            }
            buffer.append(',');
            buffer.append(message);
            throw new IllegalArgumentException(buffer.toString());
        }
        if (count > this.getOccursMaximum()) {
            throw new IllegalArgumentException(String.valueOf(message));
        }
        return results;
    }

    public SegmentService[] getSegments() {
        return this.segments;
    }

    public void setParameters(ParameterService[] parameters) {
        SegmentService[] segments = new SegmentService[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            segments[i] = (SegmentService)parameters[i];
            ++i;
        }
        this.setSegments(segments);
    }

    public void setSegments(SegmentService[] segments) {
        this.segments = segments;
    }
}

