/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.script;

import java.util.Map;
import org.eclipse.soda.dk.script.ScriptObject;

public class ScriptOperator
extends ScriptObject {
    private char[] characters;

    public ScriptOperator() {
    }

    public ScriptOperator(char[] characters) {
        this.setCharacters(characters);
    }

    public Object evaluate(Map variables, Map locals, Object first, Object second) {
        String operator;
        Object firstObject = this.getConstant(variables, locals, first);
        Object secondObject = this.getConstant(variables, locals, second);
        if (this.characters.length == 1) {
            char character = this.characters[0];
            switch (character) {
                case '%': 
                case '&': 
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case '|': {
                    return this.getNumber(character, firstObject, secondObject);
                }
                case '<': 
                case '>': {
                    return this.getBoolean(character, firstObject, secondObject);
                }
            }
        }
        if ((operator = new String(this.characters)).equals("<<") || operator.equals(">>")) {
            return this.getNumber(this.characters, firstObject, secondObject);
        }
        return this.getBoolean(this.characters, firstObject, secondObject);
    }

    public char[] getCharacters() {
        return this.characters;
    }

    public void setCharacters(char[] characters) {
        this.characters = characters;
    }

    public String toString() {
        return new String(this.characters);
    }
}

