/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.eclipse.soda.dk.parameter.BaseKeyParameter;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;

public class StringParameter
extends BaseKeyParameter {
    private int length = Integer.MAX_VALUE;
    private int offset = Integer.MAX_VALUE;
    protected String encoding;

    public StringParameter() {
    }

    public StringParameter(String key, int length) {
        super(key);
        this.setLength(length);
    }

    public StringParameter(String key, int offset, int length) {
        super(key);
        this.setOffset(offset);
        this.setLength(length);
    }

    public StringParameter(String key, int offset, int length, String encoding) {
        super(key);
        this.setOffset(offset);
        this.setLength(length);
        this.setEncoding(encoding);
    }

    public StringParameter(String key, int length, String encoding) {
        super(key);
        this.setLength(length);
        this.setEncoding(encoding);
    }

    public String dataToString(Object data) {
        return data.toString();
    }

    public Object decodeBytes(byte[] bytes, ParameterCursorService cursor) {
        byte[] parameterBytes = (byte[])super.decodeBytes(bytes, cursor);
        String encoding = this.getEncoding();
        if (encoding != null) {
            try {
                return new String(parameterBytes, this.getEncoding());
            }
            catch (UnsupportedEncodingException exception) {
                StringParameter.handleStaticException(exception);
            }
        }
        return new String(parameterBytes);
    }

    public byte[] encodeBytes(byte[] bytes, Object data, ParameterCursorService cursor) {
        Object value = data;
        if (data instanceof Map) {
            Map map = (Map)data;
            String key = this.getKey();
            if (key != null && key.length() > 0 && (value = map.get(key)) == null) {
                value = data;
            }
        }
        if (value != null) {
            String encoding = this.getEncoding();
            if (encoding != null) {
                try {
                    return super.encodeBytes(bytes, this.dataToString(value).getBytes(this.getEncoding()), cursor);
                }
                catch (UnsupportedEncodingException exception) {
                    StringParameter.handleStaticException(exception);
                }
            }
            return super.encodeBytes(bytes, this.dataToString(data).getBytes(), cursor);
        }
        return bytes;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setEncoding(String encoding) {
        if (encoding != null) {
            try {
                "".getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException(encoding);
            }
        }
        this.encoding = encoding;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }
}

