/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import java.util.Map;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.parameter.BaseKeyParameter;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;

public class SimpleBooleanParameter
extends BaseKeyParameter {
    public static final int FALSE_VALUE = 0;
    public static final int TRUE_VALUE = 1;
    public static final int BOOLEAN_LENGTH = 1;

    public SimpleBooleanParameter() {
        this("Boolean");
    }

    public SimpleBooleanParameter(String key) {
        super(key);
    }

    public boolean booleanValue(Object data) {
        return EscConfiguration.booleanValue(data);
    }

    public Object decodeBytes(byte[] container, ParameterCursorService cursor) {
        long value = SimpleBooleanParameter.getUnsignedLong(container, this.getOffsetAbsolute(cursor), this.getLength(cursor));
        if (value == this.getTrueValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public byte[] encodeBytes(byte[] container, Object data, ParameterCursorService cursor) {
        Object value = data;
        if (data instanceof Map) {
            Map map = (Map)data;
            String key = this.getKey();
            if (key != null && key.length() > 0) {
                value = map.get(key);
            }
        }
        if (value instanceof Number || value instanceof Boolean) {
            int bytesLength;
            boolean state = this.booleanValue(value);
            int n = bytesLength = cursor != null ? cursor.getMessageLength() : container.length << 3;
            if (state) {
                return SimpleBooleanParameter.setBits(container, bytesLength, this.getOffsetAbsolute(cursor), this.getLength(cursor), this.getTrueValue(), this.isInsert(cursor));
            }
            return SimpleBooleanParameter.setBits(container, bytesLength, this.getOffsetAbsolute(cursor), this.getLength(cursor), this.getFalseValue(), this.isInsert(cursor));
        }
        return container;
    }

    public long getFalseValue() {
        return this.getFalseValueDefault();
    }

    public long getFalseValueDefault() {
        return 0L;
    }

    public int getLength() {
        return 1;
    }

    public long getTrueValue() {
        return this.getTrueValueDefault();
    }

    public long getTrueValueDefault() {
        return 1L;
    }
}

