/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import org.eclipse.soda.dk.data.parameter.service.DataParameterService;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.ParameterCursor;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class Parameters
implements ParameterService,
DataParameterService {
    private String key;
    protected ParameterService[] parameters;

    public Parameters(String key, ParameterService[] parameters) {
        this.setKey(key);
        this.parameters = parameters;
    }

    public Object decode(Object container) {
        int length = this.parameters.length;
        Object[] result = new Object[length];
        int index = 0;
        while (index < length) {
            result[index] = this.parameters[index].decode(container);
            ++index;
        }
        return result;
    }

    public Object decodeValue(MessageService message) {
        return this.decodeValue(message, new ParameterCursor());
    }

    public Object decodeValue(MessageService message, ParameterCursorService cursor) {
        int length = this.parameters.length;
        Object[] result = new Object[length];
        int index = 0;
        while (index < length) {
            result[index] = this.parameters[index].decodeValue(message, cursor);
            ++index;
        }
        return result;
    }

    public Object encode(Object container, Object data) {
        int length = this.parameters.length;
        Object result = container;
        if (data instanceof Object[]) {
            Object[] values = (Object[])data;
            int index = length - 1;
            while (index >= 0) {
                result = this.parameters[index].encode(result, values[index]);
                --index;
            }
        }
        return result;
    }

    public MessageService encodeValue(MessageService message, Object value) {
        return this.encodeValue(message, value, null);
    }

    public MessageService encodeValue(MessageService message, Object value, ParameterCursorService cursor) {
        if (cursor == null) {
            int length = this.parameters.length;
            MessageService resultMessage = message;
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                int index = length - 1;
                while (index >= 0) {
                    resultMessage = this.parameters[index].encodeValue(resultMessage, values[index], cursor);
                    --index;
                }
            }
            return resultMessage;
        }
        int length = this.parameters.length;
        MessageService resultMessage = message;
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            int index = 0;
            while (index < length) {
                resultMessage = this.parameters[index].encodeValue(resultMessage, values[index], cursor);
                ++index;
            }
        }
        return resultMessage;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String getKey() {
        return this.key;
    }

    public int getLength(MessageService message, ParameterCursorService cursor) {
        return this.parameters.length;
    }

    public ParameterService[] getParameters() {
        return this.parameters;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isConstantParameter() {
        return false;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

