/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import java.util.Map;
import org.eclipse.soda.dk.parameter.BaseKeyParameter;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;

public class BytesParameter
extends BaseKeyParameter {
    private int length = Integer.MAX_VALUE;
    private int offset = Integer.MAX_VALUE;

    public BytesParameter() {
    }

    public BytesParameter(String key) {
        super(key);
    }

    public BytesParameter(String key, int length) {
        super(key);
        this.setLength(length);
    }

    public BytesParameter(String key, int offset, int length) {
        super(key);
        this.setOffset(offset);
        this.setLength(length);
    }

    public String dataToString(Object data) {
        return data.toString();
    }

    public Object decodeBytes(byte[] container, ParameterCursorService cursor) {
        int offset = this.getOffsetAbsolute(cursor);
        int length = this.getLength(cursor);
        int containerLength = container.length << 3;
        int remainingLength = cursor != null ? Math.min(cursor.getRemainingLength(), containerLength - offset) : containerLength - offset;
        int correctLength = remainingLength > 0 ? Math.min(length, remainingLength) : length;
        byte[] result = BytesParameter.getBytes(container, offset, correctLength);
        super.updateCursor(cursor, correctLength);
        return result;
    }

    public byte[] encodeBytes(byte[] bytes, Object data, ParameterCursorService cursor) {
        Object value = data;
        if (data instanceof Map) {
            Map map = (Map)data;
            String key = this.getKey();
            if (key != null && key.length() > 0 && (value = map.get(key)) == null) {
                value = data;
            }
        }
        byte[] result = super.encodeBytes(bytes, data, cursor);
        super.updateCursor(cursor);
        return result;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    protected void updateCursor(ParameterCursorService cursor) {
    }
}

