/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import java.util.Map;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.parameter.NumberParameter;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;

public class SimpleFloatParameter
extends NumberParameter {
    public static final int FLOAT_LENGTH = 32;

    public SimpleFloatParameter(String key) {
        super(key);
    }

    public SimpleFloatParameter() {
        this("Float");
    }

    public Object decodeBytes(byte[] container, ParameterCursorService cursor) {
        int intValue = (int)SimpleFloatParameter.getLong(container, this.getOffsetAbsolute(cursor), this.getLength(cursor));
        return new Float(Float.intBitsToFloat(intValue));
    }

    public int getLength() {
        return 32;
    }

    public long longValue(Object data) {
        Object value = data;
        if (data instanceof Map) {
            Map map = (Map)data;
            String key = this.getKey();
            if (key != null && key.length() > 0) {
                value = map.get(key);
            }
        }
        float floatValue = EscConfiguration.floatValue(value);
        return Float.floatToIntBits(floatValue);
    }
}

