/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.filter;

import org.eclipse.soda.dk.filter.service.FilterService;
import org.eclipse.soda.dk.message.service.MessageService;

public class Filter
implements FilterService {
    private byte[] mask;

    public Filter(byte[] mask) {
        this.mask = mask;
    }

    public boolean matches(MessageService message0, MessageService message1) {
        byte[] bytes1 = message1.getBytes();
        byte[] bytes0 = message0.getBytes();
        return this.matches(bytes0, bytes1);
    }

    public boolean matches(byte[] bytes0, byte[] bytes1) {
        int length = this.mask.length;
        if (bytes1.length >= length && bytes0.length >= length) {
            int i = length - 1;
            while (i >= 0) {
                if (((bytes0[i] ^ bytes1[i]) & this.mask[i]) != 0) {
                    return false;
                }
                --i;
            }
            return true;
        }
        return false;
    }
}

