/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.data;

import org.eclipse.soda.dk.data.Fraction;

public class IntegerFraction
extends Fraction {
    private static final long serialVersionUID = 5758399825574135950L;
    protected int numerator;
    protected int denominator;

    public IntegerFraction(int numerator) {
        this(numerator, 1);
    }

    public IntegerFraction(int numerator, int denominator) {
        this.setNumerator(numerator);
        this.setDenominator(denominator);
        this.reduce();
    }

    public IntegerFraction(String value) {
        int index = value.indexOf(47, 0);
        if (index == -1) {
            this.setNumerator(Integer.parseInt(value, 10));
            this.setDenominator(1);
        } else {
            this.setNumerator(Integer.parseInt(value.substring(0, index), 10));
            this.setDenominator(Integer.parseInt(value.substring(index + 1), 10));
        }
    }

    public static Number createBest(int numerator, int denominator) {
        if (numerator % denominator == 0) {
            return new Integer(numerator / denominator);
        }
        return new IntegerFraction(numerator, denominator);
    }

    public static int gcd(int a, int b) {
        int ta = a;
        int tb = b;
        if (ta < 0) {
            ta = -ta;
        }
        if (tb < 0) {
            tb = -tb;
        }
        int r = tb;
        if (ta < tb) {
            r = ta;
            ta = tb;
        }
        while (r != 0) {
            tb = ta;
            ta = r;
            r = tb % ta;
        }
        if (ta == 0) {
            return 1;
        }
        return ta;
    }

    public Number add(Number fraction) {
        return IntegerFraction.createBest(this.getNumerator() + fraction.intValue() * this.getDenominator(), this.getDenominator());
    }

    public Number divide(int value) {
        if (this.getNumerator() == value) {
            return new IntegerFraction(1, this.getDenominator());
        }
        return IntegerFraction.createBest(this.getNumerator(), this.getDenominator() * value);
    }

    public Number divide(IntegerFraction fraction) {
        if (this.getNumerator() == fraction.getNumerator()) {
            return IntegerFraction.createBest(this.getDenominator(), fraction.getDenominator());
        }
        if (this.getDenominator() == fraction.getDenominator()) {
            return IntegerFraction.createBest(this.getNumerator(), fraction.getNumerator());
        }
        return IntegerFraction.createBest(this.getNumerator() * fraction.getDenominator(), this.getDenominator() * fraction.getNumerator());
    }

    public Number divide(Number value) {
        if (value instanceof IntegerFraction) {
            return this.divide((IntegerFraction)value);
        }
        return this.divide(value.intValue());
    }

    public double doubleValue() {
        return (double)this.getNumerator() / (double)this.getDenominator();
    }

    public boolean equals(Object compare) {
        if (compare instanceof IntegerFraction) {
            IntegerFraction compare2 = (IntegerFraction)compare;
            if (this.getNumerator() != compare2.getNumerator()) {
                return false;
            }
            return this.getNumerator() == compare2.getNumerator();
        }
        return false;
    }

    public float floatValue() {
        return (float)this.getNumerator() / (float)this.getDenominator();
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int intDenominator() {
        return this.getDenominator();
    }

    public int intNumerator() {
        return this.getNumerator();
    }

    public int intValue() {
        return this.getNumerator() / this.getDenominator();
    }

    public long longDenominator() {
        return this.getDenominator();
    }

    public long longNumerator() {
        return this.getNumerator();
    }

    public long longValue() {
        return (long)this.getNumerator() / (long)this.getDenominator();
    }

    public Number multiply(int value) {
        int denominator = this.getDenominator();
        if (denominator == value) {
            return new Integer(this.getNumerator());
        }
        int newNumerator = this.getNumerator() * value;
        int remainder = newNumerator % denominator;
        if (remainder == 0) {
            return new Integer(newNumerator / denominator);
        }
        return IntegerFraction.createBest(newNumerator, denominator);
    }

    public Number multiply(IntegerFraction fraction) {
        if (this.getNumerator() == fraction.getDenominator()) {
            return IntegerFraction.createBest(fraction.getNumerator(), this.getDenominator());
        }
        if (this.getDenominator() == fraction.getNumerator()) {
            return IntegerFraction.createBest(this.getNumerator(), fraction.getDenominator());
        }
        return IntegerFraction.createBest(this.getNumerator() * fraction.getNumerator(), this.getDenominator() * fraction.getDenominator());
    }

    public Number multiply(Number value) {
        if (value instanceof IntegerFraction) {
            return this.multiply((IntegerFraction)value);
        }
        return this.multiply(value.intValue());
    }

    public Number negate() {
        return new IntegerFraction(-this.getNumerator(), this.getDenominator());
    }

    public Number reciprocal() {
        return new IntegerFraction(this.getDenominator(), this.getNumerator());
    }

    public void reduce() {
        if (this.getNumerator() % this.getDenominator() == 0) {
            this.setNumerator(this.getNumerator() / this.getDenominator());
            this.setDenominator(1);
        } else {
            int gcd = IntegerFraction.gcd(this.getNumerator(), this.getDenominator());
            this.setNumerator(this.getNumerator() / gcd);
            this.setDenominator(this.getDenominator() / gcd);
        }
    }

    public void setDenominator(int denominator) {
        this.denominator = denominator;
    }

    protected void setNumerator(int numerator) {
        this.numerator = numerator;
    }

    public Number subtract(Number fraction) {
        return IntegerFraction.createBest(this.getNumerator() - fraction.intValue() * this.getDenominator(), this.getDenominator());
    }

    public String toString() {
        int denominator = this.getDenominator();
        if (denominator == 1) {
            return Integer.toString(this.getNumerator());
        }
        StringBuffer buffer = new StringBuffer(32);
        int power = 10;
        while (power < 1001) {
            if (power % denominator == 0) {
                int times = power / denominator;
                int value = this.getNumerator() * times;
                int fraction = value % power;
                buffer.append(Integer.toString(this.intValue()));
                buffer.append('.');
                buffer.append(Integer.toString(fraction + power).substring(1));
                return buffer.toString();
            }
            power *= 10;
        }
        buffer.append(Integer.toString(this.getNumerator()));
        buffer.append('/');
        buffer.append(Integer.toString(this.getDenominator()));
        return buffer.toString();
    }
}

