/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.nls.testcase;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Properties;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.nls.Nls;

public class NlsTestcase
extends TestCase {
    public static final String RESOURCE_BUNDLE = "ResourceBundle";
    public static final String EMPTY_STRING = new String();
    static /* synthetic */ Class class$0;

    public static void main(String[] arguments) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.nls.testcase.NlsTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public NlsTestcase(String name) {
        super(name);
    }

    public void test02() {
        Hashtable table = Nls.getProperties(((Object)((Object)this)).getClass(), (String)"Test2");
        System.out.println(table.size());
        NlsTestcase.assertEquals((int)3, (int)table.size());
    }

    public void test03() {
        Hashtable table = Nls.getProperties(((Object)((Object)this)).getClass(), (String)"Test3");
        System.out.println(table.size());
        NlsTestcase.assertEquals((int)1, (int)table.size());
    }

    public void test04() {
        Properties table = System.getProperties();
        Object[] objects = new Object[]{table, table};
        String data = Nls.format((String)"data 0 = {0}\r\n\t data 1 = {1}", (Object[])objects);
        System.out.println(data);
    }

    public void test10() {
        String results = Nls.formatData((Object)"\tabc\r\n\"");
        NlsTestcase.assertEquals((String)"\"\\tabc\\r\\n\\\"\"", (String)results);
    }

    public void test11() {
        String results = Nls.formatData((Object)"\t,abc\r\n\"");
        NlsTestcase.assertEquals((String)"\"\\t,abc\\r\\n\\\"\"", (String)results);
    }

    public void testA() {
        String[] additions = Nls.getNlsAdditions();
        int i = 0;
        while (i < additions.length) {
            System.out.println(additions[i]);
            ++i;
        }
    }

    public void testFormat01() {
        byte[] bytes = new byte[]{1, 2};
        String results = Nls.formatHexBytes((byte[])bytes, (int)0, (int)bytes.length);
        System.out.println(results);
        NlsTestcase.assertEquals((String)"{1,2}", (String)results);
    }

    public void testFormat02() {
        byte[] bytes = new byte[]{13, 10};
        String results = Nls.formatHexBytes((byte[])bytes, (int)0, (int)bytes.length);
        System.out.println(results);
        NlsTestcase.assertEquals((String)"\"\\r\\n\"", (String)results);
    }

    public void testFormat03() {
        byte[] bytes = new byte[]{48, 49, 13, 10};
        String results = Nls.formatHexBytes((byte[])bytes, (int)0, (int)bytes.length);
        System.out.println(results);
        NlsTestcase.assertEquals((String)"\"01\\r\\n\"", (String)results);
    }

    public void testFormat04() {
        byte[] bytes = new byte[]{1, 71, 101, 116, 32, 84, 97, 103, 76, 105, 115, 116, 13, 10};
        String results = Nls.formatHexBytes((byte[])bytes, (int)0, (int)bytes.length);
        System.out.println(results);
        NlsTestcase.assertEquals((String)"{1,47,65,74,20,54,61,67,4c,69,73,74,d,a}=\"\\1Get TagList\\r\\n\"", (String)results);
        String results2 = Nls.formatHexBytes((byte[])bytes, (int)1, (int)(bytes.length - 1));
        NlsTestcase.assertEquals((String)"\"Get TagList\\r\\n\"", (String)results2);
    }

    public void testFormat05() {
        byte[] bytes = new byte[1];
        String results = Nls.formatHexBytes((byte[])bytes, (int)0, (int)bytes.length);
        System.out.println(results);
        NlsTestcase.assertEquals((String)"{0}", (String)results);
    }

    public void testFormat06() {
        byte[] byArray = new byte[19];
        byArray[16] = 50;
        byArray[17] = 13;
        byArray[18] = 15;
        byte[] bytes = byArray;
        String results = Nls.formatHexBytes((byte[])bytes, (int)18, (int)1);
        System.out.println(results);
        NlsTestcase.assertEquals((String)"{f}", (String)results);
    }

    public void testFormatPerformance01() {
        byte[] bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 97, 98};
        String results = "";
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < 1000000) {
            StringBuffer buffer = new StringBuffer(512);
            Nls.formatHexBytes((byte[])bytes, (int)0, (int)bytes.length, (StringBuffer)buffer);
            results = buffer.toString();
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.println("time " + (end - start));
        NlsTestcase.assertEquals((String)"{1,2,3,4,5,6,7,8,9,a,b,c,d,e,f,61,62}", (String)results);
    }

    public void testFormatTimePerformance01() {
        String results = "";
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(2008, 1, 31, 12, 13, 14);
        long time = calendar.getTimeInMillis();
        System.gc();
        System.gc();
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < 1000000) {
            results = Nls.formatTimestamp((long)time, (int)15);
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.println("format time " + (end - start));
        NlsTestcase.assertEquals((String)"12:13:14.000", (String)results);
    }

    public void testParseCompressedHexString01() {
        byte[] bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        byte[] results = null;
        System.gc();
        System.gc();
        System.gc();
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < 10000000) {
            results = Nls.parseCompressedHexString((String)"0102030405060708090a0b0c0d0e0f");
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.println("testParseCompressedHexString01 time " + (end - start));
        NlsTestcase.assertTrue((boolean)Arrays.equals(bytes, results));
    }
}

