/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.concrete.measurement;

import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.command.service.MultiplexCommandListener;
import org.eclipse.soda.dk.measurement.CommandMeasurement;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transform.service.TransformService;
import org.eclipse.soda.dk.units.service.UnitsService;

public class ConcreteMeasurement
extends CommandMeasurement
implements MultiplexCommandListener {
    private boolean triggerOnSetValue = this.getBoolean("concretemeasurement.triggeronsetvalue", true);
    private boolean triggerOnReadCommand = this.getBoolean("concretemeasurement.triggeronreadcommand", true);

    public ConcreteMeasurement(String key, Object value, UnitsService units, TransformService transform, SignalService signal, CommandService readCommand, CommandService writeCommand) {
        super(key, value, units, transform, signal, readCommand, writeCommand);
        if (readCommand != null) {
            readCommand.addCommandListener((CommandListener)this);
        }
        if (writeCommand != null) {
            writeCommand.addCommandListener((CommandListener)this);
        }
    }

    public void commandExecuted(CommandService source, Object timestamp, ChannelService channel, Object data) {
        Object value;
        SignalService signal;
        if (this.triggerOnReadCommand && source == this.getReadCommand() && (signal = this.getSignal()) != null && (value = this.getValue(channel)) != null) {
            signal.trigger(channel, value);
        }
        if (source == this.getWriteCommand() && data != null) {
            this.setRawValue(channel, data, timestamp);
        }
    }

    public void commandExecuted(CommandService source, Object timestamp, Object data) {
        this.commandExecuted(source, timestamp, null, data);
    }

    public void executeWrite(ChannelService channel, Object value) {
        if (this.getWriteCommand() != null) {
            this.setValue(channel, value);
        }
        super.executeWrite(channel, value);
    }

    public void executeWrite(Object value) {
        this.executeWrite(null, value);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.getReadCommand() != null) {
            this.getReadCommand().removeCommandListener((CommandListener)this);
        }
        if (this.getWriteCommand() != null) {
            this.getWriteCommand().removeCommandListener((CommandListener)this);
        }
        super.finalize();
    }

    public void setTriggerOnReadCommand(boolean triggerOnReadCommand) {
        this.triggerOnReadCommand = triggerOnReadCommand;
    }

    public void setTriggerOnSetValue(boolean triggerOnSetValue) {
        this.triggerOnSetValue = triggerOnSetValue;
    }

    public void setValue(ChannelService channel, Object value, Object timestamp) {
        SignalService signal;
        super.setValue(channel, value, timestamp);
        if (this.triggerOnSetValue && (signal = this.getSignal()) != null && value != null) {
            signal.trigger(channel, value);
        }
    }

    public void setValue(Object value, Object timestamp) {
        this.setValue(null, value, timestamp);
    }

    public void signalOccurred(SignalService source, Object timestamp, ChannelService channel, Object data) {
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        this.signalOccurred(source, timestamp, null, data);
    }
}

