/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.preference;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.soda.devicekit.DeviceKitPlugin;
import org.eclipse.soda.devicekit.preference.DeviceKitPreferenceInitializer;
import org.eclipse.soda.devicekit.ui.DkImages;
import org.eclipse.soda.devicekit.ui.preference.CommonPreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DkClasspathPreferencePage
extends CommonPreferencePage
implements IWorkbenchPreferencePage {
    private Image tableImage;
    private TableViewer tableViewer;
    private Button addDirectory;
    private Button addFile;
    private Button remove;
    private Button projects;
    private SelectionListener addDirectoryListener;
    private SelectionListener addFileListener;
    private SelectionListener removeListener;
    private SelectionListener tableListener;
    private int[] tableSelection = new int[0];

    public DkClasspathPreferencePage() {
        super("Device Kit Classpath");
    }

    public DkClasspathPreferencePage(String title) {
        super(title);
    }

    public DkClasspathPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected void addListeners() {
        Table table = this.getLocationsTable();
        Object listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                DkClasspathPreferencePage.this.tableSelected();
            }
        };
        table.addSelectionListener(listener);
        this.setTableListener((SelectionListener)listener);
        Button addDirectory = this.getAddDirectoryButton();
        listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                DkClasspathPreferencePage.this.doAddDirectory();
            }
        };
        addDirectory.addSelectionListener(listener);
        this.setAddDirectoryListener((SelectionListener)listener);
        Button addFile = this.getAddFileButton();
        listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                DkClasspathPreferencePage.this.doAddFile();
            }
        };
        addFile.addSelectionListener(listener);
        this.setAddFileListener((SelectionListener)listener);
        Button remove = this.getRemoveButton();
        listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                DkClasspathPreferencePage.this.removeLocation();
            }
        };
        remove.addSelectionListener(listener);
        this.setRemoveListener((SelectionListener)listener);
    }

    private void addLocation(String location) {
        Table table;
        if (location != null && location.trim().length() > 0 && !this.isInTable(table = this.getLocationsTable(), location)) {
            TableItem item = new TableItem(table, 0);
            item.setText(location);
            item.setImage(this.getTableImage());
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData data = new GridData(1810);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        label.setText(this.getLocationsLabel());
        data = new GridData(4);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        Composite scComposite = new Composite(composite, 0);
        layout = new GridLayout(1, false);
        scComposite.setLayout((Layout)layout);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        scComposite.setLayoutData((Object)data);
        Table table = new Table(scComposite, 2818);
        data = new GridData(1808);
        data.horizontalSpan = 1;
        data.widthHint = this.getTableWidthHint();
        data.heightHint = this.getTableHeightHint(table);
        table.setLayoutData((Object)data);
        TableViewer viewer = new TableViewer(table);
        this.setTableViewer(viewer);
        Composite buttonComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(2);
        buttonComposite.setLayoutData((Object)data);
        Button addDirectory = new Button(buttonComposite, 0x1000008);
        addDirectory.setText("Add Directory");
        data = new GridData(2);
        data.horizontalSpan = 1;
        data.widthHint = this.getButtonWidth();
        addDirectory.setLayoutData((Object)data);
        this.setAddDirectoryButton(addDirectory);
        Button addFile = new Button(buttonComposite, 0x1000008);
        addFile.setText("Add File");
        data = new GridData(2);
        data.horizontalSpan = 1;
        data.widthHint = this.getButtonWidth();
        addFile.setLayoutData((Object)data);
        this.setAddFile(addFile);
        Button remove = new Button(buttonComposite, 0x1000008);
        remove.setText("Remove");
        data = new GridData(2);
        data.horizontalSpan = 1;
        data.widthHint = this.getButtonWidth();
        remove.setLayoutData((Object)data);
        this.setRemoveButton(remove);
        Button projects = new Button(composite, 32);
        projects.setText("Search projects");
        data = new GridData(768);
        projects.setLayoutData((Object)data);
        boolean checked = DeviceKitPreferenceInitializer.getPreferenceBoolean((String)this.getProjectsKey());
        projects.setSelection(checked);
        this.setProjectsButton(projects);
        this.addListeners();
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected void doAddDirectory() {
        DirectoryDialog d = new DirectoryDialog(this.getShell());
        String result = d.open();
        this.addLocation(result);
    }

    protected void doAddFile() {
        FileDialog d = new FileDialog(this.getShell());
        String result = d.open();
        System.out.println(d);
        this.addLocation(result);
    }

    protected boolean doSearchProjects() {
        Button projects = this.getProjectsButton();
        return projects.getSelection();
    }

    protected Button getAddDirectoryButton() {
        return this.addDirectory;
    }

    protected SelectionListener getAddDirectoryListener() {
        return this.addDirectoryListener;
    }

    protected Button getAddFileButton() {
        return this.addFile;
    }

    protected SelectionListener getAddFileListener() {
        return this.addFileListener;
    }

    protected int getButtonWidth() {
        return 75;
    }

    protected String getLocationsKey() {
        return "classpath.preference_page.Locations";
    }

    protected String getLocationsLabel() {
        return "Locations To Search";
    }

    protected Table getLocationsTable() {
        TableViewer viewer = this.getTableViewer();
        return viewer.getTable();
    }

    protected Button getProjectsButton() {
        return this.projects;
    }

    protected String getProjectsKey() {
        return "classpath.preference_page.SearchProjects";
    }

    protected Button getRemoveButton() {
        return this.remove;
    }

    protected SelectionListener getRemoveListener() {
        return this.removeListener;
    }

    protected String[] getStoredLocationItems() {
        String[] items;
        String locations = DeviceKitPlugin.getDefault().getPluginPreferences().getString(this.getLocationsKey());
        if (locations != null && !locations.equals("null") && (items = DeviceKitPreferenceInitializer.parsePrefArray((String)locations)) != null) {
            return items;
        }
        return new String[0];
    }

    protected int getTableHeightHint(Table table) {
        return table.getItemHeight() * 20;
    }

    protected Image getTableImage() {
        if (this.tableImage == null) {
            this.tableImage = DkImages.getInstance().createImage(DkImages.DESC_CLASSPATH_LOC_ICON);
        }
        return this.tableImage;
    }

    protected TableItem[] getTableItems(String[] items) {
        TableItem[] titems = new TableItem[items.length];
        Table table = this.getLocationsTable();
        Image image = this.getTableImage();
        int i = 0;
        while (i < items.length) {
            TableItem item = new TableItem(table, 0);
            item.setText(items[i]);
            item.setImage(image);
            titems[i] = item;
            ++i;
        }
        return titems;
    }

    protected SelectionListener getTableListener() {
        return this.tableListener;
    }

    protected int[] getTableSelection() {
        return this.tableSelection;
    }

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    protected int getTableWidthHint() {
        return 250;
    }

    public void init(IWorkbench workbench) {
    }

    protected boolean isInTable(Table table, String value) {
        TableItem[] items = table.getItems();
        int i = 0;
        while (i < items.length) {
            String itemValue = items[i].getText();
            if (itemValue.equals(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void performApply() {
        this.storeValues();
    }

    protected void performDefaults() {
        super.performDefaults();
        Table table = this.getLocationsTable();
        table.removeAll();
        this.setTableSelection(new int[0]);
        Button button = this.getProjectsButton();
        boolean defaultValue = DeviceKitPreferenceInitializer.getDefaultBoolean((String)this.getProjectsKey());
        button.setSelection(defaultValue);
    }

    public boolean performOk() {
        this.storeValues();
        this.removeListeners();
        return super.performOk();
    }

    protected void removeListeners() {
        Button remove = this.getRemoveButton();
        SelectionListener listener = this.getRemoveListener();
        if (remove != null && listener != null) {
            remove.removeSelectionListener(listener);
        }
        Button add = this.getAddDirectoryButton();
        listener = this.getAddDirectoryListener();
        if (add != null && listener != null) {
            add.removeSelectionListener(listener);
        }
        Table table = this.getLocationsTable();
        listener = this.getTableListener();
        if (table != null && listener != null) {
            table.removeSelectionListener(listener);
        }
    }

    protected void removeLocation() {
        Table table;
        int[] selection = this.getTableSelection();
        if (selection != null && selection.length > 0 && (table = this.getLocationsTable()).getItemCount() > 0) {
            table.remove(selection);
        }
    }

    private void setAddDirectoryButton(Button add) {
        this.addDirectory = add;
    }

    private void setAddDirectoryListener(SelectionListener addListener) {
        this.addDirectoryListener = addListener;
    }

    private void setAddFile(Button addFile) {
        this.addFile = addFile;
    }

    private void setAddFileListener(SelectionListener addFileListener) {
        this.addFileListener = addFileListener;
    }

    private void setProjectsButton(Button projects) {
        this.projects = projects;
    }

    private void setRemoveButton(Button remove) {
        this.remove = remove;
    }

    private void setRemoveListener(SelectionListener removeListener) {
        this.removeListener = removeListener;
    }

    private void setTableListener(SelectionListener listener) {
        this.tableListener = listener;
    }

    private void setTableSelection(int[] selection) {
        this.tableSelection = selection;
    }

    private void setTableViewer(TableViewer viewer) {
        this.tableViewer = viewer;
    }

    protected void storeValues() {
        DeviceKitPreferenceInitializer.setPreference((String)"classpath.preference_page.SearchProjects", (boolean)this.doSearchProjects());
        Table table = this.getLocationsTable();
        TableItem[] titems = table.getItems();
        String[] items = new String[titems.length];
        int i = 0;
        while (i < titems.length) {
            items[i] = titems[i].getText();
            ++i;
        }
        DeviceKitPreferenceInitializer.setPreference((String)"classpath.preference_page.Locations", (String[])items);
    }

    protected void tableSelected() {
        Table table = this.getLocationsTable();
        int[] selection = table.getSelectionIndices();
        this.setTableSelection(selection);
    }
}

