/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.feature.operation;

import java.util.Calendar;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.soda.devicekit.DeviceKitPlugin;
import org.eclipse.soda.devicekit.generator.utilty.SortedSet;
import org.eclipse.soda.devicekit.preference.DeviceKitPreferenceInitializer;
import org.eclipse.soda.devicekit.ui.feature.operation.FeatureOperation;
import org.eclipse.soda.devicekit.util.CoreUtility;

public class AllFeatureOperation
extends FeatureOperation {
    private IFile[] files;
    private String[] projectNames = null;

    public AllFeatureOperation(Map variables, IFile[] files) {
        super(variables);
        this.files = files;
        this.setProjectNames(this.getProjectNamesFromFiles());
    }

    public AllFeatureOperation(Map variables, String[] names) {
        super(variables);
        this.files = null;
        this.setProjectNames(names);
    }

    public IProject[] getMissingFeatures() {
        SortedSet set = new SortedSet();
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject[] projects = ws.getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            String name = projects[i].getName();
            String root = CoreUtility.getBaseName((String)name);
            set.add((Object)root);
            ++i;
        }
        Object[] results = new IProject[set.size()];
        results = (IProject[])set.toArray(results);
        return results;
    }

    public String[] getProjectNames() {
        return this.projectNames;
    }

    public String[] getProjectNamesFromFiles() {
        SortedSet set = new SortedSet();
        int i = 0;
        while (i < this.files.length) {
            IProject project = this.files[i].getProject();
            String name = project.getName();
            String root = CoreUtility.getBaseName((String)name);
            set.add((Object)root);
            ++i;
        }
        Object[] results = new String[set.size()];
        results = (String[])set.toArray(results);
        return results;
    }

    private String getVersion() {
        return DeviceKitPreferenceInitializer.getPreferenceString((String)"version");
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        Map map = this.getVariables();
        String[] projectNames = this.getProjectNames();
        String version = this.getVersion();
        if (map.get("version") == null) {
            map.put("version", version);
        }
        String vendor = DeviceKitPlugin.getVendor();
        if (map.get("vendor") == null) {
            map.put("vendor", vendor);
        }
        if (map.get("vendors") == null) {
            map.put("vendors", DeviceKitPlugin.getVendors());
        }
        if (map.get("year") == null) {
            map.put("year", Integer.toString(Calendar.getInstance().get(1)));
        }
        if (map.get("years") == null) {
            map.put("years", Integer.toString(Calendar.getInstance().get(1)));
        }
        if (map.get("provider") == null) {
            map.put("provider", DeviceKitPlugin.getProvider());
        }
        if (map.get("today") == null) {
            map.put("today", "${today}");
        }
        if (map.get("osgi.framework.version") == null) {
            map.put("osgi.framework.version", "${osgi.framework.version}");
        }
        int i = 0;
        while (i < projectNames.length) {
            String name = projectNames[i];
            map.put("name", name);
            map.put("description", name);
            super.run(monitor);
            ++i;
        }
    }

    public void setProjectNames(String[] projectNames) {
        this.projectNames = projectNames;
    }
}

