/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.action.wizard;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.devicekit.ui.action.wizard.VendorMessages;
import org.eclipse.soda.devicekit.ui.wizard.DeviceKitPage;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VendorPage
extends DeviceKitPage {
    public static final String[] EXTENSIONS = new String[]{"packagebase", "provider", "version", "vendor", "vendortwo", "description"};
    private static IWizardMessages messages = VendorMessages.getInstance();
    protected List list = null;
    protected Map listExtensions = new HashMap();

    public VendorPage(String pageName) {
        super(pageName);
        this.setTitle(messages.getString("fixSource"));
    }

    public VendorPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected Button createCheckBoxControl(Composite composite, String key, Map map) {
        Button button = super.createCheckBoxControl(composite, key);
        if (map.get(key) != null) {
            button.setSelection(true);
        }
        return button;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setMessage(this.getDefaultMessage());
        Composite composite = new Composite(parent, 0);
        Dialog.applyDialogFont((Control)composite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.createCustomControl(composite);
        this.updatePageCompletion();
        Dialog.applyDialogFont((Control)composite);
        composite.layout(true);
        this.setControl((Control)composite);
        parent.layout(true);
        parent.redraw();
    }

    protected void createCustomControl(Composite composite) {
        int i = 0;
        while (i < EXTENSIONS.length) {
            this.createTextControl(composite, EXTENSIONS[i]);
            ++i;
        }
    }

    public Map createListExtensions() {
        HashMap<String, String> map = new HashMap<String, String>();
        List list = this.getList();
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                Object element = list.get(i);
                String extension = null;
                if (element instanceof ICompilationUnit || element instanceof IType) {
                    extension = "java";
                } else if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    extension = file.getFileExtension();
                } else {
                    int j = 0;
                    while (j < EXTENSIONS.length) {
                        map.put(EXTENSIONS[j], "true");
                        ++j;
                    }
                }
                if (extension != null && extension.length() > 0) {
                    map.put(extension.toLowerCase(), "true");
                }
                ++i;
            }
        }
        return map;
    }

    protected Text createTextControl(Composite composite, String key) {
        Text text = super.createTextControl(composite, key);
        Object value = this.listExtensions.get(key);
        if (value != null) {
            text.setText(value.toString());
        }
        return text;
    }

    protected String getKey() {
        return "profile";
    }

    public List getList() {
        return this.list;
    }

    public Map getListExtensions() {
        return this.listExtensions;
    }

    public String getString(String key) {
        try {
            return messages.getString(key);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return key;
        }
    }

    public void setList(List list) {
        this.list = list;
    }

    public void setListExtensions(Map listExtensions) {
        this.listExtensions = listExtensions;
    }

    protected boolean updatePageErrors() {
        this.update(true, this.doesNextPageExist(), null, null);
        return true;
    }
}

