//Used to Enable/Disable input fields by way of a check box
function toggle(FormObj, ElemName, enabled) {
	if(FormObj[ElemName]) {
		FormObj[ElemName].disabled = (!enabled);
		if(enabled) {
			FormObj[ElemName].style.backgroundColor = "#fff";
		} else {
			FormObj[ElemName].style.backgroundColor = "#ddd";
		}
	}
	else {
		alert("Problem changing config state");
	}
}

function ValidateType(Form, Type, Card) {
	if(Card == 0) {
		if(Type == 2 || Type == 3 || Type == 4 || Type == 8) {
			if (!isnum(Form.value, "0123456789")) {
				Form.style.backgroundColor = "red";
				alert(Form.value + " is not an integer")
			} else {
				Form.style.backgroundColor = "#fff";
			}
		}
		else if(Type == 5) {
			if (Form.value.length == 1) {
				Form.style.backgroundColor = "#fff";
			} else {
				Form.style.backgroundColor = "red";
				alert(Form.value + " is not a character")
			}
		}
		else if(Type == 6) {
			if (!isnum(Form.value, "0123456789abcdef")) {
				Form.style.backgroundColor = "red";
				alert(Form.value + " is not a hex byte")
			} else {
				Form.style.backgroundColor = "#fff";
			}
		}
		else if(Type == 7) {
			if (!isnum(Form.value, "0123456789.")) {
				Form.style.backgroundColor = "red";
				alert(Form.value + " is not a double")
			} else {
				Form.style.backgroundColor = "#fff";
			}
		}
		else if(Type == 11) {
			if(Form.value == "true" || Form.value == "false") {
				Form.style.backgroundColor = "#fff";
			} else {
				Form.style.backgroundColor = "red";
				alert(Form.value + " is not a boolean")
			}
		}
	}
}

function isnum(s, ValidChars) {
	var IsNumber=true;
	var Char;
	for (i = 0; i < s.length && IsNumber == true; i++) { 
		Char = s.charAt(i); 
		if (ValidChars.indexOf(Char) == -1) {
			if(!(i == 0 && Char == '-')) {
				IsNumber = false;
			}
		}
	}
	return IsNumber;   
}

//Fix for IE not saving state when using the back button
function encheck(Form, Elem) {
	Form[Elem].disabled = (!Form['chk_'+Elem].checked);
}

//Needed to re-enable fields when using the reset button
function initialize(FormName) {
	var reset = FormName.elements;
	for (var i = 0; i < reset.length; i++) {
		if(reset[i].type == 'text') {
			reset[i].disabled = false;
			reset[i].style.backgroundColor = "#fff";
		}
	}
}

//called on page load to set all initial states
function initialize_page() {
	for (var i = 0; i < document.forms.length; i++) {
		for (var j = 0; j < document.forms[i].elements.length; j++) {
			if(document.forms[i].elements[j].type == 'checkbox') {
				if(document.forms[i].elements[j].id == 'true') {
					document.forms[i].elements[j].checked = true;
			 		document.forms[i].elements[j].disabled = true;
					document.forms[i][document.forms[i].elements[j].name.substring(4)].disabled = false;
					document.forms[i][document.forms[i].elements[j].name.substring(4)].style.backgroundColor = "#fff";
			 	}
			 	else if(document.forms[i].elements[j].id == 'false') {
			 		document.forms[i].elements[j].disabled = false;
					if((document.forms[i][document.forms[i].elements[j].name.substring(4)].value == 'null') || (document.forms[i][document.forms[i].elements[j].name.substring(4)].value == '')) {
						document.forms[i].elements[j].checked = false;
						document.forms[i][document.forms[i].elements[j].name.substring(4)].disabled = true;
						document.forms[i][document.forms[i].elements[j].name.substring(4)].style.backgroundColor = "#ddd";
					}
					else {
						document.forms[i].elements[j].checked = true;
						document.forms[i][document.forms[i].elements[j].name.substring(4)].disabled = false;
						document.forms[i][document.forms[i].elements[j].name.substring(4)].style.backgroundColor = "#fff";
					}
			 	}
			}
		}
	}
}
