/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.common.util;

public class RingBuffer {
    private Object[] buffer;
    private int next = 0;
    private int size;

    public RingBuffer(int size) {
        this.size = Math.max(1, size);
        this.buffer = new Object[this.size];
    }

    public synchronized int add(Object obj) {
        this.next %= this.size;
        this.buffer[this.next] = obj;
        return this.next++;
    }

    public synchronized Object[] subset(int start, int end) {
        start = start >= 0 ? start : 0;
        int n = end = end <= this.next ? end : this.next;
        if (start >= end) {
            return null;
        }
        Object[] result = new Object[end - start];
        int i = 0;
        while (i < result.length) {
            result[i] = this.buffer[start++];
            ++i;
        }
        return result;
    }

    public Object[] subset(int start) {
        return this.subset(start, this.next);
    }

    public synchronized Object getObject(int idx) {
        if (idx < 0 || this.next == 0) {
            return null;
        }
        return this.buffer[idx < this.next ? idx : this.next - 1];
    }

    public int getNextPosition() {
        return this.next;
    }

    public int getSize() {
        return this.size;
    }
}

