/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.io.impl;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connection;
import org.eclipse.equinox.internal.io.impl.ConnectionNotifierImpl;
import org.eclipse.equinox.internal.io.impl.ConnectorServiceImpl;
import org.eclipse.equinox.internal.io.impl.PrivilegedRunner;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.io.ConnectionFactory;

public class ConnectionFactoryListener
implements ServiceListener,
PrivilegedRunner.PrivilegedDispatcher {
    private static Hashtable urlToConN = new Hashtable(5);
    private BundleContext bc;
    static int count = 0;
    static /* synthetic */ Class class$0;

    public ConnectionFactoryListener(BundleContext bc) {
        this.bc = bc;
        try {
            StringBuffer stringBuffer = new StringBuffer("(objectClass=");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.io.ConnectionFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            bc.addServiceListener((ServiceListener)this, stringBuffer.append(clazz.getName()).append(')').toString());
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
    }

    public void close() {
        this.bc.removeServiceListener((ServiceListener)this);
        if (!urlToConN.isEmpty()) {
            Vector copyV = new Vector(urlToConN.size());
            Enumeration<Object> en = urlToConN.elements();
            while (en.hasMoreElements()) {
                copyV.addElement(en.nextElement());
            }
            en = copyV.elements();
            while (en.hasMoreElements()) {
                ConnectionNotifierImpl cn = (ConnectionNotifierImpl)en.nextElement();
                try {
                    cn.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static void removeConnectionNotifier(String url) {
        urlToConN.remove(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Connection getConnectionNotifier(String scheme, String url, int mode, boolean timeouts, String filter, int count) throws IOException {
        ConnectionNotifierImpl ret = null;
        Hashtable hashtable = urlToConN;
        synchronized (hashtable) {
            if (urlToConN.containsKey(url)) {
                return (Connection)urlToConN.get(url);
            }
            ret = new ConnectionNotifierImpl(scheme, url, mode, timeouts, filter);
            urlToConN.put(url, ret);
            if (count == ConnectionFactoryListener.count) {
                return ret;
            }
        }
        Connection c = ConnectorServiceImpl.getConnection(filter, url, mode, timeouts, false);
        if (c != null) {
            if (ret.hasListeners()) {
                ret.notifyCreated(c);
            } else {
                ret.close();
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1 && !urlToConN.isEmpty()) {
            ServiceReference ref = event.getServiceReference();
            ConnectionFactory factory = (ConnectionFactory)this.bc.getService(ref);
            String[] schemes = (String[])ref.getProperty("io.scheme");
            Vector<ConnectionNotifierImpl> toNotify = new Vector<ConnectionNotifierImpl>(urlToConN.size());
            Hashtable hashtable = urlToConN;
            synchronized (hashtable) {
                Enumeration en = urlToConN.elements();
                while (en.hasMoreElements()) {
                    ConnectionNotifierImpl cn = (ConnectionNotifierImpl)en.nextElement();
                    if (!ConnectionFactoryListener.match(schemes, cn.scheme)) continue;
                    toNotify.addElement(cn);
                }
            }
            int i = 0;
            while (i < toNotify.size()) {
                ConnectionNotifierImpl cn = (ConnectionNotifierImpl)toNotify.elementAt(i);
                try {
                    if (cn.context != null) {
                        PrivilegedRunner.doPrivileged(cn.context, this, 0, cn, factory, null, null);
                        return;
                    }
                    Connection connection = factory.createConnection(cn.url, cn.mode, cn.timeouts);
                    if (cn.hasListeners()) {
                        cn.notifyCreated(connection);
                    } else {
                        cn.close();
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
                ++i;
            }
            this.bc.ungetService(ref);
        }
    }

    static boolean match(String[] schemes, String scheme) {
        if (schemes != null && scheme != null) {
            int i = 0;
            while (i < schemes.length) {
                if (scheme.equals(schemes[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Object dispatchPrivileged(int type, Object arg1, Object arg2, Object arg3, Object arg4) throws Exception {
        ConnectionNotifierImpl cn = (ConnectionNotifierImpl)arg1;
        ConnectionFactory factory = (ConnectionFactory)arg2;
        Connection connection = factory.createConnection(cn.url, cn.mode, cn.timeouts);
        if (cn.hasListeners()) {
            cn.notifyCreated(connection);
        } else {
            cn.close();
        }
        return null;
    }
}

