/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.coordinator;

import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import org.eclipse.equinox.coordinator.CoordinationTimerTask;
import org.eclipse.equinox.coordinator.CoordinatorImpl;
import org.eclipse.equinox.coordinator.Messages;
import org.osgi.framework.Bundle;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.CoordinationException;
import org.osgi.service.coordinator.Participant;
import org.osgi.service.log.LogService;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinationImpl
implements Coordination {
    private volatile Throwable failure;
    private volatile boolean terminated;
    private Date deadline;
    private Reference<CoordinationImpl> enclosingCoordination;
    private Thread thread;
    private TimerTask timerTask;
    private final CoordinatorImpl coordinator;
    private final long id;
    private final String name;
    private final List<Participant> participants;
    private final Map<Class<?>, Object> variables;

    public CoordinationImpl(long id, String name, long timeout, CoordinatorImpl coordinator) {
        CoordinationImpl.validateName(name);
        CoordinationImpl.validateTimeout(timeout);
        this.id = id;
        this.name = name;
        this.deadline = new Date(System.currentTimeMillis() + timeout);
        this.coordinator = coordinator;
        this.participants = Collections.synchronizedList(new ArrayList());
        this.variables = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addParticipant(Participant participant) throws CoordinationException {
        this.coordinator.checkPermission("participate", this.name);
        if (participant == null) {
            throw new NullPointerException(Messages.CoordinationImpl_15);
        }
        while (true) {
            CoordinationImpl coordination;
            CoordinationImpl coordinationImpl = this;
            synchronized (coordinationImpl) {
                this.checkTerminated();
                coordination = this.coordinator.addParticipant(participant, this);
                if (coordination == null) {
                    this.participants.add(participant);
                    break;
                }
                if (coordination == this) {
                    break;
                }
                Thread t = coordination.getThread();
                if (t == Thread.currentThread()) {
                    throw new CoordinationException(Messages.CoordinationImpl_1, this, 1);
                }
            }
            try {
                coordination.join(1000L);
            }
            catch (InterruptedException e) {
                this.coordinator.getLogService().log(4, Messages.CoordinationImpl_2, (Throwable)e);
                throw new CoordinationException(Messages.CoordinationImpl_3, this, 6, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void end() throws CoordinationException {
        this.coordinator.checkPermission("initiate", this.name);
        CoordinationImpl coordinationImpl = this;
        synchronized (coordinationImpl) {
            if (this.thread != null) {
                if (this.thread != Thread.currentThread()) {
                    throw new CoordinationException(Messages.CoordinationImpl_14, this, 7);
                }
                while (true) {
                    if (this.coordinator.peek() == this) {
                        this.coordinator.pop();
                        break;
                    }
                    try {
                        this.coordinator.peek().end();
                    }
                    catch (CoordinationException e) {
                        this.coordinator.peek().fail(e);
                    }
                }
            }
            this.terminate();
        }
        Exception exception = null;
        for (Participant participant : this.participants) {
            try {
                participant.ended(this);
            }
            catch (Exception e) {
                this.coordinator.getLogService().log(2, Messages.CoordinationImpl_4, (Throwable)e);
                if (exception != null) continue;
                exception = e;
            }
        }
        CoordinationImpl coordinationImpl2 = this;
        synchronized (coordinationImpl2) {
            this.notifyAll();
        }
        if (exception != null) {
            throw new CoordinationException(Messages.CoordinationImpl_5, this, 3, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long extendTimeout(long timeInMillis) throws CoordinationException {
        this.coordinator.checkPermission("participate", this.name);
        CoordinationImpl.validateTimeout(timeInMillis);
        CoordinationImpl coordinationImpl = this;
        synchronized (coordinationImpl) {
            block8: {
                this.checkTerminated();
                if (this.timerTask != null) break block8;
                return 0L;
            }
            if (timeInMillis == 0L) {
                return this.deadline.getTime();
            }
            boolean cancelled = this.timerTask.cancel();
            if (!cancelled) {
                try {
                    this.join(0L);
                    this.checkTerminated();
                }
                catch (InterruptedException e) {
                    throw new CoordinationException(Messages.CoordinationImpl_13, this, 0, e);
                }
            }
            this.timerTask = new CoordinationTimerTask(this);
            this.deadline = new Date(this.deadline.getTime() + timeInMillis);
            this.coordinator.schedule(this.timerTask, this.deadline);
            return this.deadline.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fail(Throwable reason) {
        this.coordinator.checkPermission("participate", this.name);
        if (reason == null) {
            throw new NullPointerException(Messages.CoordinationImpl_11);
        }
        CoordinationImpl coordinationImpl = this;
        synchronized (coordinationImpl) {
            block11: {
                if (!this.terminated) break block11;
                return false;
            }
            this.terminate();
            this.failure = reason;
        }
        for (Participant participant : this.participants) {
            try {
                participant.failed(this);
            }
            catch (Exception e) {
                this.coordinator.getLogService().log(2, Messages.CoordinationImpl_6, (Throwable)e);
            }
        }
        coordinationImpl = this;
        synchronized (coordinationImpl) {
            this.notifyAll();
        }
        return true;
    }

    @Override
    public Bundle getBundle() {
        this.coordinator.checkPermission("admin", this.name);
        return this.coordinator.getBundle();
    }

    @Override
    public synchronized Coordination getEnclosingCoordination() {
        this.coordinator.checkPermission("admin", this.name);
        return this.enclosingCoordination == null ? null : this.enclosingCoordination.get();
    }

    @Override
    public Throwable getFailure() {
        this.coordinator.checkPermission("initiate", this.name);
        return this.failure;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Participant> getParticipants() {
        this.coordinator.checkPermission("initiate", this.name);
        List<Participant> list = this.participants;
        synchronized (list) {
            return new ArrayList<Participant>(this.participants);
        }
    }

    @Override
    public synchronized Thread getThread() {
        this.coordinator.checkPermission("admin", this.name);
        return this.thread;
    }

    @Override
    public Map<Class<?>, Object> getVariables() {
        this.coordinator.checkPermission("participate", this.name);
        return this.variables;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join(long timeInMillis) throws InterruptedException {
        this.coordinator.checkPermission("participate", this.name);
        long start = System.currentTimeMillis();
        CoordinationImpl coordinationImpl = this;
        synchronized (coordinationImpl) {
            while (!this.terminated) {
                this.wait(timeInMillis);
                long elapsed = System.currentTimeMillis() - start;
                if (elapsed > timeInMillis) break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Coordination push() throws CoordinationException {
        this.coordinator.checkPermission("initiate", this.name);
        CoordinationImpl coordinationImpl = this;
        synchronized (coordinationImpl) {
            this.checkTerminated();
            this.coordinator.push(this);
        }
        return this;
    }

    synchronized Date getDeadline() {
        return this.deadline;
    }

    LogService getLogService() {
        return this.coordinator.getLogService();
    }

    synchronized void setTimerTask(TimerTask timerTask) {
        this.timerTask = timerTask;
    }

    synchronized void setThreadAndEnclosingCoordination(Thread t, Reference<CoordinationImpl> c) {
        this.thread = t;
        this.enclosingCoordination = c;
    }

    private void checkTerminated() throws CoordinationException {
        if (!this.terminated) {
            return;
        }
        if (this.failure != null) {
            throw new CoordinationException(Messages.CoordinationImpl_7, this, 2, this.failure);
        }
        throw new CoordinationException(Messages.CoordinationImpl_8, this, 4);
    }

    private void terminate() throws CoordinationException {
        this.checkTerminated();
        this.terminated = true;
        if (this.timerTask != null && this.timerTask.cancel()) {
            this.coordinator.purge();
        }
        this.coordinator.terminate(this, this.participants);
    }

    private static void validateName(String name) {
        boolean valid = true;
        if (name == null || name.length() == 0) {
            valid = false;
        } else {
            boolean period = false;
            char[] cArray = name.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (Character.isLetterOrDigit(c) || c == '_' || c == '-') {
                    period = false;
                } else if (c == '.' && !period) {
                    period = true;
                } else {
                    valid = false;
                    break;
                }
                ++n2;
            }
        }
        if (!valid) {
            throw new IllegalArgumentException(Messages.CoordinationImpl_10);
        }
    }

    private static void validateTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException(Messages.CoordinationImpl_12);
        }
    }
}

