/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.equinox.metatype.LocalizationElement;
import org.eclipse.equinox.metatype.MetaTypeMsg;
import org.eclipse.equinox.metatype.ValueTokenizer;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.AttributeDefinition;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeDefinitionImpl
extends LocalizationElement
implements AttributeDefinition,
Cloneable {
    String _name;
    String _id;
    String _description;
    int _cardinality = 0;
    int _dataType;
    Object _minValue = null;
    Object _maxValue = null;
    boolean _isRequired = true;
    String[] _defaults = null;
    Vector<String> _values = new Vector(7);
    Vector<String> _labels = new Vector(7);
    private final LogService logger;

    public AttributeDefinitionImpl(String id, String name, String description, int type, int cardinality, Object min, Object max, boolean isRequired, String localization, LogService logger) {
        this._id = id;
        this._name = name;
        this._description = description;
        this._dataType = type;
        this._cardinality = cardinality;
        this._minValue = min;
        this._maxValue = max;
        this._isRequired = isRequired;
        this._localization = localization;
        this.logger = logger;
    }

    public synchronized Object clone() {
        AttributeDefinitionImpl ad = new AttributeDefinitionImpl(this._id, this._name, this._description, this._dataType, this._cardinality, this._minValue, this._maxValue, this._isRequired, this._localization, this.logger);
        if (this._defaults != null) {
            ad.setDefaultValue((String[])this._defaults.clone());
        }
        if (this._labels != null && this._values != null) {
            Vector labels = (Vector)this._labels.clone();
            Vector values = (Vector)this._values.clone();
            ad.setOption(labels, values, false);
        }
        return ad;
    }

    public String getName() {
        return this.getLocalized(this._name);
    }

    void setName(String name) {
        this._name = name;
    }

    public String getID() {
        return this._id;
    }

    void setID(String id) {
        this._id = id;
    }

    public String getDescription() {
        return this.getLocalized(this._description);
    }

    void setDescription(String description) {
        this._description = description;
    }

    public int getCardinality() {
        return this._cardinality;
    }

    void setCardinality(int cardinality) {
        this._cardinality = cardinality;
    }

    public int getType() {
        return this._dataType;
    }

    void setType(int type) {
        this._dataType = type;
    }

    boolean isRequired() {
        return this._isRequired;
    }

    void setRequired(boolean isRequired) {
        this._isRequired = isRequired;
    }

    public String[] getOptionLabels() {
        if (this._labels == null || this._labels.size() == 0) {
            return null;
        }
        String[] returnedLabels = new String[this._labels.size()];
        Enumeration<String> labelKeys = this._labels.elements();
        int i = 0;
        while (labelKeys.hasMoreElements()) {
            String labelKey = labelKeys.nextElement();
            returnedLabels[i] = this.getLocalized(labelKey);
            ++i;
        }
        return returnedLabels;
    }

    public String[] getOptionValues() {
        if (this._values == null || this._values.size() == 0) {
            return null;
        }
        return this._values.toArray(new String[this._values.size()]);
    }

    void setOption(Vector<String> labels, Vector<String> values, boolean needValidation) {
        if (labels == null || values == null) {
            this.logger.log(1, new StringBuffer("AttributeDefinitionImpl.setOption(Vector, Vector, boolean) ").append(MetaTypeMsg.NULL_OPTIONS).toString());
            return;
        }
        if (labels.size() != values.size()) {
            this.logger.log(1, new StringBuffer("AttributeDefinitionImpl.setOption(Vector, Vector, boolean) ").append(MetaTypeMsg.INCONSISTENT_OPTIONS).toString());
            return;
        }
        this._labels = labels;
        this._values = values;
        if (needValidation) {
            int index = 0;
            while (index < this._values.size()) {
                ValueTokenizer vt = new ValueTokenizer(this._values.get(index), this.logger);
                this._values.set(index, vt.getValuesAsString());
                String reason = vt.validate(this);
                if (reason != null && reason.length() > 0) {
                    this.logger.log(2, NLS.bind((String)MetaTypeMsg.INVALID_OPTIONS, (Object)this._values.get(index), (Object)reason));
                    this._labels.remove(index);
                    this._values.remove(index);
                    --index;
                }
                ++index;
            }
        }
    }

    public String[] getDefaultValue() {
        return this._defaults;
    }

    void setDefaultValue(String defaults_str, boolean needValidation) {
        ValueTokenizer vt = new ValueTokenizer(defaults_str, this.logger);
        String reason = vt.validate(this);
        if (reason != null && reason.length() > 0) {
            this.logger.log(2, NLS.bind((String)MetaTypeMsg.INVALID_DEFAULTS, (Object)vt.getValuesAsString(), (Object)reason));
            return;
        }
        this.setDefaultValue(vt.getValuesAsArray());
    }

    void setDefaultValue(String[] defaults) {
        this._defaults = defaults;
    }

    void setMinValue(Object minValue) {
        this._minValue = minValue;
    }

    void setMaxValue(Object maxValue) {
        this._maxValue = maxValue;
    }

    public String validate(String value) {
        ValueTokenizer vt = new ValueTokenizer(value, this.logger);
        return vt.validate(this);
    }
}

