/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.client.ui.contributionsview;

import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import org.eclipse.equinox.jmx.internal.client.Activator;
import org.eclipse.equinox.jmx.internal.client.MBeanServerProxy;
import org.eclipse.equinox.jmx.internal.client.ui.actions.ActionMessages;
import org.eclipse.equinox.jmx.internal.client.ui.contributionsview.ContributionContentProvider;
import org.eclipse.equinox.jmx.internal.client.ui.contributionsview.ContributionLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

public class ContributionsViewPart
extends ViewPart {
    protected TreeViewer viewer;
    protected ContributionContentProvider contentProvider;
    protected ContributionLabelProvider labelProvider;
    protected MBeanServerProxy serverProxy;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 772);
        this.viewer.setUseHashlookup(true);
        this.viewer.setSorter(new ViewerSorter());
        this.setProviders();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    protected ContributionContentProvider createContentProvider() {
        return new ContributionContentProvider(this.viewer, null);
    }

    protected ContributionLabelProvider createLabelProvider() {
        return new ContributionLabelProvider();
    }

    protected void setProviders() {
        this.contentProvider = this.createContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = this.createLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public void setMBeanServerProxy(MBeanServerProxy proxy) {
        this.serverProxy = proxy;
        try {
            this.contentProvider.setServerContributionProxy(proxy);
            this.updateViewer();
        }
        catch (Exception e) {
            Activator.logError(e);
        }
    }

    public MBeanServerProxy getMBeanServerProxy() {
        return this.serverProxy;
    }

    public void dispose() {
        super.dispose();
    }

    public void connectionClosed(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)ActionMessages.info_message, (String)message);
    }

    private void updateViewer() throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, NotCompliantMBeanException {
        if (this.serverProxy == null) {
            this.viewer.setSelection(null);
            this.viewer.setInput(null);
            return;
        }
        this.viewer.setInput((Object)this.serverProxy.getRootContribution());
    }
}

