/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.transforms;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.equinox.internal.transforms.TransformTuple;
import org.eclipse.equinox.internal.transforms.TransformerHook;

public class CSVParser {
    public static TransformTuple[] parse(URL transformMapURL) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(transformMapURL.openStream()));
        String currentLine = null;
        ArrayList<TransformTuple> list = new ArrayList<TransformTuple>();
        while ((currentLine = reader.readLine()) != null) {
            if (currentLine.startsWith("#") || (currentLine = currentLine.trim()).length() == 0) continue;
            StringTokenizer toker = new StringTokenizer(currentLine, ",");
            try {
                String bundlePatternString = toker.nextToken().trim();
                String pathPatternString = toker.nextToken().trim();
                String transformPath = toker.nextToken().trim();
                try {
                    Pattern bundlePattern = Pattern.compile(bundlePatternString);
                    Pattern pathPattern = Pattern.compile(pathPatternString);
                    URL transformerURL = new URL(transformMapURL, transformPath);
                    try {
                        transformerURL.openStream();
                        TransformTuple tuple = new TransformTuple();
                        tuple.bundlePattern = bundlePattern;
                        tuple.pathPattern = pathPattern;
                        tuple.transformerUrl = transformerURL;
                        list.add(tuple);
                    }
                    catch (IOException e) {
                        TransformerHook.log(4, "Could not add transform :" + transformerURL.toString(), e);
                    }
                }
                catch (PatternSyntaxException e) {
                    TransformerHook.log(4, "Could not add compile transform matching regular expression", e);
                }
            }
            catch (NoSuchElementException e) {
                TransformerHook.log(4, "Could not parse transform file record :" + currentLine, e);
            }
        }
        return list.toArray(new TransformTuple[list.size()]);
    }
}

