/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.ResourceMarker;
import org.eclipse.gmf.internal.xpand.model.AdvicedDefinition;
import org.eclipse.gmf.internal.xpand.model.AmbiguousDefinitionException;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.Scope;
import org.eclipse.gmf.internal.xpand.model.Variable;
import org.eclipse.gmf.internal.xpand.model.XpandAdvice;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.model.XpandResource;
import org.eclipse.gmf.internal.xpand.util.PolymorphicResolver;
import org.eclipse.gmf.internal.xpand.util.TypeNameUtil;
import org.eclipse.gmf.internal.xpand.xtend.ast.QvtExtension;
import org.eclipse.gmf.internal.xpand.xtend.ast.QvtResource;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTParsingOptions;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ImportToNonTransformCtxHelper;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtOperationalEvaluationVisitor;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtOperationalEvaluationVisitorImpl;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.OCLEnvironmentWithQVTAccessFactory;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEvaluationEnvironment;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;

public final class ExecutionContextImpl
implements ExecutionContext {
    private final Map<String, Variable> variables = new HashMap<String, Variable>();
    private final Scope scope;
    private final ResourceMarker currentResource;
    private Set<QvtExtension> allExtensions;
    private OCLEnvironmentWithQVTAccessFactory envFactory;
    private EcoreEnvironment environment;

    public ExecutionContextImpl(Scope rootScope) {
        this(rootScope, null, null);
    }

    public ExecutionContextImpl(Scope rootScope, ResourceMarker resource, Collection<Variable> variables) {
        assert (rootScope != null);
        this.scope = rootScope;
        this.currentResource = resource;
        if (variables != null) {
            for (Variable v : variables) {
                this.variables.put(v.getName(), v);
            }
        }
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    @Override
    public Variable getImplicitVariable() {
        return this.variables.get("this");
    }

    @Override
    public ExecutionContext cloneWithVariable(Variable ... vars) {
        ExecutionContextImpl result = new ExecutionContextImpl(this.scope, this.currentResource, this.variables.values());
        result.envFactory = this.envFactory;
        result.allExtensions = this.allExtensions;
        result.environment = null;
        Variable[] variableArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            Variable v = variableArray[n2];
            result.variables.put(v.getName(), v);
            ++n2;
        }
        return result;
    }

    @Override
    public ExecutionContext cloneWithResource(ResourceMarker ns) {
        if (ns == this.currentResource) {
            return this;
        }
        ExecutionContextImpl result = new ExecutionContextImpl(this.scope, ns, this.variables.values());
        result.envFactory = null;
        result.environment = null;
        result.allExtensions = null;
        return result;
    }

    public ResourceMarker currentResource() {
        return this.currentResource;
    }

    private String[] getImportedExtensions() {
        return this.currentResource == null ? new String[]{} : this.currentResource.getImportedExtensions();
    }

    @Override
    public Set<QvtExtension> getAllExtensions() {
        if (this.allExtensions == null) {
            String[] extensions;
            this.allExtensions = new HashSet<QvtExtension>();
            String[] stringArray = extensions = this.getImportedExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                QvtResource qvtResource = this.getScope().findExtension(extension);
                if (qvtResource != null) {
                    ExecutionContext ctx = this.cloneWithResource(qvtResource);
                    List<QvtExtension> extensionList = qvtResource.getExtensions();
                    if (extensionList != null) {
                        for (QvtExtension element : extensionList) {
                            element.init(ctx);
                            this.allExtensions.add(element);
                        }
                    }
                }
                ++n2;
            }
        }
        return this.allExtensions;
    }

    @Override
    public XpandDefinition findDefinition(String name, EClassifier target, EClassifier[] paramTypes) throws AmbiguousDefinitionException {
        XpandAdvice adv;
        boolean localCall = !TypeNameUtil.isQualifiedName(name);
        String templateName = localCall ? ((XpandResource)this.currentResource()).getFullyQualifiedName() : TypeNameUtil.withoutLastSegment(name);
        XpandResource tpl = this.findTemplate(templateName);
        if (tpl == null) {
            if (localCall) {
                tpl = (XpandResource)this.currentResource();
            } else {
                return null;
            }
        }
        ExecutionContext ctx = this.cloneWithResource(tpl);
        XpandDefinition def = ExecutionContextImpl.findDefinition(tpl.getDefinitions(), name, target, paramTypes, ctx);
        if (def == null) {
            return null;
        }
        XpandAdvice[] advicesInResource = tpl.getAdvices();
        int x = advicesInResource.length - 1;
        while (x >= 0) {
            adv = advicesInResource[x];
            if (adv.matches(def, this)) {
                def = new AdvicedDefinition(adv, def);
            }
            --x;
        }
        x = this.scope.getAdvices().size() - 1;
        while (x >= 0) {
            adv = this.scope.getAdvices().get(x);
            if (adv.matches(def, this)) {
                def = new AdvicedDefinition(adv, def);
            }
            --x;
        }
        return def;
    }

    private XpandResource findTemplate(String templateName) {
        if (this.currentResource() instanceof XpandResource) {
            String contextTemplate = ((XpandResource)this.currentResource()).getFullyQualifiedName();
            return this.scope.findTemplate(templateName, contextTemplate);
        }
        return this.scope.findTemplate(templateName);
    }

    private static XpandDefinition findDefinition(XpandDefinition[] definitions, String name, EClassifier target, EClassifier[] paramTypes, ExecutionContext ctx) throws AmbiguousDefinitionException {
        if (paramTypes == null) {
            paramTypes = new EClassifier[]{};
        }
        String unqualifiedName = TypeNameUtil.getLastSegment(name);
        HashMap<XpandDefinition, List<EClassifier>> resolvedDefs = new HashMap<XpandDefinition, List<EClassifier>>();
        XpandDefinition[] xpandDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            XpandDefinition def = xpandDefinitionArray[n2];
            if (def.getName().equals(unqualifiedName) && def.getParams().length == paramTypes.length) {
                LinkedList<EClassifier> defsParamTypes = new LinkedList<EClassifier>();
                EClassifier t = null;
                boolean complete = true;
                int j = 0;
                while (j < paramTypes.length && complete) {
                    t = def.getParams()[j].getTypeForName(ctx);
                    if (t == null) {
                        complete = false;
                    }
                    defsParamTypes.add(t);
                    ++j;
                }
                t = def.getTargetType().getTypeForName(ctx);
                if (t == null) {
                    complete = false;
                } else {
                    defsParamTypes.addFirst(t);
                }
                if (complete) {
                    resolvedDefs.put(def, defsParamTypes);
                }
            }
            ++n2;
        }
        return PolymorphicResolver.filterDefinition(resolvedDefs, target, Arrays.asList(paramTypes), ctx.getOCLEnvironment());
    }

    @Override
    public EcoreEnvironment getOCLEnvironment() {
        if (this.environment != null) {
            return this.environment;
        }
        if (this.envFactory == null) {
            this.envFactory = new OCLEnvironmentWithQVTAccessFactory(this.getImportedModules(), this.getAllVisibleModels());
        }
        this.environment = (EcoreEnvironment)this.envFactory.createEnvironment();
        ParsingOptions.setOption((Environment)this.environment, (Option)QVTParsingOptions.ENFORCE_EXPLICIT_SELF_VARIABLE, (Object)Boolean.FALSE);
        ParsingOptions.setOption((Environment)this.environment, (Option)ParsingOptions.implicitRootClass((Environment)this.environment), (Object)EcorePackage.Literals.EOBJECT);
        Variable that = this.getImplicitVariable();
        for (Variable v : this.variables.values()) {
            if (that == v) continue;
            org.eclipse.ocl.ecore.Variable oclVar = EcoreFactory.eINSTANCE.createVariable();
            oclVar.setName(v.getName());
            if (v.getType() == null) {
                oclVar.setType((Object)BuiltinMetaModel.getType(this, v.getValue()));
            } else {
                oclVar.setType((Object)v.getType());
            }
            this.environment.addElement(oclVar.getName(), (org.eclipse.ocl.expressions.Variable)oclVar, true);
        }
        if (that != null) {
            EClassifier type = that.getType() == null ? BuiltinMetaModel.getType(this, that.getValue()) : that.getType();
            this.environment = (EcoreEnvironment)this.envFactory.createClassifierContext((Environment)this.environment, (Object)type);
        }
        return this.environment;
    }

    @Override
    public QvtOperationalEvaluationVisitor createEvaluationVisitor() {
        QvtOperationalEvaluationEnv evaluationEnv = (QvtOperationalEvaluationEnv)this.createEvaluationEnvironment();
        ImportToNonTransformCtxHelper importsHelper = this.scope.getImportsHelper();
        for (Module module : this.getImportedModules()) {
            importsHelper.addImportedModule(module);
        }
        return QvtOperationalEvaluationVisitorImpl.createNonTransformationExecutionContextVisitor((QvtOperationalEnv)QvtOperationalEnvFactory.INSTANCE.createEnvironment(), (QvtOperationalEvaluationEnv)evaluationEnv, (ImportToNonTransformCtxHelper)importsHelper);
    }

    private Set<Module> getImportedModules() {
        String[] extensions;
        LinkedHashSet<Module> importedModules = new LinkedHashSet<Module>();
        String[] stringArray = extensions = this.getImportedExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            QvtResource qvtResource = this.getScope().findExtension(extension);
            if (qvtResource != null) {
                importedModules.addAll(qvtResource.getModules());
            }
            ++n2;
        }
        return importedModules;
    }

    private EcoreEvaluationEnvironment createEvaluationEnvironment() {
        if (this.envFactory == null) {
            this.getOCLEnvironment();
        }
        QvtOperationalEvaluationEnv ee = QvtOperationalEnvFactory.INSTANCE.createEvaluationEnvironment((IContext)new Context(), null);
        Variable that = this.getImplicitVariable();
        for (Variable v : this.variables.values()) {
            if (that == v) continue;
            ee.add(v.getName(), v.getValue());
        }
        if (that != null) {
            ee.add("self", that.getValue());
        }
        return ee;
    }

    private String[] getImportedNamespaces() {
        return this.currentResource == null ? new String[]{} : this.currentResource.getImportedNamespaces();
    }

    public EPackage.Registry getAllVisibleModels() {
        return this.getScope().createPackageRegistry(this.getImportedNamespaces());
    }
}

