/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.properties;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.runtime.lite.parts.CommandStackAdapterManager;
import org.eclipse.gmf.runtime.lite.properties.PropertySourceProvider;
import org.eclipse.gmf.runtime.lite.properties.RootUndoablePropertySheetEntry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AdvancedPropertySection
extends org.eclipse.ui.views.properties.tabbed.AdvancedPropertySection {
    private PropertySourceProvider myPropertySourceProvider;
    private RootUndoablePropertySheetEntry myPropertySheetEntry;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.myPropertySheetEntry = new RootUndoablePropertySheetEntry(null, this.page);
        this.myPropertySheetEntry.setPropertySourceProvider(this.getPropertySourceProvider());
        this.page.setRootEntry((IPropertySheetEntry)this.myPropertySheetEntry);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof StructuredSelection)) {
            super.setInput(part, selection);
            return;
        }
        StructuredSelection structuredSelection = (StructuredSelection)selection;
        ArrayList<Object> transformedSelection = new ArrayList<Object>(structuredSelection.size());
        Iterator it = structuredSelection.iterator();
        while (it.hasNext()) {
            Object r = this.transformSelection(it.next());
            if (r == null) continue;
            transformedSelection.add(r);
        }
        CommandStack commandStack = this.getCommandStack(transformedSelection);
        this.myPropertySheetEntry.setCommandStack(commandStack);
        super.setInput(part, (ISelection)new StructuredSelection(transformedSelection));
    }

    protected CommandStack getCommandStack(ArrayList<?> selection) {
        CommandStack result = null;
        for (Object next : selection) {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain(next);
            if (editingDomain == null) {
                return null;
            }
            CommandStack nextStackCandidate = AdvancedPropertySection.getCommandStack(editingDomain);
            if (nextStackCandidate == null) {
                return null;
            }
            if (result == null) {
                result = nextStackCandidate;
                continue;
            }
            if (result == nextStackCandidate) continue;
            return null;
        }
        return result;
    }

    static CommandStack getCommandStack(TransactionalEditingDomain editingDomain) {
        if (editingDomain == null) {
            return null;
        }
        CommandStackAdapterManager adapterManager = (CommandStackAdapterManager)EcoreUtil.getExistingAdapter((Notifier)editingDomain.getResourceSet(), CommandStackAdapterManager.class);
        if (adapterManager == null || adapterManager.isReleased()) {
            return null;
        }
        return adapterManager.getCommandStack();
    }

    protected PropertySourceProvider getPropertySourceProvider() {
        if (this.myPropertySourceProvider == null) {
            this.myPropertySourceProvider = new PropertySourceProvider(this.getItemProvidersAdapterFactory());
        }
        return this.myPropertySourceProvider;
    }

    protected abstract AdapterFactory getItemProvidersAdapterFactory();

    protected Object transformSelection(Object selected) {
        return selected;
    }

    public void refresh() {
        this.page.refresh();
    }
}

