/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.edit.parts.update.canonical;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.lite.commands.CreateNotationalElementCommand;
import org.eclipse.gmf.runtime.lite.edit.parts.update.canonical.ElementDescriptor;
import org.eclipse.gmf.runtime.lite.edit.parts.update.canonical.INotationModelRefresher;
import org.eclipse.gmf.runtime.notation.View;

public abstract class AbstractNotationModelRefresher
extends ResourceSetListenerImpl
implements INotationModelRefresher {
    private NotificationFilter myFilter = this.createFilter();
    private TransactionalEditingDomain myEditingDomain;

    @Override
    public final View getView() {
        return this.getHost();
    }

    public void install(TransactionalEditingDomain editingDomain) {
        if (this.myEditingDomain != null && !this.myEditingDomain.equals(editingDomain)) {
            throw new IllegalStateException("Already listening to another editing domain");
        }
        this.myEditingDomain = editingDomain;
        this.myEditingDomain.addResourceSetListener((ResourceSetListener)this);
    }

    public boolean isInstalled() {
        return this.myEditingDomain != null;
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.myEditingDomain.removeResourceSetListener((ResourceSetListener)this);
            this.myEditingDomain = null;
        }
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) {
        if (this.shouldHandleNotification(event)) {
            return this.buildRefreshNotationModelCommand();
        }
        return null;
    }

    public NotificationFilter getFilter() {
        return this.myFilter;
    }

    @Override
    public abstract Command buildRefreshNotationModelCommand();

    private boolean shouldHandleNotification(ResourceSetChangeEvent event) {
        if (this.getHost() == null || this.getHost().getElement() == null) {
            return false;
        }
        for (Notification next : event.getNotifications()) {
            if (!this.shouldHandleNotification(next)) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldHandleNotification(Notification nofitication) {
        return true;
    }

    protected int getVisualID(View view) {
        try {
            return Integer.parseInt(view.getType());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected abstract CreateNotationalElementCommand getCreateNotationalElementCommand(ElementDescriptor var1);

    protected abstract NotificationFilter createFilter();

    protected abstract boolean shouldCreateView(ElementDescriptor var1);

    protected abstract View getHost();
}

