/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.lite.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.GenChildContainer;
import org.eclipse.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.gmf.codegen.gmfgen.util.GMFGenSwitch;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.ocl.util.CollectionUtil;

public class SemanticSyncUtils {
    private static WeakHashMap<GenContainerBase, Map<GenFeature, Collection<GenNode>>> myFeature2NodesCache = new WeakHashMap();
    private static WeakHashMap<GenCommonBase, Map<GenFeature, Collection<GenLink>>> myFeature2TypeLinksCache = new WeakHashMap();
    private static WeakHashMap<GenCommonBase, Map<GenFeature, Collection<GenLink>>> myFeature2FeatureLinksCache = new WeakHashMap();

    @Operation(contextual=false, kind=Operation.Kind.HELPER)
    public static Collection<GenNode> getGenNodes(GenContainerBase genContainerBase, GenFeature genFeature) {
        Collection<GenNode> result = SemanticSyncUtils.getGenChildFeature2genNodeMap(genContainerBase).get(genFeature);
        if (result == null) {
            return CollectionUtil.createNewBag(Collections.emptyList());
        }
        return CollectionUtil.createNewBag(result);
    }

    private static Map<GenFeature, Collection<GenNode>> getGenChildFeature2genNodeMap(GenContainerBase genContainerBase) {
        Map<GenFeature, Collection<GenNode>> result = myFeature2NodesCache.get(genContainerBase);
        if (result == null) {
            result = SemanticSyncUtils.buildGenChildFeature2genNodeMap(genContainerBase);
            myFeature2NodesCache.put(genContainerBase, result);
        }
        return result;
    }

    private static Map<GenFeature, Collection<GenNode>> buildGenChildFeature2genNodeMap(GenContainerBase genContainerBase) {
        LinkedHashMap<GenFeature, Collection<GenNode>> result = new LinkedHashMap<GenFeature, Collection<GenNode>>();
        Collection childNodes = (Collection)new GMFGenSwitch<Collection<? extends GenNode>>(){

            public Collection<? extends GenNode> caseGenDiagram(GenDiagram object) {
                return object.getTopLevelNodes();
            }

            public Collection<? extends GenNode> caseGenChildContainer(GenChildContainer object) {
                return object.getChildNodes();
            }
        }.doSwitch((EObject)genContainerBase);
        for (GenNode nextNode : childNodes) {
            TypeModelFacet typeModelFacet = nextNode.getModelFacet();
            if (typeModelFacet == null) continue;
            GenFeature childMetaFeature = typeModelFacet.getChildMetaFeature();
            if (!result.containsKey(childMetaFeature)) {
                result.put(childMetaFeature, new ArrayList());
            }
            ((Collection)result.get(childMetaFeature)).add(nextNode);
        }
        return result;
    }

    @Operation(contextual=false, kind=Operation.Kind.HELPER)
    public static Collection<GenLink> getTypeGenLinksForFeature(GenCommonBase container, GenFeature feature, Collection<GenLink> containedLinks) {
        Collection<GenLink> result = SemanticSyncUtils.getGenChildFeature2TypeGenLinkMap(container, containedLinks).get(feature);
        if (result == null) {
            return CollectionUtil.createNewBag(Collections.emptyList());
        }
        return CollectionUtil.createNewBag(result);
    }

    @Operation(contextual=false, kind=Operation.Kind.HELPER)
    public static Collection<GenLink> getFeatureGenLinksForFeature(GenCommonBase container, GenFeature feature, Collection<GenLink> containedLinks) {
        Collection<GenLink> result = SemanticSyncUtils.getGenChildFeature2FeatureGenLinkMap(container, containedLinks).get(feature);
        if (result == null) {
            return CollectionUtil.createNewBag(Collections.emptyList());
        }
        return CollectionUtil.createNewBag(result);
    }

    private static Map<GenFeature, Collection<GenLink>> getGenChildFeature2TypeGenLinkMap(GenCommonBase container, Collection<GenLink> containedLinks) {
        if (!myFeature2TypeLinksCache.containsKey(container)) {
            SemanticSyncUtils.buildGenChildFeature2LinkMaps(container, containedLinks);
        }
        return myFeature2TypeLinksCache.get(container);
    }

    private static Map<GenFeature, Collection<GenLink>> getGenChildFeature2FeatureGenLinkMap(GenCommonBase container, Collection<GenLink> containedLinks) {
        if (!myFeature2FeatureLinksCache.containsKey(container)) {
            SemanticSyncUtils.buildGenChildFeature2LinkMaps(container, containedLinks);
        }
        return myFeature2FeatureLinksCache.get(container);
    }

    private static void buildGenChildFeature2LinkMaps(GenCommonBase container, Collection<GenLink> containedLinks) {
        final LinkedHashMap genFeature2TypeGenLinkMap = new LinkedHashMap();
        final LinkedHashMap genFeature2FeatureGenLinkMap = new LinkedHashMap();
        for (final GenLink genLink : containedLinks) {
            new GMFGenSwitch<Object>(){

                public Object caseTypeLinkModelFacet(TypeLinkModelFacet modelFacet) {
                    GenFeature metaFeature = modelFacet.getChildMetaFeature();
                    if (!genFeature2TypeGenLinkMap.containsKey(metaFeature)) {
                        genFeature2TypeGenLinkMap.put(metaFeature, new ArrayList());
                    }
                    ((Collection)genFeature2TypeGenLinkMap.get(metaFeature)).add(genLink);
                    return null;
                }

                public Object caseFeatureLinkModelFacet(FeatureLinkModelFacet modelFacet) {
                    GenFeature metaFeature = modelFacet.getMetaFeature();
                    if (!genFeature2FeatureGenLinkMap.containsKey(metaFeature)) {
                        genFeature2FeatureGenLinkMap.put(metaFeature, new ArrayList());
                    }
                    ((Collection)genFeature2FeatureGenLinkMap.get(metaFeature)).add(genLink);
                    return null;
                }
            }.doSwitch((EObject)genLink.getModelFacet());
        }
        myFeature2TypeLinksCache.put(container, genFeature2TypeGenLinkMap);
        myFeature2FeatureLinksCache.put(container, genFeature2FeatureGenLinkMap);
    }

    @Operation(contextual=false, kind=Operation.Kind.HELPER)
    public static Collection<GenCommonBase> buildAncestorClosure(Collection<GenCommonBase> elements) {
        LinkedHashSet<GenCommonBase> result = new LinkedHashSet<GenCommonBase>(elements);
        for (GenCommonBase next : elements) {
            SemanticSyncUtils.addAncestors(result, next);
        }
        return CollectionUtil.createNewBag(result);
    }

    private static void addAncestors(Collection<GenCommonBase> result, GenCommonBase next) {
        Collection ancestors = (Collection)new GMFGenSwitch<Collection<? extends GenCommonBase>>(){

            public Collection<? extends GenCommonBase> caseGenTopLevelNode(GenTopLevelNode object) {
                return Collections.singleton(object.getDiagram());
            }

            public Collection<? extends GenCommonBase> caseGenCompartment(GenCompartment object) {
                return Collections.singleton(object.getNode());
            }

            public Collection<? extends GenCommonBase> caseGenChildNode(GenChildNode object) {
                return object.getContainers();
            }

            public Collection<? extends GenCommonBase> caseGenLink(GenLink object) {
                return SemanticSyncUtils.getPossibleContainers(object);
            }

            public Collection<? extends GenCommonBase> defaultCase(EObject object) {
                return Collections.emptyList();
            }
        }.doSwitch((EObject)next);
        for (GenCommonBase nextAncestor : ancestors) {
            if (result.contains(nextAncestor)) continue;
            result.add(nextAncestor);
            SemanticSyncUtils.addAncestors(result, nextAncestor);
        }
    }

    private static Collection<? extends GenCommonBase> getPossibleContainers(GenLink link) {
        TypeLinkModelFacet facet;
        EClass containerClass = null;
        if (link.getModelFacet() instanceof TypeLinkModelFacet) {
            facet = (TypeLinkModelFacet)link.getModelFacet();
            if (facet.getContainmentMetaFeature() != null && facet.getContainmentMetaFeature().getGenClass() != null) {
                containerClass = ((TypeLinkModelFacet)link.getModelFacet()).getContainmentMetaFeature().getGenClass().getEcoreClass();
            }
        } else if (link.getModelFacet() instanceof FeatureLinkModelFacet && (facet = (FeatureLinkModelFacet)link.getModelFacet()).getMetaFeature() != null && facet.getMetaFeature().getGenClass() != null) {
            containerClass = facet.getMetaFeature().getGenClass().getEcoreClass();
        }
        if (containerClass == null) {
            return Collections.emptyList();
        }
        ArrayList<GenDiagram> result = new ArrayList<GenDiagram>();
        result.add(link.getDiagram());
        result.addAll((Collection<GenDiagram>)link.getDiagram().getAllNodes());
        result.addAll((Collection<GenDiagram>)link.getDiagram().getLinks());
        Iterator it = result.iterator();
        while (it.hasNext()) {
            GenCommonBase next = (GenCommonBase)it.next();
            GenClass effectiveMetaClass = SemanticSyncUtils.getEffectiveMetaClass(next);
            if (effectiveMetaClass != null && containerClass.isSuperTypeOf(effectiveMetaClass.getEcoreClass())) continue;
            it.remove();
        }
        return result;
    }

    private static GenClass getEffectiveMetaClass(GenCommonBase element) {
        return (GenClass)new GMFGenSwitch<GenClass>(){

            public GenClass caseGenDiagram(GenDiagram object) {
                return object.getDomainDiagramElement();
            }

            public GenClass caseGenNode(GenNode object) {
                return object.getDomainMetaClass();
            }

            public GenClass caseGenLink(GenLink object) {
                return (GenClass)this.doSwitch((EObject)object.getModelFacet());
            }

            public GenClass caseTypeLinkModelFacet(TypeLinkModelFacet object) {
                return object.getMetaClass();
            }
        }.doSwitch((EObject)element);
    }
}

