/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.security.authentication.basicauth;

import java.net.URLConnection;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.security.authentication.SecurityAccessInterceptor;
import net.sourceforge.plantuml.security.authentication.SecurityAuthentication;
import net.sourceforge.plantuml.utils.Base64Coder;

public class BasicAuthAccessInterceptor
implements SecurityAccessInterceptor {
    @Override
    public void apply(SecurityAuthentication authentication, URLConnection connection) {
        String auth = this.getAuth(authentication);
        String authorization = Base64Coder.encodeString(auth);
        String authHeaderValue = "Basic " + authorization;
        connection.setRequestProperty("Authorization", authHeaderValue);
    }

    private String getAuth(SecurityAuthentication authentication) {
        String id = (String)authentication.getTokens().get("identifier");
        char[] secret = (char[])authentication.getTokens().get("secret");
        StringBuilder auth = new StringBuilder();
        if (StringUtils.isNotEmpty(id)) {
            auth.append(id);
            if (secret != null && secret.length > 0) {
                auth.append(':').append(secret);
            }
        }
        return auth.toString();
    }
}

