/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sdot;

import h.ST_Agnode_s;
import h.ST_Agnodeinfo_t;
import h.ST_Agraphinfo_t;
import h.ST_boxf;
import h.ST_textlabel_t;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;

public class BoxInfo {
    private final XPoint2D upperRight;
    private final XPoint2D lowerLeft;

    private BoxInfo(XPoint2D upperRight, XPoint2D lowerLeft) {
        this.upperRight = upperRight;
        this.lowerLeft = lowerLeft;
    }

    public static BoxInfo fromTextlabel(ST_textlabel_t label) {
        double x = label.pos.x;
        double y = label.pos.y;
        double width = label.dimen.x;
        double height = label.dimen.y;
        XPoint2D upperRight = new XPoint2D(x + width / 2.0, y - height / 2.0);
        XPoint2D lowerLeft = new XPoint2D(x - width / 2.0, y + height / 2.0);
        return new BoxInfo(upperRight, lowerLeft);
    }

    public static BoxInfo fromNode(ST_Agnode_s node) {
        ST_Agnodeinfo_t data = (ST_Agnodeinfo_t)node.data;
        double width = data.width * 72.0;
        double height = data.height * 72.0;
        double x = data.coord.x;
        double y = data.coord.y;
        XPoint2D upperRight = new XPoint2D(x + width / 2.0, y - height / 2.0);
        XPoint2D lowerLeft = new XPoint2D(x - width / 2.0, y + height / 2.0);
        return new BoxInfo(upperRight, lowerLeft);
    }

    public XDimension2D getDimension() {
        double width = this.upperRight.getX() - this.lowerLeft.getX();
        double height = this.lowerLeft.getY() - this.upperRight.getY();
        return new XDimension2D(width, height);
    }

    public static BoxInfo fromGraphInfo(ST_Agraphinfo_t data) {
        ST_boxf bb = data.bb;
        double llx = bb.LL.x;
        double lly = bb.LL.y;
        double urx = bb.UR.x;
        double ury = bb.UR.y;
        XPoint2D upperRight = new XPoint2D(urx, ury);
        XPoint2D lowerLeft = new XPoint2D(llx, lly);
        return new BoxInfo(upperRight, lowerLeft);
    }

    public final XPoint2D getUpperRight() {
        return this.upperRight;
    }

    public final XPoint2D getLowerLeft() {
        return this.lowerLeft;
    }
}

