/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.timingdiagram.TimeTick;

public class ChangeState
implements Comparable<ChangeState> {
    private final TimeTick when;
    private final String[] states;
    private final String comment;
    private final Colors colors;

    public ChangeState(TimeTick when, String comment, Colors colors, String ... states) {
        if (states.length == 0) {
            throw new IllegalArgumentException();
        }
        this.when = when;
        this.states = states;
        this.comment = comment;
        this.colors = colors;
    }

    @Override
    public int compareTo(ChangeState other) {
        return this.when.compareTo(other.when);
    }

    public final TimeTick getWhen() {
        return this.when;
    }

    public final String getState() {
        return this.states[0];
    }

    public final List<String> getStates() {
        return Arrays.asList(this.states);
    }

    public String getComment() {
        return this.comment;
    }

    public final HColor getBackColor(ISkinParam skinParam, Style style) {
        if (this.colors == null || this.colors.getColor(ColorType.BACK) == null) {
            return style.value(PName.BackGroundColor).asColor(skinParam.getIHtmlColorSet());
        }
        return this.colors.getColor(ColorType.BACK);
    }

    private final HColor getLineColor(ISkinParam skinParam, Style style) {
        if (this.colors == null || this.colors.getColor(ColorType.LINE) == null) {
            return style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
        }
        return this.colors.getColor(ColorType.LINE);
    }

    private UStroke getStroke(Style style) {
        return style.getStroke();
    }

    public Fashion getContext(ISkinParam skinParam, Style style) {
        return new Fashion(this.getBackColor(skinParam, style), this.getLineColor(skinParam, style)).withStroke(this.getStroke(style));
    }

    public final boolean isBlank() {
        return this.states[0].equals("{...}");
    }

    public final boolean isCompletelyHidden() {
        return this.states[0].equals("{hidden}");
    }

    public final boolean isFlat() {
        return this.states[0].equals("{-}");
    }
}

